﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace DependencyAnalyzer.Dependency
{
    [Serializable()]
    public class Reference
    {
        public string Name { get; private set; }
        public string Description { get; private set; }
        public Module Client { get; set; }
        public Module Supplier { get; set; }

        // Location of where the module is used
        // Not the definition!
        public string SourceFile { get; private set; }
        public int SourceLine { get; private set; }

        public Reference(string name, string description, string source_file, int source_line)
        {
            this.Name = name;
            this.Description = description;
            this.SourceFile = source_file;
            this.SourceLine = source_line;
        }

        public Reference(SerializationInfo info, StreamingContext ctxt)
        {
            this.Name = (string)info.GetValue("Name", typeof(string));
            this.Description = (string)info.GetValue("Description", typeof(string));
            this.Client = (Module)info.GetValue("Client", typeof(Module));
            this.Supplier = (Module)info.GetValue("Supplier", typeof(Module));
            this.SourceFile = (string)info.GetValue("SourceFile", typeof(string));
            this.SourceLine = (int)info.GetValue("SourceLine", typeof(int));
        }

        public void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext)
        {
            serializationInfo.AddValue("Name", this.Name);
            serializationInfo.AddValue("Description", this.Description);
            serializationInfo.AddValue("Client", this.Client);
            serializationInfo.AddValue("Supplier", this.Supplier);
            serializationInfo.AddValue("SourceFile", this.SourceFile);
            serializationInfo.AddValue("SourceLine", this.SourceLine);
        }
    }
}
