﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using DependencyAnalyzer.Global;

namespace DependencyAnalyzer.Forms
{
    public partial class CreateProjectForm : Form
    {
        private ProjectInformation projectInfo;
        private string projectFolder;

        public CreateProjectForm(ProjectInformation projectInfo)
        {
            InitializeComponent();
            this.projectInfo = projectInfo;
        }

        private void CreateProjectFolder_Load(object sender, EventArgs e)
        {
            txtProjectFolder.Text = projectFolder = String.Format("{0}\\DAprojects", Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments));
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog.ShowDialog(this) == DialogResult.OK)
            {
                projectFolder = folderBrowserDialog.SelectedPath;
                txtProjectFolder.Text = cbSubFolder.Checked ? String.Format("{0}\\{1}", projectFolder, txtProjectName.Text) : projectFolder;
            }
        }

        private void cbSubFolder_CheckedChanged(object sender, EventArgs e)
        {
            txtProjectFolder.Text = cbSubFolder.Checked ? String.Format("{0}\\{1}", projectFolder, txtProjectName.Text) : projectFolder;
        }

        private void txtProjectName_TextChanged(object sender, EventArgs e)
        {
            int invalidCharPosition = txtProjectName.Text.LastIndexOfAny(Path.GetInvalidFileNameChars());
            if (invalidCharPosition >= 0)
            {
                txtProjectName.Text = txtProjectName.Text.Remove(invalidCharPosition, 1);
                txtProjectName.SelectionStart = invalidCharPosition;
            }

            if (cbSubFolder.Checked)
            {
                txtProjectFolder.Text = String.Format("{0}\\{1}", projectFolder, txtProjectName.Text);
            }

            btnOK.Enabled = (txtProjectName.Text.Length > 0);
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            projectInfo.projectName = txtProjectName.Text;
            projectInfo.projectPath = txtProjectFolder.Text;
            DialogResult = DialogResult.OK;
            Close();
        }
    }
}
