﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Microsoft.Win32;

namespace DependencyAnalyzer.Forms
{
    public partial class SolidSxPathForm : Form
    {
        private string solidSxPath;

        public SolidSxPathForm()
        {
            InitializeComponent();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                txtSolidSxPath.Text = solidSxPath = openFileDialog.FileName;

                //Write the filepath into the registry, so it will be loaded the next time automatically
                RegistryKey regKey = Registry.CurrentUser.CreateSubKey(Constants.REGISTRY_KEY);
                regKey.SetValue("SolidSxPath", solidSxPath);
                regKey.Close();

                btnOK.Enabled = true;
            }
        }

        private void SelectSolidSX_Load(object sender, EventArgs e)
        {
            string path = null;

            //Check if there is already a path in the registry
            RegistryKey regKey = Registry.CurrentUser.OpenSubKey(Constants.REGISTRY_KEY);
            if (regKey != null)
            {
                if (regKey.GetValue("SolidSxPath") != null)
                {
                    path = (string)regKey.GetValue("SolidSxPath");
                    regKey.Close();

                    //Remove the key if the file not exists
                    if (!File.Exists(path))
                    {
                        regKey = Registry.CurrentUser.CreateSubKey(Constants.REGISTRY_KEY);
                        regKey.DeleteValue("SolidSxPath");
                        path = null;
                    }
                    regKey.Close();
                }
            }

            if (path != null)
            {
                CheckPath(path);
            }
            else
            {
                //Check if default path is OK
                CheckPath(Constants.SOLIDSX_DEFAULT_PATH);
            }
        }

        private void CheckPath(string path)
        {
            if (File.Exists(path))
            {
                solidSxPath = path;
                DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            this.Close();
        }

        public string GetFilePath()
        {
            return solidSxPath;
        }
    }
}
