﻿using System;
using System.Collections.Generic;

namespace DependencyAnalyzer.SolidSX.XmlGenerator
{
    class Node
    {
        public enum NodeType { Directory, SourceFile, Internal, External, Module }
        public long ID { get; private set; }
        public string Name { get; private set; }
        public NodeType Type { get; private set; }
        public Node Parent { get; private set; }
        public List<Node> Children { get; private set; }

        public Node(long id, string name, Node parent, NodeType type)
        {
            this.ID = id;
            this.Name = name;
            this.Parent = parent;
            this.Type = type;
            this.Children = new List<Node>();
        }

        public bool Contains(string name)
        {
            return Get(name) != null;
        }

        public Node Get(string name)
        {
            Node foundNode = null;
            foreach (Node node in this.Children)
            {
                if (node.Name.Equals(name))
                {
                    foundNode = node;
                    break;
                }
            }
            return foundNode;
        }
    }
}
