﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using DependencyAnalyzer.SolidSX.XmlGenerator;
using DependencyAnalyzer.SolidSX.SQLiteGenerator;

namespace DependencyAnalyzer.Dependency
{
    [Serializable()]
    public class Module : ISerializable
    {
        public long ID { get; private set; }
        public string Name { get; private set; }
        public string SourceFile { get; private set; }
        public List<Method> Methods { get; private set; }
        public List<Reference> Clients { get; private set; }
        public List<Reference> Suppliers { get; private set; }

        public Module(long ID, string name, string sourceFile)
        {
            this.ID = ID;
            this.Name = name;
            this.SourceFile = sourceFile;
            this.Methods = new List<Method>();
            this.Clients = new List<Reference>();
            this.Suppliers = new List<Reference>();
        }

        public Module(SerializationInfo info, StreamingContext ctxt)
        {
            this.ID = (long)info.GetValue("ID", typeof(long));
            this.Name = (string)info.GetValue("Name", typeof(string));
            this.SourceFile = (string)info.GetValue("SourceFile", typeof(string));
            this.Clients = (List<Reference>)info.GetValue("Clients", typeof(List<Reference>));
            this.Suppliers = (List<Reference>)info.GetValue("Suppliers", typeof(List<Reference>));
        }

        public long GetSolidSxID()
        {
            return ID + SQLiteDataset.AMOUNT_OF_RESERVED_NODES;
        }

        public void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext)
        {
            serializationInfo.AddValue("ID", this.ID);
            serializationInfo.AddValue("Name", this.Name);
            serializationInfo.AddValue("SourceFile", this.SourceFile);
            serializationInfo.AddValue("Clients", this.Clients);
            serializationInfo.AddValue("Suppliers", this.Suppliers);
        }
    }
}
