﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using SharpSvn;
using SharpSvn.UI;
using System.Collections.ObjectModel;

namespace DependencyAnalyzer.Forms
{
    public partial class SvnRevisionForm : Form
    {
        private string uri;
        private string revision;

        public SvnRevisionForm(string uri)
        {
            this.uri = uri;
            InitializeComponent();
        }

        private void SvnRevisionForm_Load(object sender, EventArgs e)
        {
            DateTime lastChangedDate = GetLatestChangedDate(uri);
            lastChangedDate = lastChangedDate.AddMinutes(0 - lastChangedDate.Minute).AddHours(0 - lastChangedDate.Hour).AddSeconds(0 - lastChangedDate.Second).AddMilliseconds(0 - lastChangedDate.Millisecond);
            dateTimePickerBegin.MaxDate = lastChangedDate;
            dateTimePickerEnd.MaxDate = lastChangedDate;
            dateTimePickerBegin.Value = lastChangedDate.AddDays(-1);
            dateTimePickerEnd.Value = lastChangedDate;
            UpdateRevisionLog();
        }

        public string GetRevision()
        {
            return this.revision;
        }

        private DateTime GetLatestChangedDate(string uri)
        {
            using (SvnClient client = new SvnClient())
            {
                SvnInfoEventArgs info;
                Uri repos = new Uri(uri);

                client.GetInfo(repos, out info);

                return info.LastChangeTime;
            }
        }

        private void UpdateRevisionLog()
        {
            using (SvnClient client = new SvnClient())
            {
                SvnUpdateArgs args = new SvnUpdateArgs();

                try
                {
                    SvnUIBindArgs uiArgs = new SvnUIBindArgs();
                    uiArgs.ParentWindow = this;
                    uiArgs.Synchronizer = this;
                    SvnUI.Bind(client, uiArgs);
                    SvnRevisionRange range = new SvnRevisionRange(new SvnRevision(dateTimePickerEnd.Value.AddDays(1)), new SvnRevision(dateTimePickerBegin.Value));
                    Collection<SvnLogEventArgs> logItems;
                    client.GetLog(new Uri(this.uri), new SvnLogArgs(range), out logItems);

                    listViewRevisions.Items.Clear();
                    foreach (var logentry in logItems)
                    {
                        ListViewItem row = new ListViewItem(logentry.Revision.ToString());
                        row.SubItems.Add(new ListViewItem.ListViewSubItem(row, logentry.Time.ToString()));
                        row.SubItems.Add(new ListViewItem.ListViewSubItem(row, logentry.Author));
                        row.SubItems.Add(new ListViewItem.ListViewSubItem(row, logentry.LogMessage));
                        listViewRevisions.Items.Add(row);
                    }
                    listViewRevisions.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent);

                }
                catch (SvnException)
                {
                    DialogResult = DialogResult.Retry;
                    Close();
                }
            }
        }

        private void btnUpdateLog_Click(object sender, EventArgs e)
        {
            UpdateRevisionLog();
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            if (listViewRevisions.SelectedItems.Count == 0)
            {
                MessageBox.Show("You have to select a revision from the log!", "No revision selected", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                this.revision = listViewRevisions.SelectedItems[0].Text;
                DialogResult = DialogResult.OK;
                Close();
            }
        }

        private void dateTimePickerEnd_ValueChanged(object sender, EventArgs e)
        {
            dateTimePickerBegin.MaxDate = dateTimePickerEnd.Value;
        }
    }
}
