﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace DependencyAnalyzer.Global
{
    public static class Functions
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        private static extern int GetLongPathName(
            [MarshalAs(UnmanagedType.LPTStr)]
            string lpszShortPath,
            [MarshalAs(UnmanagedType.LPTStr)]
            StringBuilder lpszLongPath,
            [MarshalAs(UnmanagedType.U4)]
            int cchBuffer
            );

        public static string ShortToLongPath(string shortPath)
        {
            StringBuilder longPath = new StringBuilder(255);
            GetLongPathName(shortPath, longPath, longPath.Capacity);
            return longPath.ToString();
        }

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        private static extern int GetShortPathName(
            [MarshalAs(UnmanagedType.LPTStr)]
            string path,
            [MarshalAs(UnmanagedType.LPTStr)]
            StringBuilder shortPath,
            int shortPathLength
            );

        public static string LongToShortPath(string longPath)
        {
            StringBuilder shortPath = new StringBuilder(255);
            GetShortPathName(longPath, shortPath, shortPath.Capacity);
            return shortPath.ToString();
        }

        public static bool FindInArray(List<string> arr, string target) 
        { 
            return arr.Exists(delegate(string p) 
            { 
                return p.Trim() == target; 
            }); 
        }


    }
}
