﻿using System;
using System.Collections.Generic;
using System.Xml;
using System.IO;

namespace DependencyAnalyzer.Global
{
    public class ProjectInformation
    {
        public string createDate;
        public string projectName;
        public string projectPath;
        
        public bool local;
        public string localFolder;

        public string repositoryUri;
        public string lastRevision;
        public List<string> revisions;

        public ProjectInformation()
        {
            createDate = String.Format("{0} {1}", DateTime.Now.ToShortDateString(), DateTime.Now.ToShortTimeString());
            revisions = new List<string>();
        }

        public bool LoadProjectFile(string filePath)
        {
            try
            {
                this.projectPath = filePath.Substring(0, filePath.LastIndexOf('\\'));

                XmlDocument xmlDocument = new XmlDocument();
                xmlDocument.Load(filePath);

                XmlNode nodeProjectname = xmlDocument.SelectSingleNode("/Project/Projectname");
                XmlNode nodeLocal = xmlDocument.SelectSingleNode("/Project/Local");

                projectName = nodeProjectname.InnerText;
                local = nodeLocal.Attributes.GetNamedItem("active").InnerText.Equals("True");
                if (local)
                {
                    localFolder = nodeLocal.InnerText;
                }
                else
                {
                    repositoryUri = xmlDocument.SelectSingleNode("/Project/Repository").InnerText;

                    //Get revisions
                    XmlNodeList nodesRevision = xmlDocument.SelectNodes("/Project/Revisions/Revision");
                    foreach (XmlNode node in nodesRevision)
                    {
                        revisions.Add(node.InnerText);
                    }
                }
                return true;
            }
            catch (Exception e)
            {
                System.Diagnostics.Debug.WriteLine(String.Format("Write XML exception: {0}", e.Message));
                return false;
            }
        }

        public bool SaveProjectFile()
        {
            try
            {
                Directory.CreateDirectory(projectPath);
                Directory.CreateDirectory(String.Format("{0}\\source", projectPath));
                Directory.CreateDirectory(String.Format("{0}\\dependencies", projectPath));

                XmlTextWriter textWriter = new XmlTextWriter(String.Format("{0}\\{1}.dap", projectPath, projectName), null);
                textWriter.WriteStartDocument();

                textWriter.WriteComment("DependencyAnalyzer project file");

                textWriter.WriteStartElement("Project");

                textWriter.WriteStartElement("CreateDate");
                textWriter.WriteString(createDate);
                textWriter.WriteEndElement();

                textWriter.WriteStartElement("Projectname");
                textWriter.WriteString(projectName);
                textWriter.WriteEndElement();

                textWriter.WriteStartElement("Local");
                textWriter.WriteStartAttribute("active");
                textWriter.WriteString(local.ToString());
                textWriter.WriteEndAttribute();
                textWriter.WriteString(localFolder);
                textWriter.WriteEndElement();

                textWriter.WriteStartElement("Repository");
                textWriter.WriteStartAttribute("active");
                textWriter.WriteString((!local).ToString());
                textWriter.WriteEndAttribute();
                textWriter.WriteString(repositoryUri);
                textWriter.WriteEndElement();

                if (!local)
                {
                    textWriter.WriteStartElement("Revisions");
                    foreach (string revision in revisions)
                    {
                        textWriter.WriteStartElement("Revision");
                        textWriter.WriteString(revision);
                        textWriter.WriteEndElement();
                    }
                    textWriter.WriteEndElement();
                }
                
                textWriter.WriteEndElement();
                textWriter.WriteEndDocument();
                textWriter.Close();

                return true;
            }
            catch(Exception e)
            {
                System.Diagnostics.Debug.WriteLine(String.Format("Write XML exception: {0}", e.Message));
                return false;
            }
        }
    }
}
