﻿using System;
using System.Text;

namespace DependencyAnalyzer.SolidSX.XmlGenerator
{
    static class SQLiteNode
    {
        public static void Add(StringBuilder stringBuilder, long id, string name, string type)
        {
            SQLiteNode.Add(stringBuilder, id, name, type, null);
        }

        public static void Add(StringBuilder stringBuilder, long id, string name, string type, string filename)
        {
            SQLiteNode.AddAttribute(stringBuilder, id, "name", name);
            SQLiteNode.AddAttribute(stringBuilder, id, "type", type);
            if (filename != null)
            {
                SQLiteNode.AddAttribute(stringBuilder, id, "filename", filename);
            }
        }

        private static void AddAttribute(StringBuilder stringBuilder, long id, string key, string value)
        {
            String query = String.Format(
                @"INSERT INTO [nodeattr] VALUES ({0}, '{1}', '{2}', '{3}');{4}",
                id, key, value, "", Environment.NewLine);
            stringBuilder.Append(query);
        }
    }
}
