﻿using System;
using System.Runtime.Serialization;

namespace DependencyAnalyzer.Dependency
{
    [Serializable()]
    public class Method : ISerializable
    {
        public string ShortName { get; private set; }   // method name
        public string FullName { get; private set; }    // method name and parameters
        public long Id { get; set; }

        public Method(string raw_method)
        {
            int indexOfBracket = raw_method.IndexOf('(');
            this.ShortName = raw_method.Substring(0, indexOfBracket);
            this.FullName = raw_method;
        }

        public Method(SerializationInfo info, StreamingContext ctxt)
        {
            this.ShortName = (string)info.GetValue("ShortName", typeof(string));
            this.FullName = (string)info.GetValue("FullName", typeof(string));
            this.Id = (long)info.GetValue("Id", typeof(long));
        }

        public void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext)
        {
            serializationInfo.AddValue("ShortName", this.ShortName);
            serializationInfo.AddValue("FullName", this.FullName);
            serializationInfo.AddValue("Id", this.Id);
        }
    }
}
