﻿using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Collections.Generic;
using System.Diagnostics;
using DependencyAnalyzer.Global;

namespace DependencyAnalyzer
{
    public static class ReadDirectory
    {
        public static string[] readDir(string path, string extentionFilter)
        {
            if (Directory.Exists(path))
            {
                return ProcessDir(path, extentionFilter);
            }
            else
            {
                return null;
            }
        }

        private static string[] ProcessDir(string dirPath, string extentionFilter)
        {
            List<string> fileList = new List<string>();

            string[] extentions = extentionFilter.Split(';');
            foreach (string extention in extentions)
            {
                //Process files in this directory
                string[] files = Directory.GetFiles(dirPath, extention);
                foreach (string filePath in files)
                {
                    fileList.Add(Functions.LongToShortPath(filePath));
                }
            }

            //Process directories in this directory
            string[] dirs = Directory.GetDirectories(dirPath);
            foreach (string dir in dirs)
            {
                //Check if directory is not an '.svn dir'
                if (!dir.EndsWith(".svn"))
                    fileList.AddRange(ProcessDir(dir, extentionFilter));                
            }

            return fileList.ToArray();
        }
    }
}
