// This file is part of the RECODER library and protected by the LGPL.

package recoder.java.expression;

import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.StatementContainer;

/**
 * An assignment is an operator with side-effects.
 */

public abstract class Assignment extends Operator implements ExpressionStatement {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
     * either statementParent or expressionParent is null, in case of
     * ambiguities (e.g. Assignment as a parent), prefer an ExpressionContainer
     * as parent. We could resolve these problems by introduction of an
     * AssignmentContainer as supertype of StatementContainer and
     * ExpressionContainer.
     */

	private StatementContainer statementParent;

    /**
     * Assignment.
     */

    public Assignment() {
        // nothing to do
    }

    /**
     * Assignment.
     * 
     * @param unaryChild
     *            an expression.
     */

    public Assignment(Expression unaryChild) {
        super(unaryChild);
    }

    /**
     * Assignment.
     * 
     * @param lhs
     *            an expression.
     * @param rhs
     *            an expression.
     */

    public Assignment(Expression lhs, Expression rhs) {
        super(lhs, rhs);
    }

    /**
     * Assignment.
     * 
     * @param proto
     *            an assignment.
     */

    protected Assignment(Assignment proto) {
        super(proto);
    }

    /**
     * Get AST parent.
     * 
     * @return the non terminal program element.
     */

    public NonTerminalProgramElement getASTParent() {
        if (expressionParent != null) {
            return expressionParent;
        } else {
            return statementParent;
        }
    }

    /**
     * Get statement container.
     * 
     * @return the statement container.
     */

    public StatementContainer getStatementContainer() {
        return statementParent;
    }

    /**
     * Set statement container.
     * 
     * @param c
     *            a statement container.
     */

    public void setStatementContainer(StatementContainer c) {
        statementParent = c;
    }

    /**
     * Checks if this operator is left or right associative. Assignments are
     * right associative.
     * 
     * @return false
     */

    public boolean isLeftAssociative() {
        return false;
    }
    
    public abstract Assignment deepClone();
}