package recoderanalyser.analyse;

import recoder.ModelElement;
import recoder.java.ProgramElement;
import recoder.service.DefaultErrorHandler;

public class ErrorHandler extends DefaultErrorHandler 
{
    
    private boolean ignoreErrors = false;
    private boolean warningOccured = false;
    
    public ErrorHandler() 
    {
        super();
    }
    
    public String getWarningErrorText() 
    {
        StringBuilder msg = new StringBuilder();
        
        if(warningOccured) 
        {
            msg.append("with warnings");
        }
        
        if(getErrorCount() > 0) 
        {
            if(warningOccured) 
            {
                msg.append(" and ");
            }
            else 
            {
                msg.append("with ");
            }
                
            msg = msg.append(getErrorCount()).append(" errors");
        }
        
        return msg.toString();
    }
    
    public void setIgnoreErrors(boolean value) 
    {
        ignoreErrors = value;
    }

    @Override
    protected boolean isIgnorable(Exception e) 
    {
        return ignoreErrors;
    }

    @Override
    protected void errorMessage(Exception e) 
    {
        System.err.println(String.format("ERROR_NUM%d: %s", getErrorCount(), e.getMessage()));
    }

    @Override
    protected void warningMessage(Exception e) 
    {
        System.err.println(String.format("WARNING: %s", e.getMessage()));
        warningOccured = true;
    }

    @Override
    protected void exitAction() 
    {
        System.err.println(String.format("ERROR_EXIT: Aborted with %d errors.", getErrorCount()));
        System.exit(2);
    }
}
