package recoderanalyser.analyse;

import recoder.util.ProgressEvent;
import recoder.util.ProgressListener;

public class Status implements ProgressListener{

    public enum StatusType {PARSING, REFERENCES}
    
    StatusType type;
    String lastState = "";
    int lastPercentage = -1;
    
    public Status(StatusType type) 
    {
        this.type = type;
    }
    
    @Override
    public void workProgressed(ProgressEvent pe) 
    {
        
        if(!lastState.equals(pe.getState().toString())) 
        {
            lastState = pe.getState().toString();
            System.out.println(String.format("STATUS_MESSAGE: %s", lastState));
        }
        
        if(type.equals(StatusType.REFERENCES)) 
        {
            int calculatedPercentage = pe.getWorkDoneCount()*100/pe.getWorkToDoCount();

            if(calculatedPercentage != lastPercentage) {
                lastPercentage = calculatedPercentage;
                System.out.println(String.format("STATUS_VALUE: %d%%", calculatedPercentage));
            }
        }
    }
}
