package recoderanalyser.input;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import recoderanalyser.solidsxtree.SolidSXRootNode;

public class BinToTree 
{
    public static SolidSXRootNode getSolidSXNode(String inputPath)
    {
        System.out.println(String.format("STATUS_MESSAGE: Loading file %s", inputPath));
        SolidSXRootNode result = null;
        try
        {
            FileInputStream fileIn = new FileInputStream(inputPath);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            result = (SolidSXRootNode) in.readObject();
            in.close();
            fileIn.close();
        }
        catch(IOException ie)
        {
            System.out.println(String.format("IOException: %s", ie.getMessage()));
        }
        catch(ClassNotFoundException cnfe)
        {
            System.out.println(String.format("ClassNotFoundException: %s", cnfe.getMessage()));
        }
        return result;
    }
}
