package recoderanalyser.output;

import java.util.ArrayList;
import java.util.List;

public class SolidSXEdges 
{
    private List<SolidSXEdge> edges;
        
    public SolidSXEdges()
    {
        edges = new ArrayList<SolidSXEdge>();
    }

    public void addEdge(long toNodeID, long revision)
    {
        SolidSXEdge edge = getEdgeByID(toNodeID);
        if(edge == null)
        {
            edges.add(new SolidSXEdge(toNodeID, revision));
        }
        else
        {
            edge.addRevision(revision);
        }
    }

    public List<SolidSXEdge> getEdgeList()
    {
        return edges;
    }

    private SolidSXEdge getEdgeByID(long nodeID)
    {
        for(SolidSXEdge edge : edges)
        {
            if(edge.getToNodeID() == nodeID)
            {
                return edge;
            }
        }
        return null;
    }
}
