package recoderanalyser.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import recoderanalyser.solidsxtree.SolidSXRootNode;

public class TreeToBin 
{
    public static void generateBin(SolidSXRootNode rootNode, String outputPath)
    {
        String filePath = outputPath.toLowerCase().endsWith(".bin") ? outputPath : String.format("%s%s.bin", outputPath, rootNode.getStringRevision());
        System.out.println(String.format("STATUS_MESSAGE: Writing file %s", filePath));
                
        if(!outputPath.endsWith(".bin"))
        {
            new File(outputPath).mkdirs();
        }
        
        try
        {
            FileOutputStream fileOut = new FileOutputStream(filePath);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(rootNode);
            out.close();
            fileOut.close();
        }
        catch(IOException ie)
        {
            System.err.println(String.format("IOException: %s", ie.getMessage()));
        }
    }
}
