package recoderanalyser.solidsxtree;

import java.io.Serializable;

public class SolidSXReference implements Serializable
{
    public enum ReferenceType {Import, Call, Uses, Access, IsA, Inheritance}
    
    private String path;
    private ReferenceType type;
    
    public SolidSXReference(String path, ReferenceType type)
    {
        this.path = path;
        this.type = type;
    }
    
    public String getPath()
    {
        return this.path;
    }
    
    public ReferenceType getType()
    {
        return this.type;
    }

    @Override
    public boolean equals(Object obj) 
    {
        if(!(obj instanceof SolidSXReference))
        {
            return false;
        }
        else
        {
            SolidSXReference inputObj = (SolidSXReference)obj;
            return this.path.equals(inputObj.path) && this.type.equals(inputObj.type);
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 73 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }
    
    
}
