﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharpDeps
{
    class ResultsWriter
    {
        public void Write(Scopes.Solution solution)
        {
            foreach (var project in solution.Projects)
            {
                foreach (var file in project.Files)
                {
                    Console.WriteLine(file.Path);
                    Console.WriteLine("--------------------");

                    foreach (var ns in file.Namespaces.Values)
                    {
                        foreach (var klass in ns.Classes.Values)
                        {
                            Console.WriteLine("- {0}", klass.FullName);
                            Console.WriteLine();

                            foreach (var method in klass.Methods)
                            {
                                Console.WriteLine("> {0}", method.Name);

                                foreach (var invocation in method.Invocations.Values)
                                {
                                    Console.WriteLine("\t{0} => {1}", invocation.Invocations, invocation.Name);
                                }

                                foreach (var member in method.MemberAccesses.Values)
                                {
                                    Console.WriteLine("\t{0} => {1}", member.Accesses, member.FullName);
                                }
                            }

                            Console.WriteLine();
                        }
                    }
                }
            }
        }
    }
}
