﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CSharpDeps.Scopes;
using ICSharpCode.NRefactory.CSharp;
using ICSharpCode.NRefactory.CSharp.Resolver;

namespace CSharpDeps.Visitors
{
    class ClassContainerVisitor : Visitor
    {
        public ClassContainerVisitor(CSharpAstResolver resolver)
            : base(resolver)
        {
            Resolver = resolver;
        }

        protected void DecorateClass(Class klass, TypeDeclaration typeDeclaration)
        {
            foreach (var baseType in typeDeclaration.BaseTypes)
            {
                var r = Resolver.Resolve(baseType);

                if (r != null)
                {
                    if (r.Type.Kind == ICSharpCode.NRefactory.TypeSystem.TypeKind.Interface)
                    {
                        klass.AddImplements(r.Type);
                    }
                    else
                    {
                        klass.SetInherits(r.Type);
                    }
                }
            }
        }

        protected static Class.Types TranslateType(ClassType type)
        {
            switch (type)
            {
                case ClassType.Class:
                    return Class.Types.Class;
                case ClassType.Struct:
                    return Class.Types.Struct;
                case ClassType.Enum:
                    return Class.Types.Enum;
                case ClassType.Interface:
                    return Class.Types.Interface;
            }

            return Class.Types.Class;
        }
    }
}
