﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpDeps.Scopes;
using ICSharpCode.NRefactory.CSharp.Resolver;
using ICSharpCode.NRefactory.Semantics;

namespace CSharpDeps.Visitors
{
    class MethodVisitor : Visitor
    {
        protected Method Method { get; set; }

        public MethodVisitor(CSharpAstResolver resolver, Method method)
            : base(resolver)
        {
            Method = method;
        }

        public override void VisitInvocationExpression(InvocationExpression invocationExpression)
        {
            var r = Resolver.Resolve(invocationExpression) as InvocationResolveResult;

            if (r != null)
            {
                Method.AddInvocation(r);
            }

            base.VisitInvocationExpression(invocationExpression);
        }

        public override void VisitObjectCreateExpression(ObjectCreateExpression objectCreateExpression)
        {
            var r = Resolver.Resolve(objectCreateExpression) as InvocationResolveResult;

            if (r != null)
            {
                Method.AddInvocation(r);
            }
            
            base.VisitObjectCreateExpression(objectCreateExpression);
        }

        public override void VisitMemberReferenceExpression(MemberReferenceExpression memberReferenceExpression)
        {
            var r = Resolver.Resolve(memberReferenceExpression) as MemberResolveResult;

            if (r != null)
            {
                Method.AddMemberAccess(r);
            }

            base.VisitMemberReferenceExpression(memberReferenceExpression);
        }
    }
}
