﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CSharpMetrics.Scopes;

namespace CSharpMetrics
{
    class ResultsWriter
    {
        public void Write(File file)
        {
            Console.WriteLine("#####################################");
            Console.WriteLine("  {0}", file.Name);
            Console.WriteLine("#####################################");
            Console.WriteLine();
            Console.WriteLine("  LOC: {0}", file.LOC);
            Console.WriteLine("  CLOC: {0}", file.CLOC);
            Console.WriteLine("  IDEP: {0}", file.NrImports);
            Console.WriteLine();

            foreach (var ns in file.Namespaces.Values)
            {
                Console.WriteLine("    Namespace: {0}", ns.FullName);
                Console.WriteLine("  ===================================");
                Console.WriteLine();

                foreach (var klass in ns.Classes.Values)
                {
                    PrintClassResult(klass);
                }

                Console.WriteLine();
            }

            Console.WriteLine();
        }

        protected void PrintClassResult(Class klass, string prefix = null)
        {
            var full = prefix == null ? klass.Name : prefix + "." + klass.Name;

            Console.WriteLine("      Class: {0}", full);
            Console.WriteLine("    ---------------------------------");
            Console.WriteLine();

            foreach (var method in klass.Methods)
            {
                Console.WriteLine("      Method: {0} => McCabe: {1}, Invocations: {2}, MaxDepth: {3}", method.Prototype, method.Complexity, method.Invocations, method.MaxDepth);
            }

            Console.WriteLine();
            Console.WriteLine();

            foreach (var child in klass.Children.Values)
            {
                PrintClassResult(child, full);
            }
        }
    }
}
