﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpMetrics.Scopes;

namespace CSharpMetrics.Visitors
{
    class FileVisitor : Visitor
    {
        public File File { get; private set; }

        public FileVisitor(File file)
        {
            File = file;
        }

        public override void VisitSyntaxTree(SyntaxTree syntaxTree)
        {
            var global = new GlobalNamespace();

            syntaxTree.AcceptVisitor(new NamespaceVisitor(File, global));

            base.VisitSyntaxTree(syntaxTree);

            File.LOC = LOC;
            File.CLOC = CLOC;

            if (global.NrClasses > 0)
            {
                File.AddNamespace(global);
            }
        }

        public override void VisitUsingDeclaration(UsingDeclaration usingDeclaration)
        {
            File.NrImports++;

            base.VisitUsingDeclaration(usingDeclaration);
        }

        public override void VisitUsingAliasDeclaration(UsingAliasDeclaration usingDeclaration)
        {
            File.NrImports++;

            base.VisitUsingAliasDeclaration(usingDeclaration);
        }
    }
}
