// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeCommas = new List<Location> ();
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type error",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "$$25 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$23 method_declaration_name OPEN_PARENS $$24 opt_formal_parameter_list CLOSE_PARENS $$25 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$26 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$26 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$27 :",
//t    "$$28 :",
//t    "$$29 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$27 OPEN_BRACE $$28 accessor_declarations $$29 CLOSE_BRACE",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$30 opt_formal_parameter_list CLOSE_BRACKET $$31 OPEN_BRACE accessor_declarations $$32 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$33 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$33 accessor_body",
//t    "$$34 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$34 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "$$38 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$35 type_declaration_name $$36 opt_class_base opt_type_parameter_constraints_clauses $$37 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$38 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$39 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$39 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$40 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$41 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$42 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$42 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$43 :",
//t    "$$44 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$43 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$44 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$45 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "$$46 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$46 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$47 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$47 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$48 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$48 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$49 :",
//t    "$$50 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$49 event_accessor_declarations $$50 CLOSE_BRACE",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type error",
//t    "opt_event_initializer :",
//t    "$$51 :",
//t    "opt_event_initializer : ASSIGN $$51 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$52 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$52 event_variable_initializer",
//t    "$$53 :",
//t    "event_variable_initializer : $$53 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$54 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$54 event_accessor_block",
//t    "$$55 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$55 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "$$56 :",
//t    "$$57 :",
//t    "$$58 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$56 OPEN_BRACE $$57 opt_enum_member_declarations $$58 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$59 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$59 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$60 opt_formal_parameter_list CLOSE_PARENS $$61 opt_type_parameter_constraints_clauses $$62 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$63 :",
//t    "type_declaration_name : IDENTIFIER $$63 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "invocation_expression : primary_expression open_parens_any error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$64 :",
//t    "new_expr_type : $$64 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$65 :",
//t    "typeof_expression : TYPEOF $$65 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : identifier_inside_body generic_dimension",
//t    "unbound_type_name : qualified_alias_member identifier_inside_body generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body generic_dimension",
//t    "unbound_type_name : namespace_or_type_expr DOT identifier_inside_body generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "sizeof_expression : SIZEOF open_parens_any type error",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "checked_expression : CHECKED error",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED error",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$66 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$66 block",
//t    "$$67 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$67 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$68 :",
//t    "anonymous_method_signature : OPEN_PARENS $$68 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "unary_expression : BANG error",
//t    "unary_expression : TILDE error",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS error",
//t    "unary_expression : AWAIT error",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "prefixed_unary_expression : PLUS error",
//t    "prefixed_unary_expression : MINUS error",
//t    "prefixed_unary_expression : OP_INC error",
//t    "prefixed_unary_expression : OP_DEC error",
//t    "prefixed_unary_expression : STAR error",
//t    "prefixed_unary_expression : BITWISE_AND error",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR error",
//t    "multiplicative_expression : multiplicative_expression DIV error",
//t    "multiplicative_expression : multiplicative_expression PERCENT error",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "additive_expression : additive_expression PLUS error",
//t    "additive_expression : additive_expression MINUS error",
//t    "additive_expression : additive_expression AS error",
//t    "additive_expression : additive_expression IS error",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT error",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT error",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "relational_expression : relational_expression OP_LT error",
//t    "relational_expression : relational_expression OP_GT error",
//t    "relational_expression : relational_expression OP_LE error",
//t    "relational_expression : relational_expression OP_GE error",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "equality_expression : equality_expression OP_EQ error",
//t    "equality_expression : equality_expression OP_NE error",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "and_expression : and_expression BITWISE_AND error",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET error",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR error",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND error",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR error",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON error",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "$$69 :",
//t    "lambda_expression_body : $$69 expression",
//t    "lambda_expression_body : block",
//t    "lambda_expression_body : error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$70 :",
//t    "lambda_expression : IDENTIFIER ARROW $$70 lambda_expression_body",
//t    "$$71 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$71 lambda_expression_body",
//t    "$$72 :",
//t    "$$73 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$72 opt_lambda_parameter_list CLOSE_PARENS ARROW $$73 lambda_expression_body",
//t    "$$74 :",
//t    "$$75 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$74 opt_lambda_parameter_list CLOSE_PARENS ARROW $$75 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$76 :",
//t    "$$77 :",
//t    "$$78 :",
//t    "$$79 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$76 type_declaration_name $$77 opt_class_base opt_type_parameter_constraints_clauses $$78 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$79 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$80 :",
//t    "block : OPEN_BRACE $$80 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$81 :",
//t    "block_prepared : OPEN_BRACE $$81 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "$$82 :",
//t    "block_prepared_strict : OPEN_BRACE $$82 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$83 :",
//t    "labeled_statement : identifier_inside_body COLON $$83 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$84 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$84 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$85 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$85 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : ASSIGN error",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$86 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$86 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$87 :",
//t    "switch_section : switch_labels $$87 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$88 :",
//t    "for_statement : FOR open_parens_any $$88 for_statement_cont",
//t    "$$89 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$89 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$90 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$90 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$91 :",
//t    "for_initializer : variable_type identifier_inside_body $$91 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$92 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$92 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH block",
//t    "$$93 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$93 block_prepared_strict",
//t    "catch_clause : CATCH open_parens_any error",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$94 :",
//t    "unsafe_statement : UNSAFE $$94 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$95 :",
//t    "$$96 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$95 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$96 embedded_statement",
//t    "$$97 :",
//t    "$$98 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$97 using_initialization CLOSE_PARENS $$98 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$99 :",
//t    "from_clause : FROM identifier_inside_body IN $$99 expression_or_error",
//t    "$$100 :",
//t    "from_clause : FROM type identifier_inside_body IN $$100 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$101 :",
//t    "select_or_group_clause : SELECT $$101 expression_or_error",
//t    "$$102 :",
//t    "$$103 :",
//t    "select_or_group_clause : GROUP $$102 expression_or_error $$103 BY expression_or_error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$104 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$104 expression_or_error",
//t    "$$105 :",
//t    "where_clause : WHERE $$105 expression_or_error",
//t    "$$106 :",
//t    "$$107 :",
//t    "$$108 :",
//t    "join_clause : JOIN identifier_inside_body IN $$106 expression_or_error ON $$107 expression_or_error EQUALS $$108 expression_or_error opt_join_into",
//t    "$$109 :",
//t    "$$110 :",
//t    "$$111 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$109 expression_or_error ON $$110 expression_or_error EQUALS $$111 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$112 :",
//t    "orderby_clause : ORDERBY $$112 orderings",
//t    "orderings : order_by",
//t    "$$113 :",
//t    "orderings : order_by COMMA $$113 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$114 :",
//t    "orderings_then_by : orderings_then_by COMMA $$114 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$115 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$115 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$116 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$116 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$117 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$117 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$118 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$118 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 385 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 386 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 405 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 450 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 27:
  case_27();
  break;
case 40:
  case_40();
  break;
case 41:
#line 625 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 42:
  case_42();
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
#line 739 "cs-parser.jay"
  { yyVal = "event"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 59:
#line 740 "cs-parser.jay"
  { yyVal = "return"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 60:
  case_60();
  break;
case 61:
#line 757 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 62:
  case_62();
  break;
case 63:
#line 772 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 64:
  case_64();
  break;
case 66:
#line 800 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 67:
  case_67();
  break;
case 68:
#line 812 "cs-parser.jay"
  { yyVal = null; }
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
  case_72();
  break;
case 73:
#line 856 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 75:
#line 864 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
#line 890 "cs-parser.jay"
  { yyVal = null; }
  break;
case 79:
#line 894 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 80:
#line 898 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 83:
#line 910 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 84:
#line 914 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 96:
  case_96();
  break;
case 97:
#line 945 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
  case_101();
  break;
case 102:
  case_102();
  break;
case 103:
#line 988 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 104:
  case_104();
  break;
case 105:
  case_105();
  break;
case 106:
  case_106();
  break;
case 109:
#line 1037 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 110:
#line 1041 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 111:
  case_111();
  break;
case 112:
#line 1057 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 113:
  case_113();
  break;
case 114:
  case_114();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 119:
  case_119();
  break;
case 120:
  case_120();
  break;
case 121:
#line 1136 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 123:
  case_123();
  break;
case 124:
  case_124();
  break;
case 127:
#line 1166 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 128:
#line 1170 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 129:
  case_129();
  break;
case 130:
#line 1183 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 131:
  case_131();
  break;
case 134:
#line 1202 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 135:
#line 1206 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 136:
  case_136();
  break;
case 137:
#line 1222 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 138:
  case_138();
  break;
case 139:
  case_139();
  break;
case 142:
  case_142();
  break;
case 143:
  case_143();
  break;
case 144:
  case_144();
  break;
case 145:
#line 1290 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 146:
  case_146();
  break;
case 147:
  case_147();
  break;
case 148:
#line 1329 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 149:
  case_149();
  break;
case 150:
#line 1339 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 151:
  case_151();
  break;
case 152:
  case_152();
  break;
case 153:
  case_153();
  break;
case 155:
#line 1410 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 156:
#line 1414 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
  case_160();
  break;
case 161:
  case_161();
  break;
case 162:
  case_162();
  break;
case 163:
  case_163();
  break;
case 164:
  case_164();
  break;
case 165:
#line 1486 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 166:
#line 1490 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
#line 1571 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 175:
  case_175();
  break;
case 176:
#line 1612 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 178:
#line 1620 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
  case_185();
  break;
case 186:
  case_186();
  break;
case 187:
  case_187();
  break;
case 188:
#line 1714 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
#line 1768 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 195:
  case_195();
  break;
case 196:
#line 1797 "cs-parser.jay"
  {
		lexer.PropertyParsing = false;
	  }
  break;
case 197:
  case_197();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
  case_204();
  break;
case 205:
  case_205();
  break;
case 206:
  case_206();
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 210:
#line 1946 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 213:
  case_213();
  break;
case 214:
  case_214();
  break;
case 215:
#line 1985 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 218:
#line 1997 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 219:
#line 2001 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 220:
#line 2008 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 221:
#line 2012 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 226:
#line 2020 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 227:
#line 2024 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 228:
#line 2028 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 229:
#line 2034 "cs-parser.jay"
  {
	  }
  break;
case 230:
  case_230();
  break;
case 232:
#line 2067 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 234:
  case_234();
  break;
case 235:
#line 2083 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 236:
  case_236();
  break;
case 238:
#line 2129 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 239:
#line 2130 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 240:
#line 2131 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 241:
#line 2132 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 242:
#line 2133 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 243:
#line 2134 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 244:
#line 2136 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 245:
#line 2137 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 246:
#line 2139 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 247:
#line 2140 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 248:
#line 2141 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 249:
#line 2142 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 250:
#line 2143 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 251:
#line 2144 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 252:
#line 2145 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 253:
#line 2146 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 254:
#line 2147 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 255:
#line 2148 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 256:
#line 2149 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 257:
#line 2150 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 258:
#line 2151 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 259:
#line 2152 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 260:
#line 2159 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 261:
  case_261();
  break;
case 262:
#line 2182 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 263:
  case_263();
  break;
case 264:
  case_264();
  break;
case 265:
  case_265();
  break;
case 266:
  case_266();
  break;
case 267:
  case_267();
  break;
case 268:
  case_268();
  break;
case 269:
  case_269();
  break;
case 271:
#line 2292 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 274:
#line 2304 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 275:
  case_275();
  break;
case 276:
#line 2314 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 280:
  case_280();
  break;
case 281:
  case_281();
  break;
case 282:
  case_282();
  break;
case 283:
  case_283();
  break;
case 284:
  case_284();
  break;
case 285:
  case_285();
  break;
case 286:
  case_286();
  break;
case 287:
  case_287();
  break;
case 289:
#line 2438 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 290:
  case_290();
  break;
case 293:
#line 2455 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 294:
#line 2459 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 295:
  case_295();
  break;
case 296:
#line 2472 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 297:
  case_297();
  break;
case 298:
  case_298();
  break;
case 299:
#line 2497 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
  case_307();
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 313:
  case_313();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 317:
  case_317();
  break;
case 318:
  case_318();
  break;
case 321:
#line 2665 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 323:
  case_323();
  break;
case 324:
  case_324();
  break;
case 325:
  case_325();
  break;
case 326:
  case_326();
  break;
case 327:
  case_327();
  break;
case 329:
#line 2739 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 330:
  case_330();
  break;
case 331:
#line 2758 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 332:
  case_332();
  break;
case 334:
  case_334();
  break;
case 336:
  case_336();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 341:
  case_341();
  break;
case 342:
  case_342();
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 345:
#line 2864 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 353:
  case_353();
  break;
case 354:
  case_354();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 359:
  case_359();
  break;
case 360:
  case_360();
  break;
case 362:
#line 2989 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 363:
#line 2996 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 365:
  case_365();
  break;
case 367:
  case_367();
  break;
case 369:
  case_369();
  break;
case 371:
#line 3034 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 372:
  case_372();
  break;
case 373:
#line 3053 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 374:
  case_374();
  break;
case 375:
#line 3062 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 376:
#line 3066 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 377:
  case_377();
  break;
case 378:
  case_378();
  break;
case 379:
  case_379();
  break;
case 380:
#line 3100 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 381:
#line 3101 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 382:
#line 3102 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 383:
#line 3103 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 384:
#line 3104 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 385:
#line 3105 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 3110 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 3111 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 3112 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 3113 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 391:
#line 3114 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 392:
#line 3115 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 393:
#line 3116 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 394:
#line 3117 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 395:
#line 3118 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 416:
  case_416();
  break;
case 417:
  case_417();
  break;
case 421:
#line 3165 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 422:
#line 3169 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 423:
#line 3170 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 428:
  case_428();
  break;
case 429:
#line 3203 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 430:
  case_430();
  break;
case 431:
  case_431();
  break;
case 432:
  case_432();
  break;
case 433:
  case_433();
  break;
case 434:
#line 3238 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 435:
  case_435();
  break;
case 436:
#line 3246 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 437:
  case_437();
  break;
case 438:
  case_438();
  break;
case 439:
  case_439();
  break;
case 440:
  case_440();
  break;
case 441:
#line 3276 "cs-parser.jay"
  { yyVal = null; }
  break;
case 443:
  case_443();
  break;
case 444:
  case_444();
  break;
case 445:
#line 3299 "cs-parser.jay"
  { yyVal = null; }
  break;
case 446:
#line 3303 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 447:
  case_447();
  break;
case 448:
  case_448();
  break;
case 449:
  case_449();
  break;
case 450:
  case_450();
  break;
case 451:
#line 3336 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
  case_454();
  break;
case 457:
#line 3367 "cs-parser.jay"
  { yyVal = null; }
  break;
case 459:
  case_459();
  break;
case 460:
  case_460();
  break;
case 461:
  case_461();
  break;
case 462:
  case_462();
  break;
case 463:
  case_463();
  break;
case 464:
#line 3421 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 468:
  case_468();
  break;
case 469:
  case_469();
  break;
case 470:
  case_470();
  break;
case 471:
  case_471();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
  case_475();
  break;
case 476:
  case_476();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
#line 3518 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 483:
#line 3526 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
#line 3546 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 487:
#line 3553 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 488:
  case_488();
  break;
case 489:
  case_489();
  break;
case 490:
  case_490();
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
#line 3620 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 496:
  case_496();
  break;
case 497:
  case_497();
  break;
case 500:
#line 3647 "cs-parser.jay"
  { yyVal = null; }
  break;
case 502:
  case_502();
  break;
case 503:
  case_503();
  break;
case 504:
  case_504();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 511:
  case_511();
  break;
case 512:
  case_512();
  break;
case 513:
  case_513();
  break;
case 514:
#line 3725 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 515:
#line 3729 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 516:
#line 3736 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 517:
#line 3740 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 518:
  case_518();
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
#line 3784 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 523:
  case_523();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
  case_538();
  break;
case 539:
  case_539();
  break;
case 540:
  case_540();
  break;
case 541:
#line 3923 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 542:
  case_542();
  break;
case 543:
#line 3936 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 544:
  case_544();
  break;
case 545:
#line 3953 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 547:
#line 3961 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 548:
  case_548();
  break;
case 549:
  case_549();
  break;
case 551:
#line 3987 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 552:
#line 3991 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 553:
  case_553();
  break;
case 554:
  case_554();
  break;
case 555:
  case_555();
  break;
case 556:
  case_556();
  break;
case 557:
  case_557();
  break;
case 558:
  case_558();
  break;
case 560:
#line 4052 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 561:
#line 4056 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 562:
#line 4060 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 563:
#line 4064 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 564:
#line 4068 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 565:
#line 4072 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 568:
  case_568();
  break;
case 569:
  case_569();
  break;
case 570:
  case_570();
  break;
case 571:
  case_571();
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 575:
  case_575();
  break;
case 576:
  case_576();
  break;
case 577:
  case_577();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 581:
  case_581();
  break;
case 582:
#line 4166 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 583:
#line 4170 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 584:
  case_584();
  break;
case 585:
  case_585();
  break;
case 586:
  case_586();
  break;
case 587:
  case_587();
  break;
case 589:
  case_589();
  break;
case 590:
  case_590();
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 611:
  case_611();
  break;
case 612:
  case_612();
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 623:
  case_623();
  break;
case 625:
  case_625();
  break;
case 626:
  case_626();
  break;
case 627:
  case_627();
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 632:
  case_632();
  break;
case 633:
  case_633();
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
  case_639();
  break;
case 640:
  case_640();
  break;
case 641:
  case_641();
  break;
case 642:
  case_642();
  break;
case 643:
  case_643();
  break;
case 644:
#line 4523 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 645:
  case_645();
  break;
case 646:
#line 4534 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 647:
  case_647();
  break;
case 649:
  case_649();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
#line 4588 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 659:
#line 4602 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 667:
#line 4627 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 672:
#line 4656 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 673:
#line 4669 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 674:
  case_674();
  break;
case 675:
  case_675();
  break;
case 676:
  case_676();
  break;
case 677:
  case_677();
  break;
case 678:
#line 4714 "cs-parser.jay"
  { yyVal = null; }
  break;
case 679:
#line 4716 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 680:
  case_680();
  break;
case 681:
#line 4729 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 685:
  case_685();
  break;
case 686:
  case_686();
  break;
case 687:
  case_687();
  break;
case 688:
  case_688();
  break;
case 689:
  case_689();
  break;
case 690:
  case_690();
  break;
case 691:
  case_691();
  break;
case 692:
  case_692();
  break;
case 693:
  case_693();
  break;
case 694:
  case_694();
  break;
case 695:
  case_695();
  break;
case 696:
  case_696();
  break;
case 697:
  case_697();
  break;
case 698:
  case_698();
  break;
case 700:
  case_700();
  break;
case 701:
  case_701();
  break;
case 703:
#line 4855 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 704:
  case_704();
  break;
case 705:
  case_705();
  break;
case 706:
  case_706();
  break;
case 707:
  case_707();
  break;
case 708:
  case_708();
  break;
case 709:
  case_709();
  break;
case 710:
  case_710();
  break;
case 711:
  case_711();
  break;
case 712:
#line 4948 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 713:
#line 4952 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 714:
#line 4959 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 715:
  case_715();
  break;
case 716:
  case_716();
  break;
case 717:
  case_717();
  break;
case 718:
  case_718();
  break;
case 719:
#line 5004 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 720:
  case_720();
  break;
case 721:
  case_721();
  break;
case 722:
  case_722();
  break;
case 723:
  case_723();
  break;
case 724:
  case_724();
  break;
case 725:
  case_725();
  break;
case 726:
  case_726();
  break;
case 731:
#line 5066 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 732:
#line 5070 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 734:
  case_734();
  break;
case 735:
  case_735();
  break;
case 738:
#line 5104 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 739:
#line 5108 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 768:
  case_768();
  break;
case 769:
  case_769();
  break;
case 770:
  case_770();
  break;
case 771:
  case_771();
  break;
case 772:
  case_772();
  break;
case 775:
  case_775();
  break;
case 776:
  case_776();
  break;
case 777:
  case_777();
  break;
case 778:
  case_778();
  break;
case 779:
#line 5252 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 780:
#line 5256 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 781:
  case_781();
  break;
case 783:
  case_783();
  break;
case 784:
#line 5277 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 786:
  case_786();
  break;
case 787:
  case_787();
  break;
case 788:
  case_788();
  break;
case 789:
  case_789();
  break;
case 790:
  case_790();
  break;
case 792:
  case_792();
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
  case_796();
  break;
case 800:
  case_800();
  break;
case 803:
  case_803();
  break;
case 804:
  case_804();
  break;
case 805:
#line 5412 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 806:
  case_806();
  break;
case 811:
  case_811();
  break;
case 813:
  case_813();
  break;
case 814:
  case_814();
  break;
case 815:
  case_815();
  break;
case 816:
#line 5462 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 817:
  case_817();
  break;
case 818:
#line 5472 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 819:
#line 5473 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 820:
  case_820();
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 825:
  case_825();
  break;
case 826:
  case_826();
  break;
case 827:
  case_827();
  break;
case 828:
#line 5548 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 829:
  case_829();
  break;
case 830:
  case_830();
  break;
case 831:
  case_831();
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 835:
  case_835();
  break;
case 836:
#line 5599 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 837:
#line 5603 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 838:
  case_838();
  break;
case 839:
  case_839();
  break;
case 840:
  case_840();
  break;
case 841:
  case_841();
  break;
case 842:
#line 5637 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
#line 5698 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 854:
  case_854();
  break;
case 855:
#line 5713 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
#line 5734 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
#line 5768 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 864:
  case_864();
  break;
case 865:
  case_865();
  break;
case 867:
#line 5789 "cs-parser.jay"
  { yyVal = null; }
  break;
case 869:
#line 5794 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 873:
  case_873();
  break;
case 874:
  case_874();
  break;
case 875:
  case_875();
  break;
case 876:
  case_876();
  break;
case 877:
  case_877();
  break;
case 878:
  case_878();
  break;
case 879:
  case_879();
  break;
case 886:
  case_886();
  break;
case 887:
  case_887();
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 899:
  case_899();
  break;
case 902:
#line 6034 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 903:
  case_903();
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 910:
#line 6083 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 911:
  case_911();
  break;
case 912:
#line 6102 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 915:
#line 6143 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 916:
#line 6150 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 917:
  case_917();
  break;
case 918:
#line 6160 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 919:
  case_919();
  break;
case 920:
  case_920();
  break;
case 921:
  case_921();
  break;
case 922:
  case_922();
  break;
case 923:
  case_923();
  break;
case 924:
  case_924();
  break;
case 925:
  case_925();
  break;
case 926:
  case_926();
  break;
case 927:
  case_927();
  break;
case 928:
  case_928();
  break;
case 930:
  case_930();
  break;
case 931:
#line 6265 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 932:
  case_932();
  break;
case 933:
  case_933();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
  case_937();
  break;
case 938:
  case_938();
  break;
case 939:
  case_939();
  break;
case 940:
  case_940();
  break;
case 941:
#line 6370 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 942:
  case_942();
  break;
case 943:
#line 6386 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
  case_946();
  break;
case 948:
  case_948();
  break;
case 949:
  case_949();
  break;
case 950:
#line 6450 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 951:
  case_951();
  break;
case 952:
  case_952();
  break;
case 953:
  case_953();
  break;
case 954:
  case_954();
  break;
case 956:
  case_956();
  break;
case 962:
#line 6504 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 963:
  case_963();
  break;
case 964:
#line 6523 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 965:
  case_965();
  break;
case 966:
  case_966();
  break;
case 967:
  case_967();
  break;
case 968:
  case_968();
  break;
case 969:
  case_969();
  break;
case 970:
  case_970();
  break;
case 971:
  case_971();
  break;
case 972:
  case_972();
  break;
case 973:
  case_973();
  break;
case 975:
  case_975();
  break;
case 976:
  case_976();
  break;
case 977:
  case_977();
  break;
case 979:
  case_979();
  break;
case 980:
  case_980();
  break;
case 982:
  case_982();
  break;
case 983:
  case_983();
  break;
case 984:
#line 6724 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 985:
  case_985();
  break;
case 986:
  case_986();
  break;
case 987:
#line 6741 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 988:
  case_988();
  break;
case 989:
  case_989();
  break;
case 991:
  case_991();
  break;
case 992:
  case_992();
  break;
case 995:
  case_995();
  break;
case 996:
  case_996();
  break;
case 1004:
#line 6863 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 1005:
#line 6870 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 1006:
  case_1006();
  break;
case 1007:
  case_1007();
  break;
case 1008:
#line 6887 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 1009:
#line 6891 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1010:
  case_1010();
  break;
case 1011:
  case_1011();
  break;
case 1012:
  case_1012();
  break;
case 1013:
  case_1013();
  break;
case 1015:
#line 6927 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 1017:
#line 6935 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1018:
#line 6939 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1019:
#line 6946 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 1021:
  case_1021();
  break;
case 1022:
  case_1022();
  break;
case 1023:
  case_1023();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 393 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 407 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 427 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 460 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 468 "cs-parser.jay"
{
		var un = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 475 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		current_namespace.AddUsing (un);
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 487 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_21()
#line 500 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_22()
#line 528 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_23()
#line 533 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_24()
#line 542 "cs-parser.jay"
{
		report.Error (1514, lexer.Location, "Unexpected symbol `{0}', expecting `.' or `{{'", GetSymbolName (yyToken));

		var name = (MemberName) yyVals[0+yyTop];		
		var ns = new NamespaceContainer (name, current_namespace);
		lbag.AddLocation (ns, GetLocation (yyVals[-1+yyTop]));
		current_namespace.AddTypeContainer (ns);
	  }

void case_25()
#line 554 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_26()
#line 559 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_27()
#line 566 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_40()
#line 604 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_42()
#line 626 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_50()
#line 659 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attributeCommas.Count > 0) {
			lbag.AppendTo (sect, attributeCommas);
			attributeCommas.Clear ();
		}
	  }

void case_51()
#line 670 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_52()
#line 686 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_53()
#line 691 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_54()
#line 699 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_55()
#line 706 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		}
 	  }

void case_56()
#line 722 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[0+yyTop]) }));
		}
	  }

void case_57()
#line 734 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_60()
#line 742 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 759 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);
		attributeCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = attrs;
	  }

void case_64()
#line 774 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_67()
#line 802 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_69()
#line 814 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_70()
#line 820 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_71()
#line 826 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_72()
#line 841 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 866 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_77()
#line 876 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_96()
#line 930 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_98()
#line 947 "cs-parser.jay"
{ 
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_99()
#line 953 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_100()
#line 966 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_101()
#line 971 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_102()
#line 977 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_104()
#line 995 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_105()
#line 1008 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_106()
#line 1021 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_111()
#line 1046 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_113()
#line 1059 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_114()
#line 1065 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_117()
#line 1080 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_118()
#line 1095 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_119()
#line 1108 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_120()
#line 1119 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_123()
#line 1142 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_124()
#line 1148 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_129()
#line 1175 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_131()
#line 1185 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_136()
#line 1211 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_138()
#line 1224 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_139()
#line 1230 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_142()
#line 1240 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_143()
#line 1249 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Was added earlier in the case of body being eof for full ast*/
	  }

void case_144()
#line 1256 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_146()
#line 1292 "cs-parser.jay"
{
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-6+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = method;

		lexer.ConstraintsParsing = true;
	  }

void case_147()
#line 1313 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null) {
			var method = (Method) yyVals[-1+yyTop];
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_149()
#line 1332 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_151()
#line 1341 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop]);

		current_type.AddMember (method);

		if (yyVals[-1+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[-1+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_152()
#line 1370 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_153()
#line 1391 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop]);

		current_type.AddMember (method);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_158()
#line 1420 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_159()
#line 1426 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_160()
#line 1435 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_161()
#line 1444 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_162()
#line 1452 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_163()
#line 1465 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_164()
#line 1472 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_167()
#line 1492 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_168()
#line 1500 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_169()
#line 1509 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_170()
#line 1533 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_171()
#line 1542 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_172()
#line 1549 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_173()
#line 1558 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_175()
#line 1573 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_179()
#line 1622 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_180()
#line 1646 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_181()
#line 1653 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_182()
#line 1660 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_183()
#line 1673 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_184()
#line 1679 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_185()
#line 1687 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Attributes) yyVals[-3+yyTop], Location.Null);
	  }

void case_186()
#line 1696 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_187()
#line 1702 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_189()
#line 1719 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_190()
#line 1730 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_191()
#line 1735 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_192()
#line 1749 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_193()
#line 1756 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_195()
#line 1770 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-5+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-4+yyTop], (Modifiers) yyVals[-6+yyTop], (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-5+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-3+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_197()
#line 1799 "cs-parser.jay"
{
		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_property = null;		
	  }

void case_202()
#line 1818 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_203()
#line 1832 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_204()
#line 1853 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_205()
#line 1877 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_206()
#line 1903 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_208()
#line 1928 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_209()
#line 1933 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_211()
#line 1948 "cs-parser.jay"
{
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_212()
#line 1954 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_213()
#line 1968 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_214()
#line 1974 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_230()
#line 2036 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AppendTo (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_234()
#line 2073 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_236()
#line 2085 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_261()
#line 2161 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `implicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_263()
#line 2184 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `explicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_264()
#line 2203 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_265()
#line 2209 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_266()
#line 2219 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_267()
#line 2236 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_268()
#line 2245 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (Tokenizer.LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_269()
#line 2274 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_275()
#line 2306 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_277()
#line 2316 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_278()
#line 2322 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_279()
#line 2328 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_280()
#line 2336 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_281()
#line 2345 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_282()
#line 2371 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_283()
#line 2385 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_284()
#line 2398 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_285()
#line 2406 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_286()
#line 2413 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_287()
#line 2426 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_290()
#line 2440 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_295()
#line 2464 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_297()
#line 2474 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_298()
#line 2483 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_302()
#line 2504 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_303()
#line 2509 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_304()
#line 2514 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_305()
#line 2522 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_306()
#line 2534 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_307()
#line 2550 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_308()
#line 2562 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_309()
#line 2578 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_311()
#line 2587 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_312()
#line 2600 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_313()
#line 2605 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_314()
#line 2622 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_315()
#line 2628 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_317()
#line 2648 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_318()
#line 2653 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_323()
#line 2671 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_324()
#line 2679 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_325()
#line 2692 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_326()
#line 2700 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_327()
#line 2714 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_330()
#line 2741 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_332()
#line 2760 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_334()
#line 2779 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_336()
#line 2790 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_338()
#line 2802 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_339()
#line 2811 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_341()
#line 2823 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_342()
#line 2834 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_343()
#line 2842 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_344()
#line 2849 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_346()
#line 2866 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_347()
#line 2875 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_349()
#line 2886 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_350()
#line 2895 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_351()
#line 2900 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_352()
#line 2908 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_353()
#line 2914 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_354()
#line 2922 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_356()
#line 2932 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_357()
#line 2946 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_358()
#line 2953 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_359()
#line 2963 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		var variance = (Variance) yyVals[-1+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], variance);
		if (variance != Variance.None)
			lbag.AddLocation (yyVal, savedLocation);
  	  }

void case_360()
#line 2971 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, Variance.None);
  	  }

void case_365()
#line 3005 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_367()
#line 3014 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_369()
#line 3023 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_372()
#line 3039 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_374()
#line 3055 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_377()
#line 3071 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_378()
#line 3077 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_379()
#line 3087 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_416()
#line 3151 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_417()
#line 3155 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_428()
#line 3196 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_430()
#line 3208 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_431()
#line 3215 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_432()
#line 3222 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_433()
#line 3229 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_435()
#line 3239 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_437()
#line 3247 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_438()
#line 3255 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_439()
#line 3260 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_440()
#line 3267 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_443()
#line 3282 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (new List<Expression> (), GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_444()
#line 3292 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_447()
#line 3308 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_448()
#line 3314 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_449()
#line 3320 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_450()
#line 3328 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_452()
#line 3337 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_453()
#line 3345 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  	}
	  }

void case_454()
#line 3354 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (new List<Expression> (), GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_459()
#line 3373 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_460()
#line 3379 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_461()
#line 3389 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_462()
#line 3404 "cs-parser.jay"
{
	  	if (lexer.putback_char == -1)
	  		lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_463()
#line 3411 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_468()
#line 3432 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_469()
#line 3437 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_470()
#line 3442 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_471()
#line 3447 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_473()
#line 3459 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_474()
#line 3464 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_475()
#line 3469 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_476()
#line 3477 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_477()
#line 3483 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_478()
#line 3489 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_479()
#line 3497 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_480()
#line 3503 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_484()
#line 3531 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_485()
#line 3536 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_488()
#line 3558 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_489()
#line 3571 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_490()
#line 3583 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_491()
#line 3591 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_492()
#line 3598 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_493()
#line 3605 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_494()
#line 3610 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_496()
#line 3622 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_497()
#line 3630 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_502()
#line 3653 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_503()
#line 3659 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_504()
#line 3670 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_505()
#line 3676 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_506()
#line 3682 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_507()
#line 3687 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_511()
#line 3702 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_512()
#line 3710 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_513()
#line 3715 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_518()
#line 3745 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_519()
#line 3752 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_520()
#line 3766 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_521()
#line 3772 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_523()
#line 3786 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_526()
#line 3797 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_527()
#line 3805 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_528()
#line 3811 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_529()
#line 3819 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_530()
#line 3827 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_531()
#line 3835 "cs-parser.jay"
{
		var tne = (ATypeNameExpression) yyVals[-3+yyTop];
		if (tne.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (tne, lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};		
	  }

void case_532()
#line 3849 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_533()
#line 3859 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_534()
#line 3870 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_535()
#line 3875 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_536()
#line 3885 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_537()
#line 3890 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new CheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_538()
#line 3899 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_539()
#line 3904 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnCheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_540()
#line 3913 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_542()
#line 3925 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_544()
#line 3938 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_548()
#line 3963 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_549()
#line 3973 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_553()
#line 3993 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_554()
#line 3998 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method is AnonymousMethodExpression) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_555()
#line 4017 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.LogicalNot, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_556()
#line 4023 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.OnesComplement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_557()
#line 4029 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_558()
#line 4036 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Await (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 4074 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

	  	yyVal = new Unary (Unary.Operator.UnaryPlus, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_567()
#line 4080 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.UnaryNegation, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_568()
#line 4086 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_569()
#line 4092 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_570()
#line 4098 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Indirection (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_571()
#line 4104 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.AddressOf, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 4114 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 4119 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_575()
#line 4124 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 4129 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_577()
#line 4136 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 4143 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 4154 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_581()
#line 4159 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4172 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_585()
#line 4179 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4186 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new As ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 4192 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Is ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_589()
#line 4202 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_590()
#line 4207 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 4212 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 4219 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4230 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 4235 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4240 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4245 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4250 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4257 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_600()
#line 4264 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4271 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4282 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4287 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4292 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_606()
#line 4299 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_608()
#line 4310 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_609()
#line 4315 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_611()
#line 4326 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_612()
#line 4331 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_614()
#line 4342 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_615()
#line 4347 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_617()
#line 4358 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_618()
#line 4363 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_620()
#line 4374 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_621()
#line 4379 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_623()
#line 4390 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_625()
#line 4402 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_626()
#line 4407 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_627()
#line 4413 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_628()
#line 4423 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_629()
#line 4428 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_630()
#line 4433 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_631()
#line 4438 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_632()
#line 4443 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_633()
#line 4448 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_634()
#line 4453 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_635()
#line 4458 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_636()
#line 4463 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_637()
#line 4468 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_638()
#line 4473 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_639()
#line 4481 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_640()
#line 4488 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_641()
#line 4504 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_642()
#line 4510 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_643()
#line 4516 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_645()
#line 4524 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_647()
#line 4536 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_649()
#line 4544 "cs-parser.jay"
{
	  	/* Handles only cases like foo = x.FirstOrDefault (l => );*/
	  	/* where we must restore current_variable*/

		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_651()
#line 4556 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_652()
#line 4564 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_653()
#line 4570 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_654()
#line 4575 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_655()
#line 4581 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_657()
#line 4590 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_658()
#line 4595 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_660()
#line 4604 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_661()
#line 4609 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_668()
#line 4632 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_669()
#line 4637 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_670()
#line 4642 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_674()
#line 4671 "cs-parser.jay"
{
		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_675()
#line 4682 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_676()
#line 4696 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_677()
#line 4702 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_680()
#line 4721 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_683()
#line 4735 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_684()
#line 4754 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_685()
#line 4762 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_686()
#line 4767 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_687()
#line 4772 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_688()
#line 4777 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_689()
#line 4782 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_690()
#line 4787 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_691()
#line 4792 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_692()
#line 4797 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_693()
#line 4802 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_694()
#line 4807 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_695()
#line 4812 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_696()
#line 4817 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_697()
#line 4822 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_698()
#line 4829 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_700()
#line 4838 "cs-parser.jay"
{
		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_701()
#line 4843 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_704()
#line 4860 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_705()
#line 4866 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_706()
#line 4885 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_707()
#line 4891 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_708()
#line 4901 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_709()
#line 4907 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_710()
#line 4934 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_711()
#line 4941 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_715()
#line 4961 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_716()
#line 4971 "cs-parser.jay"
{
		yyVal = Variance.Covariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_717()
#line 4976 "cs-parser.jay"
{
		yyVal = Variance.Contravariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_718()
#line 4997 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_720()
#line 5009 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_721()
#line 5014 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_722()
#line 5023 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_723()
#line 5028 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_724()
#line 5032 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_725()
#line 5041 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_726()
#line 5046 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_734()
#line 5074 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_735()
#line 5083 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_768()
#line 5147 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_769()
#line 5152 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_770()
#line 5157 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_771()
#line 5165 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_772()
#line 5173 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_775()
#line 5186 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_776()
#line 5202 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_777()
#line 5232 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_778()
#line 5243 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_781()
#line 5258 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_783()
#line 5267 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_786()
#line 5283 "cs-parser.jay"
{
		if (async_block) {
			report.Error (4003, GetLocation (yyVals[0+yyTop]), "`await' cannot be used as an identifier within an async method or lambda expression");
			yyVal = new Tokenizer.LocatedToken ("await", GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_787()
#line 5293 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_788()
#line 5300 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_789()
#line 5306 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_790()
#line 5313 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_792()
#line 5326 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_794()
#line 5337 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_795()
#line 5342 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
			current_variable.Initializer = ErrorExpression.Create (650, lexer.Location,
					"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
			current_variable.Initializer = ErrorExpression.Create (0, lexer.Location,
					"Syntax error");
		}
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_796()
#line 5356 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_800()
#line 5374 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_803()
#line 5389 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_804()
#line 5398 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_806()
#line 5414 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_811()
#line 5432 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_813()
#line 5445 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_814()
#line 5450 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_815()
#line 5458 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_817()
#line 5464 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_820()
#line 5482 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			yyVal = new StatementErrorExpression (yyVals[0+yyTop] as Expression);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_821()
#line 5495 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_822()
#line 5503 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_825()
#line 5517 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_826()
#line 5526 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_827()
#line 5536 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_829()
#line 5550 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_830()
#line 5556 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_831()
#line 5566 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_833()
#line 5575 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_834()
#line 5582 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_835()
#line 5589 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new List<SwitchSection> ();
	  }

void case_838()
#line 5608 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_839()
#line 5615 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_840()
#line 5625 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_841()
#line 5630 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_847()
#line 5649 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_848()
#line 5657 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_849()
#line 5667 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_850()
#line 5672 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_851()
#line 5677 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_852()
#line 5687 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_854()
#line 5704 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_856()
#line 5714 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_857()
#line 5725 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_859()
#line 5736 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_860()
#line 5748 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_861()
#line 5761 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_864()
#line 5774 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_865()
#line 5781 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_873()
#line 5805 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_874()
#line 5822 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_875()
#line 5835 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_876()
#line 5852 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_877()
#line 5861 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_878()
#line 5872 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as Tokenizer.LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_879()
#line 5885 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_886()
#line 5905 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_887()
#line 5913 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_888()
#line 5918 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_889()
#line 5926 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_890()
#line 5932 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_891()
#line 5937 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_892()
#line 5945 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_893()
#line 5950 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_894()
#line 5955 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_895()
#line 5963 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_896()
#line 5968 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_897()
#line 5976 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_898()
#line 5992 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_899()
#line 6010 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_903()
#line 6036 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_904()
#line 6041 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_905()
#line 6046 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_906()
#line 6054 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_907()
#line 6061 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [l.Count - 1].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_911()
#line 6085 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_913()
#line 6104 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_914()
#line 6115 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		/* Required otherwise missing block could not be detected because*/
		/* start_block is run early*/
		var c = new Catch (null, GetLocation (yyVals[-5+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-3+yyTop];
		
		if (yyVals[-2+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		if (yyVals[-2+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = c;
	  }

void case_917()
#line 6155 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_919()
#line 6165 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_920()
#line 6173 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_921()
#line 6183 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_922()
#line 6193 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_923()
#line 6198 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_924()
#line 6211 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_925()
#line 6221 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_926()
#line 6226 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_927()
#line 6236 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_928()
#line 6244 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_930()
#line 6255 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_932()
#line 6267 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_933()
#line 6279 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_934()
#line 6291 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_935()
#line 6302 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_936()
#line 6309 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_937()
#line 6318 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_938()
#line 6328 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_939()
#line 6343 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_940()
#line 6353 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_942()
#line 6372 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);

		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_944()
#line 6388 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_945()
#line 6407 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_946()
#line 6422 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_948()
#line 6435 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_949()
#line 6440 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_951()
#line 6452 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_952()
#line 6459 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_953()
#line 6467 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_954()
#line 6474 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_956()
#line 6486 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_963()
#line 6506 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_965()
#line 6525 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_966()
#line 6535 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_967()
#line 6543 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_968()
#line 6551 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_969()
#line 6559 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_970()
#line 6597 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_971()
#line 6605 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_972()
#line 6613 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_973()
#line 6621 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_975()
#line 6667 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_976()
#line 6675 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		lbag.AddLocation (current_block, GetLocation (yyVals[0+yyTop]));
	  }

void case_977()
#line 6680 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_979()
#line 6691 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_980()
#line 6698 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_982()
#line 6707 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_983()
#line 6714 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_985()
#line 6726 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_986()
#line 6731 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_988()
#line 6743 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_989()
#line 6748 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_991()
#line 6758 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_992()
#line 6774 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_995()
#line 6801 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_type.AddMember (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_996()
#line 6829 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_1006()
#line 6872 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1007()
#line 6878 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_1010()
#line 6893 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_1011()
#line 6898 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_1012()
#line 6906 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_1013()
#line 6914 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_1021()
#line 6952 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1022()
#line 6958 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1023()
#line 6967 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   19,   20,   17,   17,   18,   18,   18,   22,   22,   23,
   23,    7,    7,    6,    6,   21,   21,    8,    8,   24,
   24,   24,   25,   25,   25,   25,   25,    9,    9,   10,
   10,   33,   31,   36,   32,   32,   34,   34,   34,   34,
   35,   35,   40,   37,   38,   39,   39,   41,   41,   41,
   41,   41,   42,   42,   46,   43,   45,   48,   48,   48,
   49,   49,   50,   50,   51,   51,   51,   51,   51,   51,
   51,   51,   51,   51,   51,   51,   65,   67,   69,   70,
   71,   27,   27,   74,   52,   52,   75,   75,   76,   76,
   77,   79,   73,   73,   78,   78,   84,   53,   88,   53,
   53,   83,   91,   83,   85,   85,   92,   92,   93,   94,
   93,   89,   89,   95,   95,   96,   97,   87,   87,   90,
   90,   90,  100,   54,  103,  104,   98,  105,  106,  107,
   98,   98,   98,   99,   99,  102,  102,  110,  110,  110,
  110,  110,  110,  110,  110,  110,  110,  111,  111,  114,
  114,  114,  114,  117,  114,  115,  115,  118,  118,  119,
  119,  119,  112,  112,  112,  120,  120,  120,  113,  122,
  124,  125,   55,  127,  128,  129,   57,  123,  123,  123,
  123,  123,  133,  130,  134,  131,  132,  132,  132,  135,
  136,  137,  139,   28,   28,  138,  138,  140,  140,  141,
  141,  141,  141,  141,  141,  141,  141,  141,  144,   58,
  143,  143,  145,  145,  148,  142,  142,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  147,  147,  150,
  149,  151,  149,  149,  149,   59,  154,  156,  152,  153,
  153,  155,  155,  160,  158,  161,  158,  158,  158,  162,
   60,  164,   56,  167,  168,   56,   56,  163,  170,  163,
  165,  165,  171,  171,  172,  173,  172,  174,  169,  166,
  166,  166,  166,  166,  178,  175,  179,  176,  177,  177,
   61,  181,  183,  184,   29,  180,  180,  180,  182,  182,
  182,  185,  185,  186,  187,  186,  186,  186,  188,  189,
  190,   30,  191,  191,   16,   16,  192,  192,  195,  194,
  194,  194,  196,  196,  198,   64,  121,  101,  101,  126,
  126,  199,  199,  199,  197,  197,  200,  200,  201,  201,
  203,  203,   82,   72,   72,   86,   86,  116,  116,  146,
  146,  204,  204,  204,  204,  204,  208,  208,  209,  207,
  207,  207,  207,  207,  207,  207,  210,  210,  210,  210,
  210,  210,  210,  210,  210,  211,  211,  211,  211,  211,
  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
  211,  211,  211,  211,  211,  212,  212,  212,  213,  213,
  213,  233,  233,  234,  234,  235,  235,  215,  215,  232,
  232,  232,  232,  232,  232,  232,  232,  217,  217,  217,
  237,  237,  238,  238,  239,  239,  241,  241,  241,  242,
  242,  242,  242,  242,  243,  243,  159,  159,  236,  236,
  236,  236,  236,  248,  248,  247,  247,  249,  249,  249,
  249,  250,  218,  218,  218,  246,  246,  246,  251,  251,
  252,  252,  219,  220,  220,  221,  222,  223,  223,  214,
  214,  214,  214,  214,  257,  253,  224,  258,  258,  259,
  259,  260,  260,  261,  261,  261,  261,  254,  254,  205,
  205,  256,  256,  262,  262,  255,  255,   81,   81,  263,
  263,  264,  225,  265,  265,  265,  266,  266,  266,  266,
  266,  267,  193,  226,  226,  227,  227,  228,  228,  229,
  269,  230,  270,  230,  268,  268,  272,  271,  216,  273,
  273,  273,  273,  273,  273,  273,  273,  273,  274,  274,
  274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
  274,  275,  275,  275,  275,  275,  275,  275,  276,  276,
  276,  276,  276,  276,  276,  276,  276,  277,  277,  277,
  277,  277,  278,  278,  278,  278,  278,  278,  278,  278,
  278,  279,  279,  279,  279,  279,  280,  280,  280,  281,
  281,  281,  282,  282,  282,  283,  283,  283,  284,  284,
  284,  285,  285,  286,  286,  286,  286,  287,  287,  287,
  287,  287,  287,  287,  287,  287,  287,  287,  288,  288,
  289,  289,  289,  290,  290,  292,  291,  291,  291,  293,
  293,  295,  294,  296,  294,  297,  298,  294,  299,  300,
  294,   44,   44,  244,  244,  244,  244,  231,  231,  231,
   80,  302,  303,  304,  305,  306,   26,   63,   63,   62,
   62,  108,  108,  307,  307,  307,  307,  307,  307,  307,
  307,  307,  307,  307,  307,  307,  307,  307,   66,   66,
   66,   68,   68,  308,  308,  309,  309,  310,  310,  311,
  311,  311,  311,  202,  202,  312,  312,  314,  109,  315,
  315,  316,  157,  157,  318,  317,  313,  313,  319,  319,
  320,  320,  320,  320,  320,  324,  324,  325,  325,  325,
  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,
  322,  322,  322,  326,  326,  326,  326,  326,  326,  326,
  326,  326,  326,  326,  326,  326,  340,  340,  340,  340,
  327,  341,  323,  342,  342,  343,  343,  343,  343,  343,
  343,  206,  206,  344,   47,   47,  346,  321,  350,  321,
  348,  348,  345,  345,  345,  345,  347,  347,  354,  354,
  353,  353,  355,  355,  349,  349,  351,  351,  356,  356,
  357,  352,  352,  352,  328,  328,  328,  339,  339,  358,
  359,  359,  329,  329,  360,  360,  360,  363,  361,  361,
  362,  362,  364,  364,  364,  367,  365,  366,  366,  368,
  368,  368,  330,  330,  330,  330,  369,  369,  370,  370,
  370,  374,  371,  377,  373,  373,  380,  376,  376,  379,
  379,  375,  375,  383,  382,  382,  378,  378,  381,  381,
  385,  384,  384,  372,  372,  386,  372,  372,  372,  331,
  331,  331,  331,  331,  331,  387,  388,  388,  389,  389,
  389,  390,  390,  390,  391,  391,  392,  392,  392,  393,
  393,  332,  332,  332,  332,  394,  394,  396,  396,  395,
  397,  395,  395,  395,  333,  334,  398,  337,  335,  335,
  400,  401,  338,  403,  404,  336,  336,  336,  402,  402,
  399,  399,  301,  301,  301,  301,  405,  405,  407,  407,
  409,  408,  410,  408,  406,  406,  406,  406,  406,  414,
  412,  415,  416,  412,  411,  411,  417,  417,  417,  417,
  417,  422,  418,  423,  419,  424,  425,  426,  420,  428,
  429,  430,  420,  427,  427,  432,  421,  431,  435,  431,
  434,  437,  434,  433,  433,  433,  436,  436,  436,  413,
  438,  413,    3,    3,  439,    3,    3,  440,  440,  245,
  245,  240,  240,    5,  441,  441,  441,  441,  445,  441,
  441,  441,  441,  442,  442,  443,  446,  443,  444,  444,
  447,  447,  448,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    3,    5,    2,
    0,    0,   11,    3,    1,    3,    1,    0,    1,    0,
    1,    0,    1,    0,    1,    0,    1,    1,    2,    1,
    1,    2,    1,    1,    1,    1,    1,    0,    1,    1,
    2,    0,    3,    0,    6,    3,    1,    1,    1,    1,
    1,    3,    0,    3,    1,    0,    3,    0,    1,    1,
    3,    3,    1,    1,    0,    4,    4,    0,    1,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    0,    0,    0,
    0,   16,    5,    0,    9,    5,    0,    1,    1,    2,
    3,    0,    3,    1,    1,    1,    0,    8,    0,    9,
    6,    0,    0,    3,    0,    1,    1,    2,    2,    0,
    5,    0,    1,    1,    2,    3,    0,    4,    2,    1,
    1,    1,    0,    3,    0,    0,   10,    0,    0,    0,
   12,    8,    5,    1,    1,    0,    1,    1,    3,    3,
    3,    5,    3,    5,    1,    1,    1,    1,    3,    4,
    6,    2,    4,    0,    7,    0,    1,    1,    2,    1,
    1,    1,    4,    6,    4,    1,    2,    2,    1,    0,
    0,    0,   10,    0,    0,    0,   13,    1,    2,    1,
    2,    1,    0,    5,    0,    5,    1,    1,    1,    0,
    0,    0,    0,   15,    5,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    5,
    1,    1,    1,    1,    0,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    7,    0,    7,    2,    2,    2,    0,    0,    9,    1,
    1,    0,    1,    0,    6,    0,    6,    2,    1,    0,
    8,    0,    9,    0,    0,   10,    5,    0,    0,    3,
    0,    1,    1,    2,    2,    0,    5,    0,    2,    2,
    2,    1,    1,    1,    0,    5,    0,    5,    1,    1,
    2,    0,    0,    0,   12,    0,    2,    2,    0,    1,
    2,    1,    3,    2,    0,    5,    3,    1,    0,    0,
    0,   13,    0,    1,    1,    3,    1,    4,    2,    0,
    3,    2,    1,    3,    0,    3,    1,    1,    3,    1,
    2,    3,    4,    4,    0,    3,    1,    3,    3,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    2,    2,    2,    2,    2,    1,    3,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    3,    3,    4,
    4,    4,    3,    3,    4,    3,    4,    4,    4,    3,
    0,    1,    3,    4,    0,    1,    1,    3,    2,    3,
    1,    2,    3,    2,    1,    1,    0,    1,    1,    3,
    3,    3,    2,    1,    1,    1,    1,    2,    2,    4,
    3,    1,    4,    4,    3,    1,    3,    2,    1,    3,
    1,    1,    1,    4,    3,    2,    2,    6,    3,    7,
    4,    3,    7,    3,    0,    2,    4,    1,    2,    0,
    1,    1,    3,    3,    1,    1,    1,    0,    1,    1,
    2,    2,    3,    1,    2,    0,    1,    2,    4,    1,
    3,    0,    5,    1,    1,    1,    2,    3,    3,    4,
    4,    1,    2,    4,    4,    4,    2,    4,    2,    4,
    0,    4,    0,    5,    0,    1,    0,    4,    4,    1,
    2,    2,    4,    2,    2,    2,    4,    2,    1,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    1,    3,    3,    3,    3,    3,    3,    1,    3,
    3,    3,    3,    3,    3,    3,    3,    1,    3,    3,
    3,    3,    1,    3,    3,    3,    3,    3,    3,    3,
    3,    1,    3,    3,    3,    3,    1,    3,    3,    1,
    3,    3,    1,    3,    3,    1,    3,    3,    1,    3,
    3,    1,    3,    1,    5,    4,    5,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    1,    3,
    3,    2,    1,    0,    1,    0,    2,    1,    1,    1,
    1,    0,    4,    0,    5,    0,    0,    7,    0,    0,
    8,    1,    1,    1,    1,    1,    1,    6,    4,    4,
    1,    1,    0,    0,    0,    0,   15,    0,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    2,
    3,    0,    1,    1,    2,    4,    3,    1,    3,    1,
    3,    1,    1,    0,    1,    1,    1,    0,    4,    1,
    1,    0,    4,    1,    0,    4,    0,    1,    1,    2,
    1,    1,    1,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    0,    4,    1,    2,    2,    2,    2,    2,    2,
    1,    1,    2,    1,    1,    1,    0,    6,    0,    7,
    1,    1,    0,    2,    2,    1,    0,    1,    0,    1,
    1,    2,    2,    4,    0,    2,    0,    1,    1,    2,
    4,    1,    5,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    5,    7,    4,    0,    8,    4,
    0,    1,    1,    2,    1,    0,    3,    1,    2,    3,
    3,    1,    1,    1,    1,    1,    5,    4,    7,    3,
    6,    0,    4,    0,    4,    2,    0,    4,    2,    3,
    1,    0,    1,    0,    5,    1,    0,    1,    0,    1,
    1,    1,    3,    4,    5,    0,    9,    5,    4,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    3,    4,
    3,    3,    3,    2,    3,    2,    4,    4,    3,    0,
    1,    3,    4,    5,    3,    1,    2,    0,    1,    2,
    0,    7,    3,    6,    2,    2,    0,    3,    5,    4,
    0,    0,   10,    0,    0,    9,    5,    4,    2,    1,
    0,    2,    2,    2,    2,    2,    4,    5,    4,    5,
    0,    5,    0,    6,    3,    2,    2,    2,    1,    0,
    3,    0,    0,    6,    1,    2,    1,    1,    1,    1,
    1,    0,    5,    0,    3,    0,    0,    0,   12,    0,
    0,    0,   13,    0,    2,    0,    3,    1,    0,    4,
    1,    0,    4,    1,    2,    2,    1,    2,    2,    0,
    0,    4,    2,    3,    0,    4,    2,    2,    3,    0,
    1,    1,    1,    2,    2,    2,    4,    3,    0,    7,
    4,    4,    3,    1,    3,    0,    0,    4,    0,    1,
    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  993,    0,    0,  997,    0,
    0,   15,   17,  382,  388,  395,  383,  385,    0,  384,
    0,  391,  393,  380,    0,  387,  389,  381,  392,  394,
  390,  345, 1014,    0,  386, 1004,    0,   10,    1,    0,
    0,    0,   12,    0,  822,    0,    0,    0,    0,    0,
    0,    0,    0,  423,    0,    0,    0,    0,    0,    0,
    0,  421,    0,    0,    0,  483,    0,  422,    0,  522,
    0,  917,    0,    0,    0,  667,    0,    0,    0,    0,
    0,    0,    0,  718,    0,  771,    0,    0,    0,    0,
    0,    0,    0,    0,  420,    0,  656,    0,  821,    0,
  754,    0,    0,    0,    0,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,  414,  415,  418,  419,  663,  559,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  664,  662,  665,  666,  738,  740,    0,  736,  739,  755,
  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  756,    0,    0,    0,  823,  824,  843,  844,  845,  846,
  880,  881,  882,  883,  884,  885,    0,    0,    0,   20,
    0,    0,  335,    0,  337, 1001,   16,  994,    0,    0,
  243,  242,  239,  244,  245,  238,  257,  256,  249,  250,
  246,  248,  247,  251,  240,  241,  252,  253,  259,  258,
  254,  255,    0,    0, 1017,    0, 1006,    0, 1005,    3,
   52,    0,    0,    0,   41,   38,   40,   43,   44,   45,
   46,   47,   50,   13,    0,    0,    0,  886,  537,  424,
  425,  915,    0,    0,    0,    0,    0,    0,    0,  888,
  887,    0,  547,  541,  546,  770,  820,  741,  768,  767,
  769,  742,  743,  744,  745,  746,  747,  748,  749,  750,
  751,  752,  753,    0,    0,    0,  852,    0,    0,    0,
  786,  785,    0,    0,    0,    0,    0,    0,    0,    0,
  894,    0,    0,    0,    0,  396,    0,    0,    0,  896,
  901,    0,    0,    0,  539,  916,    0,    0,    0,  784,
  780,    0,    0,    0,    0,    0,    0,    0,  364,    0,
    0,    0,    0,    0,    0,    0,    0,  659,    0,  558,
  554,    0,    0,  556,  552,  566,  560,  567,  561,  555,
  551,  571,  565,  570,  564,  568,  562,  569,  563,  652,
  533,    0,  417,  416,    0,    0,    0,    0,    0,  772,
    0,  334,    0,  778,  779,    0,  486,  487,    0,    0,
    0,  776,  777,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  996,  737,  787,  775,
    0,  818,  819,  949,  964,    0,    0,  950,  952,    0,
  976,  935,  933,  957,    0,    0,  955,  958,  959,  960,
  961,  936,  934,    0,    0,    0,  339,    0,   18,    0,
    0,    0, 1013,    0,  346,    0,    0,    0, 1015,    0,
    0,   39,  689,  695,  687,    0,  684,  694,  688,  686,
  685,  692,  690,  691,  697,  693,  696,  698,    0,    0,
  682,   42,   51,  485,    0,  481,  482,    0,    0,  479,
    0,  789,    0,    0,    0,  850,    0,  817,  815,  816,
    0,    0,    0,  671,    0,  891,  889,  672,    0,    0,
  507,    0,    0,    0,  498,    0,  502,  512,  514,    0,
  494,    0,    0,    0,    0,    0,  489,    0,  492,    0,
  496,  366,  893,  892,    0,    0,  895,  905,    0,    0,
    0,  906,    0,    0,  918,    0,    0,  783,    0,  376,
  372,  373,    0,    0,  371,  374,  375,    0,    0,    0,
  572,    0,    0,  543,    0,  654,  735,    0,    0,    0,
  729,  731,  732,  733,  428,  429,    0,  342,  343,    0,
  181,  180,  182,    0,    0,    0,    0,  368,    0,  639,
    0,    0,  899,    0,    0,    0,  433,    0,  436,    0,
  434,    0,  475,    0,  440,    0,    0,    0,    0,  464,
  467,    0,    0,  459,  466,  465,  628,  629,  630,  631,
  632,  633,  634,  635,  636,  638,  637,  576,  573,  578,
  575,  577,  574,  586,  582,  587,  583,  584,    0,  585,
    0,  591,    0,  592,    0,  598,    0,  599,    0,  600,
    0,  601,    0,  605,    0,  606,    0,  609,    0,  612,
    0,  615,    0,  618,    0,  621,    0,  623,    0,    0,
  511,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  948,  947,    0,  956,    0,  946,    0,    0,  336, 1011,
 1012,  360,    0,    0,    0,  357,    0,    0,  178,    0,
    0, 1021, 1007, 1009,   60,   58,   59,    0,    0,   53,
    0,    0,   61,   63,   27,   25,    0,    0,    0,  679,
    0,  683,  432,    0,  484,    0,  536,    0,  549,  167,
  189,    0,    0,    0,  157,    0,    0,    0,  168,  542,
    0,  921,    0,  872,  853,    0,  863,    0,  874,    0,
  890,  827,    0,  920,    0,    0,  497,    0,  513,  515,
    0,    0,  451,    0,    0,  447,    0,    0,  476,    0,
  517,  491,    0,    0,  142,  518,  140,  141,  520,    0,
  535,  534,  830,    0,  910,    0,  903,    0,  907,  526,
    0,    0,    0,  361,    0,  524,    0,    0,  538,  928,
    0,  924,  848,    0,  939,    0,  937,    0,    0,  669,
  670,    0,    0,    0,  734,  720,  721,  719,  730,  649,
  648,  653,    0,    0,  341,  642,    0,    0,    0,  557,
  553,  898,  897,  773,  437,  431,  435,  430,  540,  474,
  473,  472,  469,  468,    0,  463,  426,  427,  438,  439,
    0,  626,    0,  796,    0,    0,  651,  650,  965,  941,
    0,  966,    0,  951,  953,  962,    0,  977,    0,  945,
  991,   19,  338,  717,  716,    0,  715,    0,  356, 1023,
  179, 1018,    0,    0,   54,    0,    0,    0,    0,    0,
    0,  363,    0,  673,    0,    0,   80,   79,    0,  480,
    0,    0,    0,    0,    0,  172,  548,    0,    0,    0,
    0,    0,  864,  856,  854,    0,  875,    0,    0,  919,
  504,  503,  454,    0,    0, 1002, 1003,  443,  449,    0,
  452,    0,  478,    0,    0,    0,    0,    0,  828,  913,
    0,  904,    0,  532,  527,    0,    0,  523,    0,  927,
    0,  847,  940,  938,    0,  544,    0,  655,  647,  344,
  641,  640,  657,  471,    0,  462,  461,  460,  627,  625,
  142,    0,  812,  794,    0,    0,    0,  801,    0,  943,
    0,  970,    0,    0,  985,  986,  979,    0,  359,  358,
 1022,    0,    0,   62,   56,    0,   64,   26,   22,    0,
    0,  312,    0,  215,    0,  103,    0,   77,  806,  115,
  116,    0,    0,    0,  809,  187,  188,    0,    0,    0,
    0,  160,  169,  161,  163,  851,    0,    0,    0,    0,
    0,  873,    0,    0,  453,  455,  456,  450,  444,  448,
    0,  509,    0,  477,  488,  442,  521,  519,    0,  909,
    0,    0,    0,  528,    0,  930,    0,    0,  668,  660,
    0,  470,    0,    0,  792,  791,  788,  802,  942,    0,
    0,    0,    0,  963,    0,  992, 1010,    0,    0,    0,
   69,   70,   73,   74,    0,  329,  318,  317,    0,  674,
  211,   98,    0,  790,  810,  173,    0,  185,    0,    0,
    0,  849,  932,    0,    0,    0,    0,  855,    0,  876,
  826,  493,  490,  835,    0,  842,    0,    0,  833,    0,
  838,    0,  531,  530,  929,  925,    0,  658,    0,    0,
  944,  967,    0,  954,    0,    0,  981,    0,   75,   67,
    0,    0,    0,  313,    0,    0,    0,    0,    0,  174,
    0,  164,  162,  922,  865,  859,  857,    0,    0,  829,
  834,    0,  839,  914,    0,    0,  661,    0,  804,    0,
  971,  988,  989,  982,   55,    0,   71,   72,    0,    0,
    0,    0,    0,    0,    0,  811,  171,    0,  184,    0,
    0,  877,  841,  840,    0,  725,  912,  926,  813,    0,
    0,    0,   76,    0,    0,  330,    0,    0,  328,  314,
    0,  322,  379,    0,  377,    0,  675,    0,  704,  212,
   99,  175,  923,  861,  858,    0,    0,  870,    0,  968,
    0,  983,    0,    0,    0,  311,    0,    0,  701,    0,
    0,    0,  705,    0,    0,    0,    0,    0,  972,   29,
   23,  331,  327,    0,    0,  323,  378,  707,    0,    0,
    0,  100,  860,  726,    0,    0,    0,    0,  315,  712,
    0,  713,  710,    0,  708,   96,    0,   94,    0,    0,
   83,   85,   86,   87,   88,   89,   90,   91,   92,   93,
   95,  143,    0,    0,  228,  220,  221,  222,  223,  224,
  225,  226,  227,    0,    0,  218,    0,    0,  969,    0,
  332,  326,    0,    0,    0,  676,   84,    0,  722,  724,
  271,  266,  270,    0,  213,  219,    0,  975,  973,  711,
  709,    0,    0,    0,    0,    0,    0,    0,  280,    0,
    0,  229,    0,    0,  237,    0,  155,  144,  154,    0,
    0,  101,    0,    0,  265,    0,    0,  264,    0,  148,
    0,    0,  350,    0,  348,    0,    0,  190,    0,    0,
    0,    0,    0,  677,    0,  214,    0,  106,  104,  287,
    0,  347,    0,    0,    0,    0,  119,    0,    0,    0,
    0,    0,    0,  153,  145,    0,    0,  194,    0,  351,
    0,  232,  231,  230,    0,  723,  102,    0,  284,    0,
  262,  121,    0,  260,    0,    0,    0,  123,    0,  352,
    0,    0,  191,    0,    0,    0,  349,  235,  114,  112,
    0,    0,  289,    0,    0,    0,    0,    0,  149,    0,
  268,    0,    0,    0,    0,  127,    0,    0,    0,    0,
  353,  354,    0,    0,    0,    0,    0,  109,  304,    0,
  285,    0,    0,  298,    0,    0,    0,  293,    0,  139,
    0,    0,    0,    0,  134,    0,    0,  281,    0,  124,
    0,  118,  128,  146,  152,  202,    0,  192,    0,    0,
  195,    0,  113,    0,  105,  110,    0,    0,    0,  300,
    0,  301,  290,    0,    0,  283,  294,  263,    0,    0,
  120,  135,  261,    0,  279,    0,  269,  273,  130,    0,
    0,    0,  199,  201,    0,  236,  111,  305,  307,  286,
    0,    0,  299,  296,  138,  136,  150,  278,    0,    0,
    0,  147,  203,  205,  193,    0,    0,    0,  298,    0,
  274,  276,  131,    0,    0,  196,  309,  310,  306,  308,
  297,  151,    0,    0,  209,  208,  207,  204,  206,    0,
    0,    0,  197,  275,  277,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   49,    9,   50,   10,   11,   51,  232,  732,  694,
   12,   13,   52,   22,   23,  326,  235,  717,  890, 1085,
 1205, 1557,  887,  236,  237,  238,  239,  240,  241,  242,
  243,  710,  460,  711,  712,  993,  713,  714,  997,  888,
 1080, 1081, 1082,  267,  611, 1176,  110,  899, 1279, 1280,
 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290,
 1291,  479,  721, 1365, 1007, 1183, 1147, 1217, 1245, 1307,
 1377, 1213, 1431, 1408, 1456, 1457, 1458, 1009, 1454, 1010,
  778, 1341, 1419, 1392, 1444,  531, 1437, 1413, 1473,  973,
 1442, 1445, 1446, 1541, 1474, 1475, 1471, 1292, 1348, 1318,
 1366,  734, 1421, 1520, 1389, 1477, 1550,  480,  268,  735,
  736,  737,  738,  739,  697,  586, 1188,  698,  699,  905,
 1368, 1397, 1488, 1449, 1522, 1369, 1424, 1525, 1570, 1489,
 1490, 1568, 1554, 1555, 1005, 1146, 1244, 1304, 1351, 1305,
 1306, 1342, 1404, 1372, 1343,  329,  223, 1453, 1345, 1438,
 1435, 1293, 1322, 1362, 1517, 1479, 1323, 1518,  612, 1563,
 1564, 1361, 1434, 1410, 1466, 1461, 1432, 1498, 1503, 1464,
 1467, 1468, 1549, 1504, 1462, 1463, 1559, 1547, 1548, 1002,
 1089, 1210, 1181, 1237, 1211, 1212, 1254, 1143, 1234, 1267,
  551,  193,  112,  364,  195,  580,  455,  224, 1384,  695,
  696,  876,  892,  330,  420,  550,  305, 1214, 1215,   45,
  114,  306,  116,  117,  118,  119,  120,  121,  122,  123,
  124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
  134,  135,  136,  253,  849,  774, 1045,  527,  764,  928,
  765,  766, 1038,  137,  198,  770,  614,  615,  616,  843,
  489,  490,  298, 1043,  772,  421,  300,  514,  515,  516,
  517,  520,  780,  314,  797,  798,  945,  264,  495,  812,
  265,  494,  138,  139,  140,  141,  142,  143,  144,  145,
  146,  147,  148,  149,  150,  151,  152,  589,  590,  591,
  822,  823,  859,  153,  577,  814,  365, 1061,  565, 1127,
  154,  509, 1003, 1145, 1242, 1346,  481, 1218, 1219, 1274,
 1275,  877,  569,  342,  818, 1350, 1197, 1229,  570,  571,
  269,  270,  271,  157,  158,  159,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  171,  284,
  596,  172,  173,  322,  856,  670,  976, 1067,  902,  728,
 1013,  974,  977, 1105,  978, 1014, 1015,  285,  174,  175,
  176, 1117, 1049, 1118, 1119, 1120, 1162, 1121,  177,  178,
  179,  180,  745,  502,  746, 1108, 1031, 1109, 1225, 1191,
 1226,  747, 1030,  748, 1228, 1158,  181,  182,  183,  184,
  185,  186,  307,  541,  542, 1051, 1165,  318, 1029,  912,
 1190, 1058,  951, 1166,  187,  433,  188,  434,  979, 1070,
  435,  436,  686,  677,  678,  983,  437,  438,  439,  440,
  441,  984,  672,  981, 1170, 1248, 1309, 1072, 1201, 1266,
  868,  680,  869, 1136, 1075, 1137, 1202,  988,   17,   19,
   46,   47,  227,  700,  884,  456,  701,  702,
  };
  protected static readonly short [] yySindex = {            3,
    0, -168,  137,  -26,  204,16415,    0,  152,    0,    0,
  204,  -26,    0,    0,  223,    0, 6584,  204,    0, -165,
 -260,    0,    0,    0,    0,    0,    0,    0,  400,    0,
  406,    0,    0,    0,  943,    0,    0,    0,    0,    0,
    0,    0,    0,  425,    0,    0,  448,    0,    0,  152,
  504,  204,    0,  533,    0,  384,  555, -164,15897,   43,
  -42,  363, 6741,    0,  -42,  -42,  -42,   74,  -42,  -42,
  796,    0, 8587,  -42,  -42,    0, 8744,    0,  626,    0,
 -132,    0,  -42,  561,  -42,    0,16459,16459,  658,  -42,
  -42,   50, 9529,    0,14864,    0, 9660, 9791, 9922,10053,
10184,10315,10446,10577,    0,  341,    0, 8447,    0,  274,
    0,  636,  583,  645, -236,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1183,  855,
  275, -268,  680,  132,  675,  696,  662,  664,  133,  683,
    0,    0,    0,    0,    0,    0, 3611,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -30,  806,  148,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -174,  373,  504,    0,
  551,  518,    0,  725,    0,    0,    0,    0, 8447, 8447,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  817,  778,    0,  785,    0, -273,    0,    0,
    0,  504,16932,  671,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  955,  798,15000,    0,    0,    0,
    0,    0,14864, -169, -145,  959,  485,  645,  -30,    0,
    0, 8447,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   55,  199,15897,    0, 8447,14864,  890,
    0,    0,  922,14864,14864,13197,  244,  -82,  872, 8604,
    0, 9529,  341, 1013,  931,    0,  932, 8447,14864,    0,
    0,  936,  699,  -42,    0,    0,14864,  626,14320,    0,
    0,  561,14864,  561, -276,  639, 1019,  -30,    0,  806,
 -236, 1020,  -30,14864,14864,14864,  363,    0,  973,    0,
    0, 6898, -278,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 4494,    0,    0,16370, -276,  952,  957,14864,    0,
  929,    0,  530,    0,    0,  573,    0,    0,  926, 8901,
 7369,    0,    0,14864,14864,14864,14864,14864,14864,14864,
14864,14864,14864,14864,10708,10839,10970, 4659, 7386,11101,
11232,11363,11494,11625,11756,11887,12018,12149,12280,12411,
12542,12673,12804,12935,15680,14864,    0,    0,    0,    0,
  806,    0,    0,    0,    0,16459,16459,    0,    0,  -30,
    0,    0,    0,    0,  421,  990,    0,    0,    0,    0,
    0,    0,    0,  504,  671,  933,    0,  934,    0,  929,
  817,  817,    0,  106,    0,  554,  817,  978,    0, -172,
16932,    0,    0,    0,    0, -153,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -182,16962,
    0,    0,    0,    0,  929,    0,    0,  974,  708,    0,
  981,    0,  982,  215,  626,    0,  -42,    0,    0,    0,
  -30,14320, -120,    0,  979,    0,    0,    0, -166,   72,
    0,  472,    0,  988,    0,  976,    0,    0,    0,  723,
    0, 8271,  729,14864,  872,14184,    0, 7526,    0,  561,
    0,    0,    0,    0,   89,   98,    0,    0,  -20,  626,
  601,    0, 4335,  985,    0,  161,  -30,    0,  180,    0,
    0,    0,14864, 1064,    0,    0,    0,14864, 1066,  989,
    0,  992,  993,    0,16370,    0,    0, -176,  202, 6898,
    0,    0,    0,    0,    0,    0,   54,    0,    0,  219,
    0,    0,    0,  561, -276,  -30, 8761,    0,  994,    0,
  995,13066,    0, 1106,  998, 6898,    0, -298,    0, -296,
    0,  929,    0,   52,    0,14864,14864,  999, 1110,    0,
    0, -275,   75,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  855,    0,
  855,    0,  275,    0,  275,    0, -268,    0, -268,    0,
 -268,    0, -268,    0,  680,    0,  680,    0,  132,    0,
  675,    0,  696,    0,  662,    0,  664,    0,   56, -180,
    0, 9058, 1075,  -30, 1077,  -30, 9058, 9058,  996,14864,
    0,    0,  990,    0,  -30,    0,  756,  929,    0,    0,
    0,    0,  410,  504,  435,    0, 8761,  554,    0, 1003,
 1002,    0,    0,    0,    0,    0,    0, -276, 1007,    0,
 1008, 1010,    0,    0,    0,    0, 1009, 8918,  967,    0,
  508,    0,    0,  718,    0,15000,    0, 1006,    0,    0,
    0,  781,  126, 1016,    0, 1015, 1017, 1022,    0,    0,
14864,    0,  -30,    0,    0,  754,    0, 1024,    0, -139,
    0,    0, 6741,    0, 6741, 8430,    0,13197,    0,    0,
14456,  322,    0,  262,  149,    0,  961,  970,    0,  110,
    0,    0, 1028, 1027,    0,    0,    0,    0,    0, 1030,
    0,    0,    0, 1035,    0, 7543,    0,  626,    0,    0,
  561,  642,  984,    0,  145,    0, 1034, 1021,    0,    0,
 6741,    0,    0, 6741,    0,14864,    0,14864, 8447,    0,
    0,  626, 1036,   54,    0,    0,    0,    0,    0,    0,
    0,    0,14864, 8447,    0,    0,  -30,16370, 1069,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,14048,    0,    0,    0,    0,    0,
 7683,    0, 9215,    0, 7840, 1033,    0,    0,    0,    0,
 1115,    0, 1119,    0,    0,    0,  737,    0, 1040,    0,
    0,    0,    0,    0,    0,  997,    0,  106,    0,    0,
    0,    0,  554,  554,    0,  933, 1048, 1049, 1004, 1054,
  967,    0, 1051,    0, 1167, 1168,    0,    0,14864,    0,
14592, 1055,  781, 8761, 8447,    0,    0,  358, 1172, 1175,
  200, 1052,    0,    0,    0,14864,    0,14864, 1152,    0,
    0,    0,    0,  123,14728,    0,    0,    0,    0, 7976,
    0, 1179,    0,  806,14864, 1071, 8430, 1068,    0,    0,
  -30,    0,  197,    0,    0,  929,  984,    0,  -30,    0,
 -149,    0,    0,    0, 1067,    0, 1097,    0,    0,    0,
    0,    0,    0,    0,  749,    0,    0,    0,    0,    0,
    0, 8604,    0,    0,  -30,  203, 1033,    0, 9058,    0,
 9058,    0, 1091, 9058,    0,    0,    0,  474,    0,    0,
    0, 1086,  933,    0,    0,15136,    0,    0,    0, 1087,
 7700,    0,  967,    0,  967,    0,  967,    0,    0,    0,
    0,  -30, 1081, 1055,    0,    0,    0, -142, -137, 1085,
 1100,    0,    0,    0,    0,    0, 1099, 8430, 1033, -180,
14864,    0, 1089, 6741,    0,    0,    0,    0,    0,    0,
 1107,    0,  872,    0,    0,    0,    0,    0, -191,    0,
 1108,  929,  984,    0,  984,    0, 1033, 1109,    0,    0,
   54,    0, 1056, 1101,    0,    0,    0,    0,    0, 9058,
 1131, 9058, 9058,    0,14864,    0,    0, 1010,  365,  838,
    0,    0,    0,    0,  -26,    0,    0,    0, 1118,    0,
    0,    0, 1102,    0,    0,    0,  416,    0, 1112, 1233,
 1238,    0,    0, 1033, 1123, 1033, 1124,    0, 1121,    0,
    0,    0,    0,    0,14864,    0, 1135, -162,    0, -162,
    0, 1243,    0,    0,    0,    0,   54,    0,14864, 8135,
    0,    0, 1157,    0,  827, 1133,    0, 1138,    0,    0,
15136,  204,  215,    0, 1136, 1136, 1136,14592, 1142,    0,
14864,    0,    0,    0,    0,    0,    0, 6741,   58,    0,
    0, 6898,    0,    0, 1146, 6741,    0, 1145,    0, 9058,
    0,    0,    0,    0,    0,14864,    0,    0,  504, 1147,
  504, 8447, 1181, 1181, 1181,    0,    0,14864,    0, 6741,
 9372,    0,    0,    0, 6898,    0,    0,    0,    0, 1170,
 9058,14864,    0,  504, 1153,    0, 1104,  912,    0,    0,
 1149,    0,    0,  183,    0, 1113,    0, 1181,    0,    0,
    0,    0,    0,    0,    0, 1156, 1024,    0, 6898,    0,
 1177,    0, 1154, 1181, 1276,    0, 1165,  504,    0, 8447,
   59, 1169,    0, 1173, 1176, 6741, 1171, 9058,    0,    0,
    0,    0,    0, 1174, 1154,    0,    0,    0,15976,  151,
  504,    0,    0,    0, 1192, 9058, 1178,14864,    0,    0,
 1180,    0,    0, 1184,    0,    0,16962,    0, 1182,  151,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  674,16962,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1185,  504,    0,  151,  -30,    0, 1192,
    0,    0, 1187,15976,16142,    0,    0,  -11,    0,    0,
    0,    0,    0,16174,    0,    0, 1194,    0,    0,    0,
    0, 8447, 8447,  377, 8604,  395,  561, 1212,    0, -276,
13984,    0, 1247,    0,    0, 1154,    0,    0,    0, 6898,
 1154,    0, -136, -134,    0, 8447, -128,    0, 8447,    0,
 1148, 1189,    0, -276,    0, -184,13916,    0, 1196, 1150,
 -252,  502,  943,    0, 1195,    0, 1154,    0,    0,    0,
 -276,    0, 1200, 1151, 1199, 1197,    0, 1203, 1158, 1207,
  215, 1190, 1206,    0,    0, 1209, 1215,    0,  929,    0,
  868,    0,    0,    0, 1224,    0,    0, -119,    0, 1202,
    0,    0, 1229,    0, 1228, 1231, 1232,    0, 1226,    0,
  215,  215,    0,  215, 1235, 1241,    0,    0,    0,    0,
 1242,  176,    0, 1244,  215, 1350, 1245,  215,    0,  -11,
    0, 8430, 1204, 1239, 1226,    0, 1248, 1252,  230, 1255,
    0,    0,  215,14592, 1208, 1251, 1242,    0,    0,16962,
    0,  504,  504,    0, 1210, 1253, 1244,    0, 1260,    0,
14864, 1216, 1261, 1245,    0, 1267,  215,    0,   67,    0,
 1262,    0,    0,    0,    0,    0,16962,    0,  230,  230,
    0, 1269,    0, -119,    0,    0,   77, 1277,16962,    0,
16962,    0,    0, 8430, 1263,    0,    0,    0, 1282, 1229,
    0,    0,    0, 1274,    0,  429,    0,    0,    0, 1181,
  920, 1279,    0,    0, 1286,    0,    0,    0,    0,    0,
 1340, 1393,    0,    0,    0,    0,    0,    0, 1287, 1288,
 8430,    0,    0,    0,    0,  230,  557,  557,    0, 1181,
    0,    0,    0,   30,   30,    0,    0,    0,    0,    0,
    0,    0,14184,14184,    0,    0,    0,    0,    0, 1292,
 1289, 1291,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         2027,
    0,    0, 7055, 2027,    0,    0,    0, 1664,    0,    0,
 3226, 1300,    0,    0,    0,    0,    0, 3226,    0,    0,
   44,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1666,    0,    0, 1666,    0,    0, 1664,
 3297, 3140,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1304,    0,    0,    0,    0,    0,    0,    0,    0,
 9075,    0, 1297,    0,    0,    0, 1297,    0,    0,    0,
    0,    0,    0,  368,    0,    0,    0,    0,    0,    0,
    0,    0,  281,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4652,    0,    0,    0,    0,
    0,    0,  419, 4745, 4087,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 4901, 4969,
 5209, 5413, 5753, 5957, 1116, 6161, 6297, -156, 4832, 3819,
    0,    0,    0,    0,    0,    0,   44,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  289,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3340,    0,
  849,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1666,   79,    0,    0,    0,    0,    0,    0,
    0, 3383,  638, 3446,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3698,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1299,    0,    0,    0,    0,
    0,    0, 3698, 1298,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2646,    0, 3010,  663, 2776,    0,    0,    0, 2906,
 2776,    0,    0,    0,    0,    0, 1304,    0,    0,    0,
    0,  312,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1305, 1605,    0,    0, 1297,    0,
 3698,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -225,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1780,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3978,    0,    0,    0,    0,
    0,    0,    0, 3489, 3532,    0,    0,    0,    0, 2500,
 1666, 1666,    0, -237,    0, 7857, 1666, 1678,    0,    0,
  139,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  520,15829,
    0,    0,    0,    0, 3698,    0,    0,    0,    0,    0,
    0,    0,    0,16218,    0,    0,    0,    0,    0,    0,
    0,  779,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  610,  774,    0,    0, 1311,    0,    0,    0,    0,
    0,  318,    0,    0, 4175, 1308,    0,    0,    0,  521,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 2207,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1305,    0,    0, 6424,    0,  319,
    0,    0,    0,    0,    0,    0,15272,    0,    0,    0,
    0,    0,    0,  104,  580,    0,    0,    0, 1312,    0,
    0,    0,    0, 1298,    0,    0,    0, 3698,    0, 3698,
    0, 4334,    0,    0,    0,    0,    0, -163,    0,    0,
    0,    0,  115,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5073,    0,
 5141,    0, 5277,    0, 5345,    0, 5481,    0, 5549,    0,
 5617,    0, 5685,    0, 5821,    0, 5889,    0, 6025,    0,
 6093,    0, 6229,    0, 6365,    0,  320,    0,    0,  693,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3978,    0,    0,    0,    0, 2500,    0,    0,
    0,    0, 1268,13359,    0,    0,    0, 9232,    0,    0,
  857,    0,    0,    0,    0,    0,    0,  834,  600,    0,
    0, 1315,    0,    0,    0,    0, 1947,    0,    0,    0,
    0,    0,    0,15408,    0,    0,    0,  856,    0,    0,
    0, 9389,16294,    0,    0,  863,  874,  875,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  784,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1319,    0,    0,
    0, 2019,    0,    0,  330,    0,  125, 3857,    0,    0,
    0,    0,    0, 1317,    0,    0,    0,    0,    0, 1322,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  366,  854,    0,    0,    0,    0,    0, 1320,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,15272,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  629,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  209,    0,  496,    0,
    0,    0,    0,    0,    0,    0,    0, -237,    0,    0,
    0,    0, 9389, 8152,    0, 1321,    0,  794,    0,    0,
    0,    0, 1326,    0, 1278, 1281,    0,    0,    0,    0,
    0, 1318,16483,    0,    0,    0,    0,16326,    0,    0,
    0,  876,    0,    0,    0,    0,    0,    0, 2374,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 4016,    0, 4493, 1327,    0,    0,    0,
 1325,    0,    0,    0,    0,  225,    0,    0,    0,    0,
  876,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -243,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  880,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1324,    0,    0,    0,    0,    0,  883,
  886,    0,    0,    0,    0,    0,    0,    0,  985,  746,
 1328,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 4175,    0,    0,    0,    0,    0, 1334,    0,
    0,  225,    0,    0,  914,    0,  985,    0,    0,    0,
15272,    0,  804,  815,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1315,13198,    0,
    0,    0,    0,    0,16534,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  767,    0,  780,    0,
    0,    0,    0, 1331,    0,  824, 1332,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1342,    0, 7212,
    0, 1345,    0,    0,    0,    0,15272,    0,    0,    0,
    0,    0,    0,    0,  273,  522,    0,    0,    0,    0,
    0,16577,16218,    0,  362,  362,  362,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,16663,    0,
 -256,    0, 1351, 1351, 1351,    0,    0,    0,    0,    0,
 1347,    0,    0,    0, -197,    0,    0,    0,    0,    0,
    0,    0,    0,16706,    0,    0,    0,13662,    0,    0,
 1349,    0,    0,  513,    0,    0,    0,  569,    0,    0,
    0,    0,    0,    0,    0,    0, 1352,    0, 1354,    0,
    0,    0, 3183, 1344,  608,    0,    0,   23,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1514,    0,    0,    0,    0,13464,
13748,    0,    0,    0,  577,    0,    0,    0,    0,    0,
    0,    0,    0,  596,    0,    0,16000,    0,    0,13563,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,16068,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,13842,    0,13464,    0,    0,  577,
    0,    0,    0,    0,  520,    0,    0,    0,    0,    0,
    0,    0,    0,  520,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1404,  650,    0,13884,
    0,    0,    0,13954,    0, 1514,    0,    0,    0, 1354,
 1514,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  229,    0, 1356,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1514,    0,    0,    0,
  734,    0,  735,    0,    0,    0,    0,    0,    0,    0,
16218,  891,    0,    0,    0,    0,    0,    0, 1353,    0,
  269,    0,    0,    0,    0,    0,    0,    0,    0,  898,
    0,    0,    0,    0,    0,    0,    0,    0, 1355,    0,
16218,16218,    0,16250,    0,    0,    0,    0,    0,    0,
 1357,16892,    0, 1358,16218,15544, 1359,16218,    0,    0,
    0,    0,    0,    0, 1360,    0,    0,    0,16862,    0,
    0,    0,16218,    0,    0,    0, 1362,    0,    0,  305,
    0, 1736,16824,    0,    0,    0, 1363,    0,    0,    0,
    0,    0,    0, 1365,    0,    0,16218,    0,  684,    0,
  901,    0,    0,    0,    0,    0,  925,    0,16748,16786,
    0,    0,    0,    0,    0,    0,    0,    0, 1412,    0,
 1465,    0,    0,    0,  902,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  628,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,16862,15716,16620,    0,  628,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1308, 1308,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1680,    0,    0,    0,   -2,  -15, -179,  -46,  -43,
    0, 1720, 1741,  742,    0,   -1,    0,    0,    0,    0,
    0, -808, -739, -216, -450,    0,    0,    0,    0,    0,
 -221,    0,    0,    0,  771,    0,  861,    0,    0,    0,
    0,  624,  627,  -17, -224,    0,  -37,    0,  460,    0,
  489,-1148, -648, -500, -480, -466, -458, -407, -403,    0,
 -630,-1192,    0,   16,    0,  155,    0,-1136,    0,    0,
    0,  -41,  278,    0,    0,    0,  317,-1108,    0, -274,
 -292, 1058,    0,    0,    0, -933,  263,    0,    0, -514,
    0,    0,  332,    0,    0,  304,    0,    0,  342,    0,
 -567, -903,    0,    0,    0,    0,    0,  442,  -13,    0,
    0,  877,  882,  884, 1062, -549,    0,    0, -311,  885,
  445,    0,-1385,    0,    0,    0,    0,    0,    0,    0,
    0,  245,    0,    0,    0,    0,    0,    0,    0,    0,
  498,    0,    0,    0,    0, -338,  431,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -520,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  256,    0,
    0,  339,    0,    0,  349,  351,  271,    0,    0,    0,
    0,    0,    0,    0,    0,  579,    0,    0,    0,    0,
  -51,    0,  316, -102,    0,    0,  426,    0,  479,    0,
  950,    0, 1290, -289, -272,  -52, 1111,    0,  594,    0,
  -38,   11,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -253,    0, 1005,    0, -351,    0, -802,    0,    0,
    0,  908,    0, -309, -133, 1078,    0,  991,    0, 1234,
 1460, 1117,    0,    0,  803, 1778,    0,    0,    0,    0,
 1095,    0,    0,    0,    0,    0, -468, 1517,    0,    0,
    0,    0,    0, 1348,  893,  904,  603,  887, 1445, 1446,
 1447, 1449, 1444,    0, 1448,    0,    0,    0, 1032, 1303,
 -778,    0, -569,    0,    0,    0,    0,    0,    0,    0,
    0, -303,    0,    0,    0,    0, -462,    0,  647,    0,
  558,    0,-1133,    0,    0,    0,    0,    0,  707, -537,
  -16, -333,   -5,    0, 1714,    0,   84,    0,  114,  136,
  146,  147,  156,  160,  163,  165,  167,  168,    0, -718,
    0,  -25,    0,    0,  843,    0,  768,    0,    0,    0,
    0,  745, -146,  820, -896,    0,  864, -473,    0,    0,
    0,    0,    0,    0,  761,    0,    0,  760,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  690,    0,    0,    0,    0,    0,    0,
    0,    0,  -35,    0, 1343,    0,    0,    0,  935,    0,
    0,    0,    0,    0,    0, -171,    0,    0,    0,    0,
    0, 1450, 1205,    0,    0,    0, 1452,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  582,    0,    0,    0,
    0,    0,    0,    0,    0,  687,    0,    0,    0,    0,
    0,    0,    6, 1011,    0,    0,    0, 1018,
  };
  protected static readonly short [] yyTable = {           109,
  155,   18,  189,  111,  233,  773,  529,  234,  573,  444,
  532,  156,  483,  779,  505,  462,  443,  722,  192,  549,
  258,   43,  487,  417,  560,  525,  588,  115,  744,  613,
  293,  321,  819,  259,  919,  958,  920,  827, 1063, 1186,
  938,  312,  513, 1000,  252,  328,  333, 1220, 1221,  327,
  332,  458,  229,  587,  339,  304,   48,  555,  834,  311,
  375,  374,  383,  382, 1114,  313,  367,  316,   48,  115,
  837, 1394, 1400,  115,   20,  854, 1115,  343,  355,  815,
 1068,  424,  950,  705, 1315,  952,  249,   14,  447,  752,
  190,  249,  667,  575,  718, 1247,  847, 1252,  719,  619,
  160, 1324,  715, 1523, 1524, 1115, 1056,  864,  865,  706,
  315,  319, 1296, 1096,  361,  362,  917,  362, 1098, 1378,
  372, 1380, 1037,  315,  798,  402,  403, 1386,  798,  835,
  161,  837,  798, 1046,  419,  749, 1429,  362,    6,  109,
  155,  707,  233,  111,   42,  445,  457,  880,  671,  320,
  576,  156,  162,  848,  918,  487, 1296,  451,  452,  720,
 1556,   48,  163,  164,  425, 1401,  360,  115,  196,  426,
  837,  427,  165,  521,  428,  429,  166,  430,  431,  167,
   48,  168,  619,  169,  170,  461, 1395,  619,  445,  619,
  619,  619,  619,  619,  619,  619,  619,  619,  619,  619,
  855,  250,   94,  457,  794,  753,  250, 1068,  667,  488,
  667,  619,  767,  619,  361,  619, 1375,  619,  619,  619,
  493,  492,  447,  483,  837,  250,  588,  462,  453,  486,
 1116, 1028,  771,  619,   94,  491,  573,  362,  250, 1180,
  160,  921,  291,  459,  619,  708,  503,  258,  588,   15,
  251,  363,  191,  587,  432,  251,  619,  258,    1, 1116,
  501, 1430,  573,  447,  716,  667,  535, 1497,  597,  548,
  161,  504,  619,  552,  251, 1097,  508,  510,  557,  556,
 1099, 1379, 1128, 1381,  522, 1565,  523,  251,  250, 1387,
  554,  536,  162,  547, 1521,  559,  115,  292,  260,  544,
 1000,  546,  163,  164,  545,  508, 1531,  840, 1532,  820,
  496,  852,  165, 1193, 1258, 1111,  166,  562,  563,  167,
  579,  168, 1515,  169,  170,  572,  337,  754,  250,  115,
  850,    2,  291,  595,  355,  194,  574,  251, 1138, 1528,
  524,  289,  488,  488,  781, 1493,   94,  689, 1167,  290,
  250,  594,  115,  783, 1018,   94,  635,  637,  588,  369,
    2,  692,  486,  610, 1347,  933,  617,  618,  619,  620,
  621,  622,  623,  624,  625,  626,  627,  251,  933,  794,
 1000,  906,  723, 1542,  674,  676,  881,  292,  673,  675,
  321, 1529,  679,   16,  497,    6,   94,  233,  669,  251,
  445, 1357,  194,  194,  929, 1566, 1276,  693,   48, 1069,
  680, 1071,  291, 1562, 1074,  680,  800,  355,  261,  680,
   94,  841, 1047,  194, 1251,  726,    3,    4,    5,    6,
  853, 1459, 1194, 1259,  680,  803,  291,  911, 1239, 1192,
   48, 1516, 1032,  755,  687,  355, 1269, 1198,  851,  355,
  733,  355,  355,  355,  355, 1026,  690,  691,  709,  355,
  782,  680,  703,  742,  984,  750,  369,  292,  338,  784,
  730, 1223,  483,  369,  231,  369,  743,  369, 1054,  934,
  680,  740,  447,  935,  345, 1486,  458, 1417,  488,  588,
 1035,  292, 1000,  965,  231,  836,  935,  838, 1000,  839,
 1131,  487, 1133, 1134,  513,  793,  769,  291,  610,  802,
  777,  483,  115, 1103,  194,  194,  587, 1447, 1448,  231,
 1450,  369,  930,  422,  355,  785,  787, 1263,  987,  408,
  409, 1469,  801,  414, 1476,  805,  398, 1374,   20,  368,
  807,  792, 1376,  458,  231,  415,  786,  984,  826, 1492,
 1209,  804,  984,  572,  984,  731, 1240,  984,  984,  291,
  984,  984,  946,  821,  574,  588,  498,  680, 1407,  816,
 1065, 1027,  399, 1514,  499,  620,  423,  194, 1066,  572,
  115,  340,  984,  231, 1123,  873, 1124,  369,  842,  842,
  574, 1016,  824,  340,  786,  345,  340,  340,  231,  345,
 1200,  340,  117,  194,  117,  447,  115, 1209, 1011,  117,
  340,  987, 1297,  518, 1052,  194,  987,  519,  987,  680,
  767,  987,  987,  194,  987,  987,  967,  500,  424,  926,
  817, 1231, 1355,  931,  825,  355,  861,  984,  863,  355,
   54,  340,  355,  345,  355,  785,  987,  871,  370,  355,
 1358,  774,  400,  401,  858,  786, 1297,  819,  620,  858,
  858, 1042,  867,  620,  360,  620,  620,  620,  620,  620,
  620,  620,  620,  620,  620,  620,  681,  194, 1265,  727,
  194, 1356,  532,  360, 1538,  445,  728,  620,  488,  620,
  927,  620, 1539,  620,  620,  620, 1310,  446, 1020, 1359,
  699,  987,  925,  874,  199,  913,  774,  360,  486,  620,
  200,  425,  361,  194,  194,  875,  426,  744,  427,  258,
  620,  428,  429,  508,  430,  431,  231, 1107,  699,  424,
  781,  361,  620,  263,  893,  362,  781,  362,  777,  552,
  727,  194,  194,  769,  941, 1139,  445,  728,  620,  363,
  771,  978,  245, 1540,  362,  361,  246,  947,  446,  425,
 1298,  194,  197,  115,  426,  115,  427,  955,  363,  428,
  429, 1084,  430,  431,  942,  194,  367,  980,  362,  894,
 1299,  333,  960,  362, 1149,  781, 1382,  333,  953,  961,
  954,  678,  363,  197, 1300,  225, 1150,  226,  956, 1396,
  821,  442, 1301,  895, 1298,  959,  247,  488,  878, 1278,
 1295,  115,  425,  488,  115,  678, 1076,  426,  225,  427,
  228, 1415,  428,  429, 1299,  430,  431,  610,  573, 1278,
  896,  693,  974,  610,  978,  970,  333,  777, 1300,  978,
 1159,  978,  678,  689,  978,  978, 1301,  978,  978,  682,
  879,  700,  756, 1302, 1295, 1011, 1278, 1303,  795,  581,
  980,  573,  361, 1019,  733,  980,  582,  980,   94,  539,
  980,  980,  231,  980,  980,  361, 1189, 1402,  583,  700,
  194, 1008, 1104,  504,  709,  362,  788,  367,  367,  367,
  448,  367,  367,  449,  367,  573,  367, 1302,  362,  363,
 1033, 1303,  194, 1050,  722, 1053, 1000, 1036,  244,  680,
 1104, 1055,  363, 1222,  680,  974, 1084, 1044,  680,  777,
  974,  679,  974,   94,  978,  974,  974, 1480,  974,  974,
  248,  446, 1250,  680,  706,  703,  340, 1064,  367,  372,
  367,  361,  340,  367,  703,  679,  320,  598,  340,  873,
  980,  643,  340,  643,  538,  373,  785,  599,  488, 1088,
  680,  858,  706,  858,  362,  340,  858,  539,  320,   65,
   65,  706,  679,   65, 1093,  324, 1344,  505, 1083,  680,
  340,  324,  340,  505,  540, 1344,  483,  462,  325, 1533,
  600,  709,   94, 1312,  702,  372,  797,  340,  372, 1204,
  601,  340,  340,  702,  797,  974,  647,  649,  651,  653,
  777,  448,  194,  508,  943,  250,  573,  376, 1090,  340,
 1091,  340, 1092,  897,  320,  340, 1553,  320,  334,  340,
  898,  340,  340,  194,  340,  340,  377,  378,  482,  231,
 1319, 1320, 1571, 1572,  115,  532,  412,  821,  340, 1321,
  272,  272,  858,  371,  858,  858,  379, 1135,  410,  272,
  793,  404,  405,  413,  251,  262,  793,  380,  793,  286,
  287,  288,  416,  294,  295,  406,  407,  725,  308,  309,
  340,  726, 1142,  785,  411,  317,  581,  319,  903,  323,
  985,  986,  759,  582,  335,  336,  760,  504,  768,  733,
  345,  194,  519,  488,  345,  583,  340,  345,  282,  345,
  282, 1168,  777,  821,  345,  282,   44,  793,  381,  793,
 1062,  793,  851, 1083,  194,  914, 1179,  113,  448,  915,
  504,  872,  233,  504, 1207,  445,  170, 1208,  170,  194,
  170,  506,  450,  194,  418,  572,  418,  506,  345,  183,
  862,  183,  858,  183,  862,  866,  574,  233, 1203,  866,
  445, 1011,  296,   66,  297,  418,  418,   66,  115,  113,
  504,  814,  115,  113,  297,  814,  115,  814,  572,  814,
 1172, 1173,  803,  858, 1135,  418,  803,  225,  803,  574,
  803, 1207,  454,  418, 1208,  797,  418,  331,  331,  797,
  115,  194,  457,  340,  340,  115,  340,  340,   57, 1140,
  484, 1141,  572, 1277, 1294,  485, 1208, 1273,  331,  194,
  194,  340,  333,  574,  340,  333, 1020,  201, 1020,  805,
  858,  805,  158, 1277,  158,  337, 1208,  447,  528,  115,
  395,  396,  397,  165,  166,  165,  166,  931,  858,  931,
  504,   68,  189,   68,  189,  159,  115,  159, 1294,  317,
 1277, 1393,  381, 1208,  122,  506,  122,  113,  533,  202,
 1328,  288, 1273,  288,  129,  295,  129,  295, 1393, 1236,
  231,  362,  454, 1543, 1544,  529,  529,  194,  680,  680,
 1353, 1354,  639,  641,  655,  657, 1425,  507, 1426,   35,
 1184, 1185,  526,  373, 1349,  643,  645,  534,  194,  331,
  331,  537,  553,  558, 1385,  566,  194, 1388,  543,  203,
  204,  205,  206,  592,  207,  208,  209,  210,  211,  212,
  213,  214,  593,  572,  215,  216,  217,  218,  219,  220,
  221,  222,  362,  602,  574,  685,  704,  733,  724,  758,
  366,  688,  727,  729,  751,  757,  799,  806, 1403,  808,
  115,  832,  809,  810,  811,  846,  829,  828,  860,  845,
  862,  610,  331,  833,  882,  883,  866,  733,  733,  448,
  733,  889,  885,  886,   42, 1460,  901,  907,  908,  196,
  909,  733,  932,  949,  733,  910,  113,  916,  331,  936,
  851,  939, 1487,  937,  944,  948,  975,  957,  980,  733,
  331,  963,  982,  987,  989, 1499, 1501,  995,  331,  996,
  999,  998, 1004, 1006,  777, 1001, 1349, 1024, 1012,  113,
 1025, 1034, 1028,  733, 1041, 1048,  504,  522, 1059, 1060,
  341, 1073, 1487, 1487,  345,  347,  349,  351,  353,  355,
  357,  359,  113, 1509,  610, 1077, 1094, 1086, 1100,  610,
 1110,  610,  610,  610,  610,  610,  610,  610,  610,  610,
  610,  610,  331, 1101, 1102,  331, 1112, 1132, 1129, 1122,
 1126, 1130, 1148,  610, 1144,  610,  777,  610, 1152,  610,
  610,  610, 1151, 1153, 1154, 1156, 1157,  194, 1164, 1487,
  610,  741, 1160, 1171,  610,  610, 1174, 1175,  331,  331,
 1182, 1187, 1196,   28, 1199,  610,  610, 1230, 1206, 1216,
 1233, 1235, 1238,  777, 1249,  488,  488, 1246,  610, 1250,
 1241, 1253, 1255, 1558, 1558, 1260,  331,  331, 1264, 1261,
 1567, 1567, 1262,  786,  610,  610,  610, 1308, 1360, 1316,
 1313, 1373, 1325, 1311, 1268,  194,   35, 1314, 1330, 1391,
   35, 1352, 1406,  384, 1398, 1390, 1409, 1399, 1401, 1411,
 1418,   35, 1412, 1414,  194, 1381,   35, 1416, 1420, 1422,
   35, 1423, 1433,   35,  385,  386,  387,  388,  389,  390,
  391,  392,  393,  394, 1428,   35,   35, 1436, 1439, 1443,
   35,   35, 1440, 1441,  340, 1470,   35, 1451,   35,   35,
   35,   35,  113, 1452, 1482, 1455,   35, 1465, 1472, 1484,
   35, 1481,   35, 1485, 1491, 1494, 1495, 1505, 1506,  194,
  194, 1508,   35, 1510,   35,   35, 1511,   35, 1513,  194,
 1526,   35, 1519, 1534, 1530, 1537, 1545,  194,  194,  341,
  194, 1535, 1546,  331, 1529, 1528, 1370, 1551, 1552, 1573,
 1574,   35, 1575,    9,  362, 1016,  500,   35,   35, 1370,
  545,  194,  900,  901,  194,  331,  644, 1008,  501,  457,
  113,  561, 1370,  645,   30,  714,  499,  362,  458,   30,
   31,  525,  316,  807,   31,  210,  908,  331,   97,  808,
  362,  831,  800,  867, 1370,  362,  113,  868,  234,  832,
  362,  911,  362,  362,  362,  362,  320,  702,  869,  702,
  362,  727,  347,  871,  362,  340,  680,  680,  362,  230,
  125,   53,  107,  291,  132,  126,  362,  108,  292,  362,
  133,  362,  629,  631,  633,   21,  994,  561,  561,  561,
  561,  561,  561,  561,  561,  561,  561,  561,  561,  561,
  561,  561,  561, 1078, 1177,  362, 1327, 1178, 1317,   28,
   28, 1527, 1536, 1496,   28,  891, 1483, 1512,   28,  510,
   28, 1478, 1367,   28, 1021,   28,   28, 1017,   28, 1022,
   28, 1023,   28,  904,   28,   28,   28,   28, 1383, 1569,
   28,   28, 1326, 1405, 1561, 1507,   28,  331,   28,   28,
   28, 1502, 1500,   28,   28,   28, 1256,   28, 1560, 1371,
   28,  362,   28,   28,   28,   28, 1427,  990,  331,   28,
   28,   28,  796, 1257,   28,   28,   28, 1040,  924,  604,
  844,  968,  900,   28,   28, 1113,   28,   28,  299,   28,
   28,   28,  922,  564,  659,   28,  661,  667,  663,  962,
  340,  665,  668,  113, 1243,  113,  340,  813, 1195,  561,
  418, 1331, 1106, 1155, 1169,   28, 1125, 1095, 1161, 1163,
 1227,   28,   28,  789,  683, 1057,  684,  870, 1232,    0,
   28, 1329,    0,    0,  992,    0,  331,    0,    0,    0,
  991,    0,  340,    0,    0,    0,    0,    0,    0,    0,
    0,  113,    0,    0,  113,    0,    0,    0,    0,  331,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   28,    0,    0,  331,    0,    0,    0,  331,  831,
    0,    0,    0,  340,    0,    0,   24,    0,  340,    0,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,    0,    0,    0,    0,    0,  340,    0,    0,
    0,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,    0,  340,  340,    0,    0,  340,  340,  340,  340,
  340,    0,    0,  340,  340,    0,   48,    0,  340,  340,
  340,  340,  340,  340,  340,  340,    0,    0,    0,    0,
    0,    0,    0,    0,  331,  331,    0,  340,    0,   48,
  340,    0,  340,    0,  340,    0,   34,  340,    0,    0,
    0,    0,   48,  340,    0,  510,    0,   48,    0,    0,
  510,  510,   48,    0,   48,   48,   48,   48,    0,    0,
   48,    0,   48,    0,    0,    0,   48,    0,    0,    0,
    0,    0,    0,  510,    0,    0,    0,    0,   48,    0,
    0,   48,    0,   48,    0,    0,  510,  510,    0,    0,
    0,  510,  331,    0,  510,    0,  510,    0,  510,  510,
  510,  510,    0,    0,    0,    0,  510,   48,    0,    0,
  510,    0,    0,  302,  510,    0,    0,    0,    0,    0,
    0,  331,  510,    0,    0,  510,    0,  510,  510,    0,
    0,    0,    0,  510,    0,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,    0,    0,    0,    0,
    0,  510,  510,    0,  113,    0,  510,  510,    0,  510,
  510,  510,  510,  510,  510,  510,    0,  510,  510,    0,
  510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
    0,  510,  510,  510,  510,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
  510,  510,  510,    0,    0,  510,    0,  510,    0,  510,
    0,    0,  510,   24,    0,    0,  902,   24,  510,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   24,    0,
    0,    0,    0,   24,    0,    0,    0,   24,    0,    0,
   24,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   24,   24,    0,    0,    0,   24,   24,    0,
    0,    0,    0,   24,    0,   24,   24,   24,   24,    0,
    0,    0,    0,   24,    0,    0,    0,   24,  113,   24,
    0,    0,  113,    0,  340,    0,  113,  561,    0,   24,
  340,    0,   24,   34,   24,    0,    0,   34,   24,    0,
    0,    0,  331,    0,    0,    0,    0,    0,   34,    0,
  113,    0,    0,   34,    0,  113,    0,   34,   24,    0,
   34,    0,    0,   21,   24,   24,  340,    0,    0,    0,
    0,    0,   34,   34,    0,    0,    0,   34,   34,    0,
    0,    0,    0,   34,    0,   34,   34,   34,   34,  113,
    0,    0,    0,   34,    0,    0,    0,   34,    0,   34,
  331,    0,    0,    0,    0,    0,  113,    0,    0,   34,
    0,   34,   34,    0,   34,    0,    0,    0,   34,  331,
    0,    0,    0,  825,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  340,    0,   34,  340,
    0,  340,  340,    0,    0,   34,  340,  340,    0,    0,
  340,  340,  340,  340,  340,  340,  340,  340,  340,    0,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
    0,    0,    0,    0,  331,  331,    0,    0,    0,    0,
  340,  340,    0,    0,  331,    0,    0,    0,  340,    0,
    0,  340,  331,  331,    0,  331,    0,  340,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  113,    0,  902,  902,    0,    0,  331,    0,    0,  331,
  902,  902,  902,  902,  902,    0,  902,  902,    0,  902,
  902,  902,  902,  902,  902,  902,  902,    0,    0,    0,
    0,  902,    0,  902,  902,  902,  902,  902,  902,  340,
    0,  902,    0,    0,    0,  902,  902,    0,  902,  902,
  902,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  902,    0,  902,    0,  902,  902,    0,    0,  902,    0,
  902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
  902,  902,    0,  902,    0,    0,  902,  902,    0,    0,
  902,  902,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  902,  902,  902,  902,  902,
    0,    0,    0,  902,  902,    0,    0,  902,    0,    0,
    0,    0,  902,  902,  902,  902,  902,    0,    0,    0,
  902,    0,  902,    0,    0,    0,    0,    0,  902,  902,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  902,  902,  902,  902,    0,  902,  825,
  825,    0,    0,    0,    0,  902,    0,  825,  825,  825,
  825,  825,    0,  825,  825,  782,  825,  825,  825,  825,
  825,  825,  825,    0,    0,    0,    0,    0,  825,    0,
  825,  825,  825,  825,  825,  825,    0,    0,  825,    0,
    0,    0,  825,  825,    0,  825,  825,  825,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  825,    0,  825,
    0,  825,  825,    0,    0,  825,    0,  825,  825,  825,
  825,  825,  825,  825,  825,  825,  825,  825,  825,    0,
  825,    0,    0,  825,  825,    0,    0,  825,  825,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  825,  825,  825,  825,  825,    0,    0,    0,
  825,  825,    0,    0,  825,    0,    0,    0,    0,  825,
  825,  825,  825,  825,    0,  340,    0,  825,    0,  825,
  340,  340,    0,    0,    0,  825,  825,    0,    0,    0,
    0,    0,    0,    0,    0,  333,    0,    0,    0,    0,
    0,    0,    0,  340,    0,    0,    0,    0,    0,    0,
  825,  825,  825,  825,    0,  825,  340,  340,    0,    0,
    0,  340,  825,    0,  340,    0,  340,    0,  340,  340,
  340,  340,    0,    0,    0,    0,  340,    0,    0,    0,
  340,    0,    0,    0,  340,    0,    0,    0,    0,    0,
    0,    0,  340,    0,    0,  340,    0,  340,  340,    0,
    0,    0,    0,  340,    0,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,    0,    0,    0,
    0,  340,  340,    0,    0,    0,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,    0,  340,  340,    0,
    0,  340,  340,  340,  340,  340,    0,    0,  340,  340,
    0,    0,    0,  340,  340,  340,  340,  340,  340,  340,
  340,  782,    0,    0,    0,  370,  782,  782,    0,    0,
    0,    0,  340,    0,    0,  340,    0,  340,    0,  340,
    0,    0,  340,    0,    0,    0,    0,    0,  340,  782,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  782,  782,    0,    0,    0,  782,    0,    0,
  782,    0,  782,    0,  782,  782,  782,  782,    0,    0,
    0,    0,  782,    0,    0,    0,  782,    0,    0,    0,
  782,    0,    0,    0,    0,    0,    0,    0,  782,    0,
    0,  782,    0,  782,  782,    0,    0,    0,    0,  782,
    0,  782,  782,  782,  782,  782,  782,  782,  782,  782,
  782,  782,    0,    0,    0,    0,    0,  782,  782,  365,
    0,    0,  782,  782,  782,  782,  782,  782,    0,  782,
  782,  782,    0,  782,  782,    0,    0,  782,  782,  782,
  782,  333,    0,    0,  782,  782,  333,  333,    0,  782,
  782,  782,  782,  782,  782,  782,  782,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  782,  333,
    0,  782,    0,  782,    0,  782,    0,    0,  782,    0,
    0,    0,  333,  333,  782,    0,    0,  333,    0,    0,
  333,    0,  333,    0,  333,  333,  333,  333,    0,    0,
    0,    0,  333,    0,    0,    0,  333,    0,    0,    0,
  333,    0,    0,    0,    0,    0,    0,    0,  333,    0,
    0,  333,    0,  333,  333,    0,    0,    0,    0,  333,
    0,  333,  333,  333,  333,  333,  333,  333,  333,  333,
  333,  333,    0,    0,    0,    0,    0,  333,  333,   33,
    0,    0,  333,  333,  333,  333,  333,  333,    0,  333,
  333,  333,    0,  333,  333,    0,    0,  333,  333,  333,
  333,  370,    0,    0,  333,  333,  370,  370,    0,  333,
  333,  333,  333,  333,  333,  333,  333,    0,    0,    0,
    0,    0,   28,    0,    0,    0,    0,    0,  333,  370,
    0,  333,    0,  333,    0,  333,    0,    0,  333,    0,
    0,    0,  370,  370,  333,    0,    0,  370,    0,    0,
  370,    0,  370,    0,  370,  370,  370,  370,    0,    0,
    0,    0,  370,    0,    0,   32,  370,    0,    0,    0,
  370,    0,    0,    0,    0,    0,    0,    0,  370,    0,
    0,  370,    0,  370,  370,    0,    0,    0,    0,  370,
    0,  370,  370,  370,  370,  370,  370,  370,  370,  370,
  370,  370,    0,    0,    0,  365,    0,  370,  370,    0,
    0,  365,  370,  370,    0,  370,  370,  370,    0,  370,
  370,  370,    0,  370,  370,    0,    0,  370,  370,  370,
  370,    0,    0,    0,  370,  370,    5,    0,    0,  370,
  370,  370,  370,  370,  370,  370,  370,  365,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  370,    0,
    0,  370,    0,  370,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  370,    0,    0,    0,    0,  998,
    0,    0,    0,    0,    0,    0,    0,    0,  365,    0,
    0,    0,    0,  365,    0,  365,  365,  365,  365,  365,
  365,  365,  365,  365,  365,  365,    0,    0,    0,    0,
    0,    0,  365,    0,    0,    0,  365,  365,    0,  365,
  365,  365,   48,  365,  365,  365,    0,  365,  365,    0,
    0,  365,  365,  365,  365,    0,   33,    0,  365,  365,
   33,    0,    0,  365,  365,  365,  365,  365,  365,  365,
  365,   33,    0,    0,    0,    0,   33,    0,    0,    0,
   33,    0,  365,   33,    0,  365,    0,  365,    0,    0,
    0,    0,    0,    0,    0,   33,   33,    0,  365,   28,
   33,   33,    0,   28,    0,    7,   33,    0,   33,   33,
   33,   33,    0,    0,   28,    0,   33,    0,    0,   28,
   33,    0,   33,   28,    0,    0,   28,    0,    0,    0,
    0,    0,   33,    0,    0,   33,    0,   33,   28,   28,
    0,   33,   32,   28,   28,    0,   32,    0,  999,   28,
    0,   28,   28,   28,   28,    0,    0,   32,    0,   28,
    0,   33,   32,   28,    0,   28,   32,   33,   33,   32,
    0,    0,    0,    0,    0,   28,    0,    0,   28,    0,
   28,   32,   32,    0,   28,    0,   32,   32,    0,    0,
    0,   49,   32,    0,   32,   32,   32,   32,    0,    0,
    0,    0,   32,    0,   28,    0,   32,    0,   32,    0,
   28,   28,    0,    5,    0,    0,    0,   48,   32,    0,
    0,   32,    0,   32,    0,    0,    0,   32,   48,    0,
    0,    0,    0,   48,    0,    0,    0,   48,    0,    0,
   48,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   48,   48,   32,    0,  998,   48,   48,    0,
   48,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,   48,    0,   48,    0,    0,   48,   48,    0,   48,
   48,    0,    0,   48,    0,    0,    0,    0,    0,   48,
    0,    0,   48,    0,   48,   48,   48,    0,   48,   48,
   48,   48,    0,   48,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,    0,   48,    0,   48,   48,
   48,    0,   48,   48,    0,    0,   48,    0,    0,    0,
    0,    0,   48,    0,    0,   48,    0,   48,   48,   48,
    0,   48,    0,   48,   48,    0,    0,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,    0,    0,   48,
    0,   48,    7,   48,    0,   48,   49,    0,    0,    0,
    0,    0,    0,    0,    0,   48,    0,   49,   48,    0,
   48,    0,   49,    0,   48,    0,   49,    0,    0,   49,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   49,   49,    0,   48,  999,   49,   49,    0,   48,
    0,    0,   49,    0,   49,   49,   49,   49,    0,    0,
   48,    0,   49,    0,    0,   48,   49,    0,   49,   48,
    0,    0,   48,    0,    0,    0,    0,    0,   49,    0,
    0,   49,    0,   49,   48,   48,    0,   49,   49,   48,
   48,    0,   49,    0,    0,   48,    0,   48,   48,   48,
   48,    0,    0,   49,    0,   48,    0,   49,   49,   48,
    0,   48,   49,    0,    0,   49,    0,    0,    0,    0,
    0,   48,    0,    0,   48,    0,   48,   49,   49,    0,
   48,    0,   49,   49,    0,    0,    0,    0,   49,    0,
   49,   49,   49,   49,    0,    0,    0,    0,   49,    0,
   48,    0,   49,    0,   49,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   49,    0,   55,   49,    0,   49,
    0,    0,    0,   49,   56,   24,   57,   25,    0,    0,
   26,   58,    0,   59,   60,   27,   61,   62,   63,   28,
    0,    0,    0,   49,    0,   64,    0,   65,   30,   66,
   67,   68,   69,    0,    0,   32,    0,    0,    0,   70,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   73,    0,   36,    0,   37,   74,
    0,    0,   38,    0,   75,   76,   77,   78,   79,   80,
   39,   40,   81,   82,   41,   83,    0,   84,    0,    0,
   85,   86,    0,  340,   87,   88,    0,    0,    0,  340,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,   94,    0,    0,
    0,   95,    0,    0,    0,    0,   96,   97,   98,   99,
  100,    0,    0,    0,  101,  340,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  106,  107,
  108,    0,    0,    0,    0,    0,  340,    0,    0,  196,
    0,  340,    0,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,    0,    0,    0,    0,    0,
  340,    0,    0,    0,    0,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  624,  340,  340,    0,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,    0,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,    0,  512,    0,    0,  340,    0,  340,  512,    0,
  340,    0,    0,    0,    0,    0,  340,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  512,    0,    0,  624,    0,    0,
    0,    0,  624,    0,  624,  624,  624,  624,  624,  624,
  624,  624,  624,  624,  624,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  624,    0,  624,    0,
  624,    0,  624,  624,  624,  512,    0,    0,    0,    0,
  512,    0,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  990,  512,  512,    0,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  624,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
    0,  508,    0,    0,    0,    0,  512,  508,    0,    0,
    0,    0,    0,    0,    0,  512,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  508,    0,    0,  990,    0,    0,    0,
    0,  990,    0,  990,  990,  990,  990,  990,  990,  990,
  990,  990,  990,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  396,    0,    0,  990,    0,  990,  396,  990,
    0,  990,  990,  990,  508,    0,    0,    0,    0,  508,
    0,  508,  508,  508,  508,  508,  508,  508,  508,  508,
  508,  508,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  508,  508,  396,  508,  508,  508,  508,  508,
  508,  508,    0,  508,  508,    0,  508,  508,  508,  508,
  508,  508,  508,  508,  508,  508,  990,  508,  508,  508,
  508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
  508,  508,  508,  508,  508,  508,  508,  508,  508,    0,
  516,    0,    0,    0,    0,  508,  516,    0,  508,    0,
    0,    0,    0,    0,  508,    0,    0,    0,    0,  333,
    0,    0,    0,    0,  396,  333,    0,  396,  396,  396,
  396,    0,  396,    0,  396,  396,    0,  396,  396,  396,
  396,  396,  516,  396,  396,  396,  396,    0,  396,  396,
  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
  396,  396,  396,  396,  396,  396,  396,  396,  396,  396,
    0,    0,    0,    0,  333,    0,  396,    0,    0,  396,
    0,    0,    0,  516,    0,  396,    0,    0,  516,    0,
  516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
  516,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  516,    0,  516,  516,  516,  516,  516,  516,
  516,    0,  516,  516,    0,  516,  516,  516,  516,  516,
  516,  516,  516,  516,  516,    0,  516,  516,  516,  516,
  516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
  516,  516,  516,  516,  516,  516,  516,  516,    0,  340,
  790,    0,    0,    0,  516,  340,    0,  516,    0,   24,
    0,   25,    0,  516,   26,    0,    0,    0,    0,   27,
    0,    0,    0,   28,    0,    0,    0,    0,    0,    0,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,  340,    0,    0,   33,    0,    0,    0,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,    0,    0,    0,   38,    0,    0,    0,
    0,    0,    0,    0,   39,   40,    0,    0,   41,    0,
    0,  791,  340,    0,    0,    0,    0,  340,    0,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
    0,    0,    0,    0,    0,    0,    0,  291,    0,    0,
    0,  340,    0,  340,  340,  340,  340,  340,  340,  340,
    0,  340,  340,    0,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,    0,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,    0,  441,  578,
    0,    0,  325,  340,  441,    0,  340,    0,   24,    0,
   25,    0,  340,   26,    0,    0,    0,    0,   27,    0,
    0,    0,   28,    0,    0,    0,    0,    0,    0,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
  441,    0,    0,   33,    0,    0,    0,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,    0,    0,    0,   38,    0,    0,    0,    0,
    0,    0,    0,   39,   40,    0,    0,   41,    0,    0,
  324,  441,    0,    0,    0,    0,  441,    0,  441,  441,
  441,  441,  441,  441,  441,  441,  441,  441,  441,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  441,    0,  441,  441,  441,  441,  441,  441,  441,    0,
  441,  441,    0,  441,  441,  441,  441,  441,  441,  441,
  441,  441,  441,    0,  441,  441,  441,  441,  441,  441,
  441,  441,  441,  441,  441,  441,  441,  441,  441,  441,
  441,  441,  441,  441,  441,  441,    0,  340,    0,    0,
    0,  366,  441,  340,  634,  441,    0,  785,    0,    0,
    0,  441,    0,   24,    0,   25,    0,    0,   26,    0,
    0,    0,    0,   27,    0,    0,    0,   28,    0,    0,
    0,    0,    0,    0,    0,    0,   30,    0,    0,  340,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
    0,    0,   34,    0,    0,  785,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,    0,    0,    0,
   38,    0,    0,    0,    0,    0,    0,    0,   39,   40,
    0,    0,   41,    0,    0,  324,    0,    0,    0,    0,
  550,    0,    0,    0,    0,    0,  550,    0,  340,    0,
    0,    0,    0,    0,  340,    0,    0,    0,    0,  340,
  340,  340,  340,  340,  340,  340,  785,  340,    0,  340,
  340,    0,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  550,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,    0,    0,    0,    0,  340,
    0,  340,    0,    0,  340,    0,  366,    0,    0,    0,
  340,    0,    0,  550,    0,    0,    0,  622,  550,    0,
  550,  550,  550,  550,  550,  550,  550,  550,  550,  550,
  550,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  550,    0,  550,    0,  550,    0,  550,  550,
  550,    0,  550,  550,    0,  550,  550,  550,  550,  550,
  550,  550,  550,  550,  550,    0,    0,    0,  550,  550,
  550,  550,  550,  550,  550,  550,  550,  550,  550,  550,
  550,  550,  550,  550,  550,  550,  572,  550,    0,    0,
    0,    0,  572,    0,    0,    0,    0,    0,    0,    0,
  622,    0,    0,  550,    0,  622,    0,  622,  622,  622,
  622,  622,  622,  622,  622,  622,  622,  622,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  572,  622,
    0,  622,    0,  622,    0,  622,  622,  622,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  622,    0,    0,  579,    0,    0,    0,    0,    0,
  579,    0,    0,    0,    0,    0,    0,    0,    0,  572,
    0,    0,    0,    0,  572,    0,  572,  572,  572,  572,
  572,  572,  572,  572,  572,  572,  572,    0,    0,    0,
  622,    0,    0,    0,    0,    0,  579,    0,  572,    0,
  572,    0,  572,    0,  572,  572,  572,    0,  572,  572,
    0,    0,  572,  572,  572,  572,  572,  572,  572,  572,
  572,    0,    0,    0,  572,  572,  572,  572,  572,  572,
  572,  572,    0,    0,    0,    0,    0,  579,    0,    0,
    0,    0,  579,  572,  579,  579,  579,  579,  579,  579,
  579,  579,  579,  579,  579,    0,    0,    0,  580,  572,
    0,    0,    0,    0,  580,    0,  579,    0,  579,    0,
  579,    0,  579,  579,  579,    0,  579,  579,    0,    0,
  579,  579,  579,  579,    0,    0,    0,  579,  579,    0,
    0,    0,  579,  579,  579,  579,  579,  579,  579,  579,
  580,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  579,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  581,  579,    0,    0,
    0,    0,  581,    0,    0,    0,    0,    0,    0,    0,
    0,  580,    0,    0,    0,    0,  580,    0,  580,  580,
  580,  580,  580,  580,  580,  580,  580,  580,  580,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  581,    0,
  580,    0,  580,    0,  580,    0,  580,  580,  580,    0,
  580,  580,    0,    0,  580,  580,  580,  580,    0,    0,
    0,  580,  580,    0,  588,    0,  580,  580,  580,  580,
  580,  580,  580,  580,    0,    0,    0,    0,    0,  581,
    0,    0,    0,    0,  581,  580,  581,  581,  581,  581,
  581,  581,  581,  581,  581,  581,  581,    0,    0,    0,
    0,  580,    0,    0,    0,    0,    0,    0,  581,    0,
  581,    0,  581,    0,  581,  581,  581,    0,  581,  581,
    0,    0,  581,  581,  581,  581,    0,    0,    0,  581,
  581,    0,  589,    0,  581,  581,  581,  581,  581,  581,
  581,  581,    0,    0,    0,    0,    0,  588,    0,    0,
    0,    0,  588,  581,  588,  588,  588,  588,  588,  588,
  588,  588,  588,  588,  588,    0,    0,    0,    0,  581,
    0,    0,    0,    0,    0,    0,  588,    0,  588,    0,
  588,    0,  588,  588,  588,    0,    0,    0,    0,    0,
  588,  588,  588,  588,    0,    0,    0,  588,  588,    0,
  590,    0,  588,  588,  588,  588,  588,  588,  588,  588,
    0,    0,    0,    0,    0,  589,    0,    0,    0,    0,
  589,  588,  589,  589,  589,  589,  589,  589,  589,  589,
  589,  589,  589,    0,    0,    0,    0,  588,    0,    0,
    0,    0,    0,    0,  589,    0,  589,    0,  589,    0,
  589,  589,  589,    0,    0,    0,    0,    0,  589,  589,
  589,  589,    0,    0,    0,  589,  589,    0,  593,    0,
  589,  589,  589,  589,  589,  589,  589,  589,    0,    0,
    0,    0,    0,  590,    0,    0,    0,    0,  590,  589,
  590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
  590,    0,    0,    0,    0,  589,    0,    0,    0,    0,
    0,    0,  590,    0,  590,    0,  590,    0,  590,  590,
  590,    0,    0,    0,    0,    0,  590,  590,  590,  590,
    0,    0,    0,  590,  590,    0,  594,    0,  590,  590,
  590,  590,  590,  590,  590,  590,    0,    0,    0,    0,
    0,  593,    0,    0,    0,    0,  593,  590,  593,  593,
  593,  593,  593,  593,  593,  593,  593,  593,  593,    0,
    0,    0,    0,  590,    0,    0,    0,    0,    0,    0,
  593,    0,  593,    0,  593,    0,  593,  593,  593,    0,
    0,    0,    0,    0,  593,  593,  593,  593,    0,    0,
    0,  593,  593,    0,  595,    0,    0,    0,  593,  593,
  593,  593,  593,  593,    0,    0,    0,    0,    0,  594,
    0,    0,    0,    0,  594,  593,  594,  594,  594,  594,
  594,  594,  594,  594,  594,  594,  594,    0,    0,    0,
    0,  593,    0,    0,    0,    0,    0,    0,  594,    0,
  594,    0,  594,    0,  594,  594,  594,    0,    0,    0,
    0,    0,  594,  594,  594,  594,    0,    0,    0,  594,
  594,    0,  596,    0,    0,    0,  594,  594,  594,  594,
  594,  594,    0,    0,    0,    0,    0,  595,    0,    0,
    0,    0,  595,  594,  595,  595,  595,  595,  595,  595,
  595,  595,  595,  595,  595,    0,    0,    0,    0,  594,
    0,    0,    0,    0,    0,    0,  595,    0,  595,    0,
  595,    0,  595,  595,  595,    0,    0,    0,    0,    0,
  595,  595,  595,  595,    0,    0,    0,  595,  595,    0,
  597,    0,    0,    0,  595,  595,  595,  595,  595,  595,
    0,    0,    0,    0,    0,  596,    0,    0,    0,    0,
  596,  595,  596,  596,  596,  596,  596,  596,  596,  596,
  596,  596,  596,    0,    0,    0,    0,  595,    0,    0,
    0,    0,    0,    0,  596,    0,  596,    0,  596,    0,
  596,  596,  596,    0,    0,    0,    0,    0,  596,  596,
  596,  596,    0,    0,    0,  596,  596,    0,  602,    0,
    0,    0,  596,  596,  596,  596,  596,  596,    0,    0,
    0,    0,    0,  597,    0,    0,    0,    0,  597,  596,
  597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
  597,    0,    0,    0,    0,  596,    0,    0,    0,    0,
    0,    0,  597,    0,  597,    0,  597,    0,  597,  597,
  597,    0,    0,    0,    0,    0,  597,  597,  597,  597,
    0,    0,    0,  597,  597,    0,  603,    0,    0,    0,
  597,  597,  597,  597,  597,  597,    0,    0,    0,    0,
    0,  602,    0,    0,    0,    0,  602,  597,  602,  602,
  602,  602,  602,  602,  602,  602,  602,  602,  602,    0,
    0,    0,    0,  597,    0,    0,    0,    0,    0,    0,
  602,    0,  602,    0,  602,    0,  602,  602,  602,    0,
    0,    0,    0,    0,    0,    0,  602,  602,    0,    0,
    0,  602,  602,    0,  604,    0,    0,    0,    0,    0,
  602,  602,  602,  602,    0,    0,    0,    0,    0,  603,
    0,    0,    0,    0,  603,  602,  603,  603,  603,  603,
  603,  603,  603,  603,  603,  603,  603,    0,    0,    0,
    0,  602,    0,    0,    0,    0,    0,    0,  603,    0,
  603,    0,  603,    0,  603,  603,  603,    0,    0,    0,
    0,    0,    0,    0,  603,  603,    0,    0,    0,  603,
  603,    0,  607,    0,    0,    0,    0,    0,  603,  603,
  603,  603,    0,    0,    0,    0,    0,  604,    0,    0,
    0,    0,  604,  603,  604,  604,  604,  604,  604,  604,
  604,  604,  604,  604,  604,    0,    0,    0,    0,  603,
    0,    0,    0,    0,    0,    0,  604,    0,  604,    0,
  604,    0,  604,  604,  604,    0,    0,    0,    0,    0,
    0,    0,  604,  604,    0,    0,    0,  604,  604,    0,
  608,    0,    0,    0,    0,    0,  604,  604,  604,  604,
    0,    0,    0,    0,    0,  607,    0,    0,    0,    0,
  607,  604,  607,  607,  607,  607,  607,  607,  607,  607,
  607,  607,  607,    0,    0,    0,    0,  604,    0,    0,
    0,    0,    0,    0,  607,    0,  607,    0,  607,    0,
  607,  607,  607,    0,    0,    0,    0,    0,    0,    0,
  607,  607,    0,    0,    0,  607,  607,    0,  611,    0,
    0,    0,    0,    0,    0,    0,  607,  607,    0,    0,
    0,    0,    0,  608,    0,    0,    0,    0,  608,  607,
  608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
  608,    0,    0,    0,    0,  607,    0,    0,    0,    0,
    0,    0,  608,    0,  608,    0,  608,    0,  608,  608,
  608,    0,    0,    0,    0,    0,    0,    0,  608,  608,
    0,    0,    0,  608,  608,    0,  613,    0,    0,    0,
    0,    0,    0,    0,  608,  608,    0,    0,    0,    0,
    0,  611,    0,    0,    0,    0,  611,  608,  611,  611,
  611,  611,  611,  611,  611,  611,  611,  611,  611,    0,
    0,    0,    0,  608,    0,    0,    0,    0,    0,    0,
  611,    0,  611,    0,  611,    0,  611,  611,  611,    0,
    0,    0,    0,    0,    0,    0,    0,  611,    0,    0,
    0,  611,  611,    0,  614,    0,    0,    0,    0,    0,
    0,    0,  611,  611,    0,    0,    0,    0,    0,  613,
    0,    0,    0,    0,  613,  611,  613,  613,  613,  613,
  613,  613,  613,  613,  613,  613,  613,    0,    0,    0,
    0,  611,    0,    0,    0,    0,    0,    0,  613,    0,
  613,    0,  613,    0,  613,  613,  613,    0,    0,    0,
    0,    0,    0,    0,    0,  613,    0,    0,    0,    0,
  613,    0,  616,    0,    0,    0,    0,    0,    0,    0,
  613,  613,    0,    0,    0,    0,    0,  614,    0,    0,
    0,    0,  614,  613,  614,  614,  614,  614,  614,  614,
  614,  614,  614,  614,  614,    0,    0,    0,    0,  613,
    0,    0,    0,    0,    0,    0,  614,    0,  614,    0,
  614,    0,  614,  614,  614,    0,    0,    0,    0,    0,
    0,    0,    0,  614,    0,    0,    0,    0,  614,    0,
  617,    0,    0,    0,    0,    0,    0,    0,  614,  614,
    0,    0,    0,    0,    0,  616,    0,    0,    0,    0,
  616,  614,  616,  616,  616,  616,  616,  616,  616,  616,
  616,  616,  616,    0,    0,    0,    0,  614,    0,    0,
    0,    0,    0,    0,  616,    0,  616,    0,  616,    0,
  616,  616,  616,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  340,  616,    0,    0,  785,
    0,    0,    0,    0,    0,    0,  616,  616,    0,    0,
    0,    0,    0,  617,    0,    0,    0,    0,  617,  616,
  617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
  617,  340,    0,    0,    0,  616,    0,    0,    0,    0,
    0,    0,  617,    0,  617,    0,  617,  785,  617,  617,
  617,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  617,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  617,  617,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  617,    0,    0,
  340,    0,    0,    0,    0,    0,  340,    0,    0,    0,
    0,  340,  340,  617,  340,    0,  340,    0,  785,  340,
    0,  340,  340,    0,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,    0,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,    0,    0,   55,
    0,  340,    0,  340,    0,    0,  340,   56,   24,   57,
   25,    0,  340,   26,   58,    0,   59,   60,   27,   61,
   62,   63,   28,    0,    0,    0,    0,    0,   64,    0,
   65,   30,   66,   67,   68,   69,    0,    0,   32,    0,
    0,    0,   70,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   73,    0,   36,
    0,   37,   74,    0,    0,   38,    0,   75,   76,   77,
   78,   79,   80,   39,   40,   81,   82,   41,   83,    0,
   84,    0,    0,   85,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
   94,    0,    0,    0,   95,    0,    0,    0,    0,   96,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  266,    0,    0,    0,
  105,  106,  107,  108,   56,   24,   57,   25,    0,    0,
   26,   58,    0,   59,   60,   27,   61,   62,   63,   28,
    0,    0,    0,    0,    0,   64,    0,   65,   30,   66,
   67,   68,   69,    0,    0,   32,    0,    0,    0,   70,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   73,    0,   36,    0,   37,   74,
    0,    0,   38,    0,   75,   76,   77,   78,   79,   80,
   39,   40,   81,   82,   41,   83,    0,   84,    0,    0,
   85,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,   94,    0,    0,
    0,   95,    0,    0,    0,    0,   96,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  567,    0,    0,    0,  105,  106,  107,
  108,   56,   24,   57,   25,    0,    0,   26,   58,    0,
   59,   60,   27,   61,   62,   63,   28,    0,    0,    0,
    0,    0,   64,    0,   65,   30,   66,   67,   68,   69,
    0,    0,   32,    0,    0,    0,   70,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   73,    0,   36,    0,   37,   74,    0,    0,   38,
    0,   75,   76,   77,   78,   79,   80,   39,   40,   81,
   82,   41,   83,    0,   84,    0,    0,   85,   86,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,   94,    0,    0,    0,   95,    0,
    0,    0,    0,   96,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  995,    0,    0,    0,  105,  568,  107,  108,  995,  995,
  995,  995,    0,    0,  995,  995,    0,  995,  995,  995,
  995,  995,  995,  995,    0,    0,    0,    0,    0,  995,
    0,  995,  995,  995,  995,  995,  995,    0,    0,  995,
    0,    0,    0,  995,  995,    0,  995,  995,  995,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  995,    0,
  995,    0,  995,  995,    0,    0,  995,    0,  995,  995,
  995,  995,  995,  995,  995,  995,  995,  995,  995,  995,
    0,  995,    0,    0,  995,  995,    0,    0,  995,  995,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  995,  995,  995,  995,  995,    0,    0,
    0,  995,    0,    0,    0,  995,    0,    0,    0,    0,
  995,  995,  995,  995,  995,    0,    0,    0,  995,    0,
  995,    0,    0,    0,    0,    0,  995,  995,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  836,    0,    0,
    0,  995,  995,  995,  995,  836,  836,  836,  836,    0,
    0,  836,  836,    0,  836,  836,  836,  836,  836,  836,
  836,    0,    0,    0,    0,    0,  836,    0,  836,  836,
  836,  836,  836,  836,    0,    0,  836,    0,    0,    0,
  836,  836,    0,  836,  836,  836,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  836,    0,  836,    0,  836,
  836,    0,    0,  836,    0,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  836,    0,  836,    0,
    0,  836,  836,    0,    0,  836,  836,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  836,  836,  836,  836,  836,    0,    0,    0,  836,    0,
    0,    0,  836,    0,    0,    0,    0,  836,  836,  836,
  836,  836,    0,    0,    0,  836,    0,  836,    0,    0,
    0,    0,    0,  836,  836,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  605,    0,    0,    0,  836,  836,
  836,  836,   56,   24,    0,   25,    0,    0,   26,  254,
    0,  636,    0,   27,   61,   62,    0,   28,    0,    0,
   24,    0,   25,   64,    0,   26,   30,    0,    0,    0,
   27,    0,    0,   32,   28,    0,    0,    0,   33,    0,
   71,   72,   34,   30,  606,    0,    0,    0,    0,    0,
   32,  607,    0,    0,   36,   33,   37,   74,    0,   34,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,   36,   41,   37,    0,    0,    0,   38,    0,  608,
    0,    0,   87,   88,    0,   39,   40,    0,    0,   41,
    0,    0,  324,    0,    0,    0,    0,   89,   90,   91,
   92,   93,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,  609,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  775,    0,    0,    0,  105,  106,  107,  108,   56,
   24,    0,   25,    0,    0,   26,  254,    0,  940,    0,
   27,   61,   62,  366,   28,    0,    0,   24,    0,   25,
   64,    0,   26,   30,    0,    0,    0,   27,    0,    0,
   32,   28,    0,    0,    0,   33,    0,   71,   72,   34,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,   36,   33,   37,   74,    0,   34,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,   36,   41,
   37,    0,    0,    0,   38,    0,   86,    0,    0,   87,
   88,    0,   39,   40,    0,    0,   41,    0,    0,  324,
    0,    0,    0,    0,   89,   90,   91,   92,  302,    0,
    0,    0,  528,  776,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  966,    0,
    0,    0,  105,  303,  107,  108,   56,   24,    0,   25,
    0,    0,   26,  254,    0, 1087,    0,   27,   61,   62,
  366,   28,    0,    0,   24,    0,   25,   64,    0,   26,
   30,    0,    0,    0,   27,    0,    0,   32,   28,    0,
    0,    0,   33,    0,   71,   72,   34,   30,  606,    0,
    0,    0,    0,    0,   32,  607,    0,    0,   36,   33,
   37,   74,    0,   34,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,   36,   41,   37,    0,    0,
    0,   38,    0,  608,    0,    0,   87,   88,    0,   39,
   40,    0,    0,   41,    0,    0,  324,    0,    0,    0,
    0,   89,   90,   91,   92,   93,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  971,    0,    0,    0,  105,
  106,  107,  108,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,  366,   28,    0,
    0,  176,    0,  176,   64,    0,  176,   30,    0,    0,
    0,  176,    0,    0,   32,  176,    0,    0,    0,   33,
    0,   71,   72,   34,  176,    0,    0,    0,    0,    0,
    0,  176,    0,    0,    0,   36,  176,   37,   74,  972,
  176,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,  176,   41,  176,    0,    0,    0,  176,    0,
   86,    0,    0,   87,   88,    0,  176,  176,    0,    0,
  176,    0,    0,  176,    0,    0,    0,    0,   89,   90,
   91,   92,  302,    0,    0,    0,  528,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0, 1019,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,  105,  303,  107,  108,
   64,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,  176,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,   86,    0,    0,   87,
   88,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,  302,    0,
    0,    0,  761, 1039,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  775,    0,  105,  762,  107,  108,    0,    0,   56,   24,
    0,   25,    0,  763,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,  176,    0,  176,   64,
    0,  176,   30,    0,    0,    0,  176,    0,    0,   32,
  176,    0,    0,    0,   33,    0,   71,   72,   34,  176,
    0,    0,    0,    0,    0,    0,  176,    0,    0,    0,
   36,  176,   37,   74,  972,  176,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,  176,   41,  176,
    0,    0,    0,  176,    0,   86,    0,    0,   87,   88,
    0,  176,  176,    0,    0,  176,    0,    0,  176,    0,
    0,    0,    0,   89,   90,   91,   92,  302,    0,    0,
    0,  528,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102, 1019,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  105,  303,  107,  108,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,  176,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,  302,    0,    0,    0,  761,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  775,    0,  105,  762,  107,
  108,    0,    0,   56,   24,    0,   25,    0,  763,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,   24,    0,   25,   64,    0,   26,   30,    0,    0,
    0,   27,    0,    0,   32,   28,    0,    0,    0,   33,
    0,   71,   72,   34,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,   36,   33,   37,   74,    0,
   34,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,   36,   41,   37,    0,    0,    0,   38,    0,
   86,    0,    0,   87,   88,    0,   39,   40,    0,    0,
   41,    0,    0,  324,    0,    0,    0,    0,   89,   90,
   91,   92,  302,    0,    0,    0,  528,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  301,    0,    0,    0,  105,  303,  107,  108,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,  366,   28,    0,    0,   24,    0,
   25,   64,    0,   26,   30,    0,    0,    0,   27,    0,
    0,   32,   28,    0,    0,    0,   33,    0,   71,   72,
   34,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,   36,   33,   37,   74,    0,   34,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,   36,
   41,   37,    0,    0,    0,   38,    0,   86,    0,    0,
   87,   88,    0,   39,   40,    0,    0,   41,    0,    0,
  530,    0,    0,    0,    0,   89,   90,   91,   92,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  310,
    0,    0,    0,  105,  303,  107,  108,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,  366,   28,    0,    0,   24,    0,   25,   64,    0,
   26,   30,    0,    0,    0,   27,    0,    0,   32,   28,
    0,    0,    0,   33,    0,   71,   72,   34,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   36,
   33,   37,   74,    0,   34,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,   36,   41,   37,    0,
    0,    0,   38,    0,   86,    0,    0,   87,   88,    0,
   39,   40,    0,    0,   41,    0,    0,  584,    0,    0,
    0,    0,   89,   90,   91,   92,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  603,    0,    0,    0,
  105,  303,  107,  108,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,  366,   28,
    0,    0,   24,    0,   25,   64,    0,   26,   30,    0,
    0,    0,   27,    0,    0,   32,   28,    0,    0,    0,
   33,    0,   71,   72,   34,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,   36,   33,   37,   74,
    0,   34,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,   36,   41,   37,    0,    0,    0,   38,
    0,   86,    0,    0,   87,   88,    0,   39,   40,    0,
    0,   41,    0,    0,  791,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  857,    0,    0,    0,  105,  106,  107,
  108,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,  366,   28,    0,    0,  495,
    0,  495,   64,    0,  495,   30,    0,    0,    0,  495,
    0,    0,   32,  495,    0,    0,    0,   33,    0,   71,
   72,   34,  495,    0,    0,    0,    0,    0,    0,  495,
    0,    0,    0,   36,  495,   37,   74,    0,  495,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
  495,   41,  495,    0,    0,    0,  495,    0,   86,    0,
    0,   87,   88,    0,  495,  495,    0,    0,  495,    0,
    0,  495,    0,    0,    0,    0,   89,   90,   91,   92,
  302,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  969,    0,    0,    0,  105,  303,  107,  108,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,  495,   28,    0,    0,  177,    0,  177,   64,
    0,  177,   30,    0,    0,    0,  177,    0,    0,   32,
  177,    0,    0,    0,   33,    0,   71,   72,   34,  177,
    0,    0,    0,    0,    0,    0,  177,    0,    0,    0,
   36,  177,   37,   74,    0,  177,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,  177,   41,  177,
    0,    0,    0,  177,    0,   86,    0,    0,   87,   88,
    0,  177,  177,    0,    0,  177,    0,    0,  177,    0,
    0,    0,    0,   89,   90,   91,   92,  302,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1224,    0,    0,
    0,  105,  303,  107,  108,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,  177,
   28,    0,    0,  176,    0,  176,   64,    0,  176,   30,
    0,    0,    0,  176,    0,    0,   32,  176,    0,    0,
    0,   33,    0,   71,   72,   34,  176,    0,    0,    0,
    0,    0,    0,  176,    0,    0,    0,   36,  176,   37,
   74,    0,  176,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,  176,   41,  176,    0,    0,    0,
  176,    0,   86,    0,    0,   87,   88,    0,  176,  176,
    0,    0,  176,    0,    0,  176,    0,    0,    0,    0,
   89,   90,   91,   92,  302,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  340,    0,    0,    0,  105,  303,
  107,  108,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,  176,   28,    0,    0,
    0,    0,    0,   64,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  302,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  344,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  302,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  346,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  302,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  348,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  302,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  350,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  302,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  352,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  354,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  302,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  356,    0,    0,    0,    0,  103,  104,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  302,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,  358,    0,    0,    0,    0,  103,  104,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  628,    0,    0,    0,    0,  103,  104,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,  105,  257,   30,  108,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,  256,
  302,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  630,    0,    0,    0,    0,  103,
  104,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
    0,    0,    0,   64,  105,  257,   30,  108,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  302,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  632,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  302,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  638,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  302,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  640,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  302,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  642,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  302,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  644,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  646,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  302,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  648,    0,    0,    0,    0,  103,  104,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  302,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,  650,    0,    0,    0,    0,  103,  104,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  652,    0,    0,    0,    0,  103,  104,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,  105,  257,   30,  108,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,  256,
  302,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  654,    0,    0,    0,    0,  103,
  104,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
    0,    0,    0,   64,  105,  257,   30,  108,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  302,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  656,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  302,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  658,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  302,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  660,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  302,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  662,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  302,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  664,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  666,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  302,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  830,    0,    0,    0,    0,  103,  104,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  302,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,  511,    0,    0,    0,    0,  103,  104,  340,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,  340,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,    0,
    0,    0,    0,    0,    0,    0,    0,   95,  340,  340,
  340,  340,  785,    0,    0,  340,  340,    0,    0,  340,
  340,  340,  340,  340,  340,  340,  340,  340,    0,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
  340,    0,    0,  105,  512,    0,    0,  340,    0,   49,
  340,   49,    0,   49,    0,   49,    0,    0,   49,    0,
   49,   49,    0,   49,    0,   49,    0,   49,    0,   49,
   49,   49,   49,    0,    0,   49,   49,    0,    0,    0,
    0,   49,   49,   49,   49,   49,    0,    0,   49,    0,
   49,    0,   49,    0,   49,   49,    0,   49,   49,   49,
   49,    0,    0,   49,   49,   49,   49,    0,    0,   49,
   49,   49,    0,    0,    0,    0,    0,    0,   49,   49,
    0,   49,   49,    0,   49,   49,   49,    0,    0,    0,
   49,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   49,    0,   49,   49,   48,    0,    0,    0,   48,    0,
   48,    0,    0,   48,    0,   48,   48,    0,   48,    0,
   48,    0,   48,    0,   48,   48,   48,   48,    0,    0,
   48,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,    0,    0,   48,    0,   48,    0,   48,    0,    0,
   48,    0,   48,   48,   48,   48,   49,    0,    0,   48,
   48,   48,    0,    0,   48,   48,   48,    0,    0,    0,
    0,    0,    0,   48,   48,    0,   48,   48,    0,   48,
   48,   48,    0,    0,    0,   48,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   48,    0,   48,    0,   48,    0,   48,
    0,   81,   48,    0,   48,   48,    0,   48,    0,   48,
   48,   48,    0,   48,   48,   48,   48,    0,    0,   48,
   48,    0,    0,    0,    0,   48,    0,   48,   48,   48,
    0,    0,   48,    0,   48,    0,   48,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,    0,   48,   48,
   48,   48,    0,   48,   48,   48,    0,    0,    0,    0,
    0,    0,   48,   48,    0,   48,   48,    0,   48,   48,
   48,    0,    0,    0,   48,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,    0,   48,    0,   49,    0,   49,    0,
   82,   49,    0,   49,   49,    0,   49,    0,   49,   48,
   49,    0,   49,   49,   49,   49,    0,    0,   49,   49,
    0,    0,    0,    0,   49,    0,   49,   49,   49,    0,
    0,   49,    0,   49,    0,   49,    0,    0,   49,    0,
   49,   49,   49,   49,    0,    0,    0,   49,   49,   49,
   48,    0,   49,   49,   49,    0,    0,    0,    0,    0,
    0,   49,   49,    0,   49,   49,    0,   49,   49,   49,
    0,    0,    0,   49,    0,    0,    0,    0,   48,    0,
    0,    0,   48,    0,   48,    0,    0,   48,    0,   48,
   48,    0,   48,   49,   48,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,   48,    0,    0,   49,    0,
   48,    0,   48,   48,   48,    0,    0,   48,    0,   48,
    0,   48,    0,    0,   48,    0,   48,   48,   48,   48,
    0,    0,    0,   48,   48,   48,    0,    0,   48,   48,
   48,    0,    0,    0,    0,    0,    0,   48,   48,   49,
   48,   48,    0,   48,   48,   48,    0,    0,    0,   48,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   48,    0,    0,    0,   48,    0,   48,   48,
    0,   48,    0,   48,   48,  216,   48,    0,   48,    0,
   48,    0,   48,   48,   48,   48,    0,    0,   48,   48,
    0,    0,    0,    0,   48,    0,   48,   48,   48,    0,
    0,   48,    0,   48,  340,   48,    0,    0,   48,    0,
   48,   48,   48,   48,    0,    0,    0,   48,   48,   48,
    0,    0,   48,   48,   48,   48,    0,  340,    0,    0,
    0,   48,   48,    0,   48,   48,  463,   48,   48,   48,
  340,    0,    0,   48,    0,  340,    0,    0,  340,    0,
  340,    0,  340,  340,  340,  340,    0,    0,    0,  464,
  340,    0,    0,   48,  340,    0,    0,    0,  340,  217,
    0,    0,  465,    0,  361,    0,  340,  467,    0,  340,
    0,  340,  468,    0,  469,  470,  471,  472,    0,    0,
    0,    0,  473,    0,    0,    0,  474,  361,    0,    0,
  340,    0,    0,    0,  463,  340,    0,    0,  475,    0,
  361,  476,  340,  477,  267,  361,  340,    0,  233,   48,
  361,    0,  361,  361,  361,  361,    0,  464,    0,  340,
  361,    0,    0,    0,  361,    0,    0,  478,  361,    0,
  465,    0,    0,    0,    0,  467,  361,    0,    0,  361,
  468,  361,  469,  470,  471,  472,    0,    0,    0,    0,
  473,  340,    0,    0,  474,    0,    0,    0, 1363,    0,
    0,   56,   24,    0,   25,  361,  475,   26,  254,  476,
    0,  477,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64, 1381,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,  478,    0,   33,    0,   71,
   72,   34,    0,  606,    0,    0,    0,    0,    0,    0,
  607,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,  361,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,  608,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0, 1364,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,    0,    0,    0,    0,   95,  964,
    0,  609,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,  105,  106,  107,  108,   64,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,  606,
    0,    0,    0,    0,    0,    0,  607,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,  608,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,  609,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  105,  106,  107,  108,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,   84,    0,    0,    0,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,  302,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,  105,  303,  107,  108,
   64,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,   86,    0,    0,   87,
   88,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,  302,    0,
    0,    0,    0,  923,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,  105,  303,  107,  108,   64,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,   86,    0,    0,   87,   88,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,   92,  302,    0,    0,    0,  528,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,  105,  303,
  107,  108,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,   86,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
  302,    0,    0,    0,  522,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,  105,  303,  107,  108,   64,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  105,  303,  107,  108,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,   93,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,  105,  106,  107,  108,
   64,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,   86,    0,    0,   87,
   88,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,   93,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,  646,  646,    0,  646,    0,
    0,  646,  646,    0,    0,    0,  646,  646,  646,    0,
  646,    0,  105, 1079,  107,  108,  646,    0,    0,  646,
    0,    0,    0,    0,    0,    0,  646,    0,    0,    0,
    0,  646,    0,  646,  646,  646,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  646,    0,  646,
  646,    0,    0,  646,    0,    0,  646,    0,  646,    0,
  646,  646,  646,  646,    0,  646,    0,    0,    0,    0,
    0,    0,  646,    0,    0,  646,  646,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  646,  646,  646,  646,  646,    0,    0,    0,    0,    0,
    0,    0,  646,    0,    0,    0,    0,    0,  646,  646,
  646,  646,    0,    0,    0,  646,    0,  646,    0,    0,
    0,    0,    0,  646,  646,    0,    0,    0,    0,    0,
    0,   78,   78,    0,   78,    0,    0,   78,   78,    0,
    0,    0,   78,   78,   78,    0,   78,    0,  646,  646,
  646,  646,   78,    0,    0,   78,    0,    0,    0,    0,
    0,    0,   78,    0,    0,    0,    0,   78,    0,   78,
   78,   78,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   78,    0,   78,   78,    0,    0,   78,
    0,    0,   78,    0,   78,    0,   78,   78,   78,   78,
    0,   78,    0,    0,    0,    0,    0,    0,   78,    0,
    0,   78,   78,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   78,   78,   78,   78,
   78,    0,    0,    0,    0,    0,    0,    0,   78,    0,
    0,    0,    0,    0,   78,   78,   78,   78,    0,    0,
    0,   78,    0,   78,    0,    0,    0,    0,    0,   78,
   78,    0,    0,    0,    0,    0,    0,  137,  137,    0,
  137,    0,    0,  137,  137,    0,    0,    0,  137,  137,
  137,    0,  137,    0,   78,   78,   78,   78,  137,    0,
    0,  137,    0,    0,    0,    0,    0,    0,  137,    0,
    0,    0,    0,  137,    0,  137,  137,  137,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  137,
    0,  137,  137,    0,    0,  137,    0,    0,  137,    0,
  137,    0,  137,  137,  137,  137,    0,  137,    0,    0,
    0,    0,    0,    0,  137,    0,    0,  137,  137,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  137,  137,  137,  137,  137,    0,    0,    0,
    0,    0,    0,    0,  137,    0,    0,    0,    0,    0,
  137,  137,  137,  137,    0,    0,    0,  137,    0,  137,
    0,    0,    0,    0,    0,  137,  137,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  137,  137,  137,  137,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,   28,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,   28,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,   28,   41,    0,    0,    0,   28,    0,    0,
    0,    0,   28,    0,   28,   28,   28,   28,    0,    0,
   28,    0,   28,    0,    0,    0,   28,    0,   89,   90,
   91,  256,  302,    0,    0,    0,    0,    0,   28,    0,
   95,   28,    0,   28,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,   28,    0,    0,
    0,    0,    0,   28,   28,    0,    0,    0,    0,    0,
    0,  681,    0,  681,    0,  681,  105,  257,  681,  108,
  681,  681,    0,  681,    0,  681,    0,  681,    0,  681,
  681,  681,    0,    0,    0,  681,  681,    0,    0,    0,
    0,  681,    0,  681,  681,    0,    0,    0,  681,    0,
    0,    0,  681,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  681,  681,    0,  681,    0,    0,    0,
  681,  681,    0,    0,    0,    0,    0,    0,  681,  681,
   56,   24,  681,   25,    0,  681,   26,  254,    0,    0,
  681,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,  681,  681,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,  681,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,   84,    0,    0,    0,    0,    0,    0,
   24,    0,   25,    0,    0,   26,  681, 1270,    0,    0,
   27,    0,    0,    0,   28,   89,   90,   91,  256,    0,
    0,    0,    0,   30,  680,    0,  680,   95,    0,  680,
   32,  680,  680,    0,  680,   33,  680, 1271,  680,   34,
  680,  680,  680,    0,    0,    0,  680,  680,    0,    0,
    0,   36,  680,   37,  680,  680,    0,   38, 1272,  680,
    0,    0,    0,  680,    0,   39,   40,    0,    0,   41,
    0,    0,  324,  105,  257,  680,    0,  680,    0,    0,
    0,  680,  680,    0,    0,    0,    0,    0,    0,  680,
  680,    0,  680,  680,  680,    0,  680,  680,    0,  680,
  680,  680,  680,    0,  680,    0,  680,    0,  680,  680,
  680,    0,    0,    0,  680,  680,    0,    0,    0,    0,
  680,    0,  680,  680,    0,    0,    0,  680,    0,    0,
    0,  680,    0,    0,    0,    0,  680,    0,    0,    0,
    0,    0,    0,  680,    0,  680,    0,    0,    0,  680,
  680,    0,    0,  366,    0,    0,    0,  680,  680,    0,
    0,  680,    0,    0,  680,    0,   24,    0,   25,  680,
    0,   26,    0,    0, 1332,    0,   27,  680,  718,    0,
   28,    0,  719, 1333, 1334,    0,    0,    0, 1335,   30,
    0,    0,    0,    0, 1336,    0,   32,    0,   24,    0,
   25,   33,    0,   26,    0,   34, 1332,    0,   27,    0,
  718,    0,   28,    0,  719, 1333, 1334,   36,    0,   37,
 1335,   30,    0,   38,    0,    0, 1336,    0,   32,    0,
    0,   39,   40,   33,    0,   41,    0,   34, 1337,    0,
    0,    0,   48, 1338,   48,  680,    0,   48,    0,   36,
    0,   37,   48,    0,    0,   38,   48,    0,    0,    0,
    0,    0,    0,   39,   40,   48,    0,   41,    0,    0,
 1337,    0,   48,    0,   48, 1338,   48,   48, 1339,   48,
    0,   48,    0,   48,   48,   48,    0,    0,   48,    0,
   48,    0,    0,   48,    0,   48,    0,   48,    0,   48,
    0,    0,   48,    0,   48,    0,    0,   48,   48,   48,
    0,   48,    0,   48,   48,   48,    0,   48,   49, 1340,
   49,    0,   48,   49,    0,   48,    0,   48,   49,    0,
    0,   48,   49,    0,   48,    0,    0,    0,    0,   48,
   48,   49,    0,   48,    0,    0,   48,    0,   49,  156,
   48, 1340,   48,   49,    0,   48,    0,   49,    0,   49,
   48,   49,    0,    0,   48,    0,   49,    0,    0,   49,
    0,   49,    0,   48,    0,   49,    0,    0,   49,  156,
   48,    0,    0,   49,   49,   48,    0,   49,    0,   48,
   49,   48,    0,   48,   24,   48,   25,    0,   48,   26,
    0,   48,    0,   48,   27,    0,    0,   48,   28,    0,
   48,    0,    0,    0,    0,   48,   48,   30,    0,   48,
    0,    0,   48,    0,   32,    0,    0,   48,    0,   33,
    0,    0,    0,   34,    0,  581,    0,    0,    0,   24,
    0,   25,  582,    0,   26,   36,    0,   37,    0,   27,
    0,   38,    0,   28,  583,    0,    0,   29,    0,   39,
   40,    0,   30,   41,    0,    0,  584,   31,    0,   32,
    0,   49,    0,    0,   33,    0,    0,    0,   34,   35,
    0,    0,    0,   24,    0,   25,    0,    0,   26,    0,
   36,    0,   37,   27,    0,    0,   38,   28,    0,    0,
    0,    0,    0,   48,   39,   40,   30,  186,   41,  186,
    0,    0,  186,   32,    0,    0,    0,  186,   33,    0,
    0,  186,   34,    0,    0,    0,    0,    0,    0,    0,
  186,    0,    0,    0,   36,    0,   37,  186,    0,    0,
   38,    0,  186,    0,    0,    0,  186,  585,   39,   40,
    0,    0,   41,    0,   34,  324,    0,    0,  186,    0,
  186,    0,    0,    0,  186,   34,    0,    0,    0,    0,
   34,    0,  186,  186,   34,    0,  186,   34,    0,  186,
    0,  291,    0,    0,    0,    0,    0,    0,    0,   34,
   34,    0,   42,    0,   34,   34,    0,   32,    0,    0,
   34,    0,   34,   34,   34,   34,    0,    0,   32,    0,
   34,    0,    0,   32,   34,    0,   34,   32,    0,    0,
   32,    0,    0,    0,    0,    0,   34,    0,   34,   34,
    0,   34,   32,   32,    0,   34,  325,   32,   32,    0,
   28,    0,   28,   32,    0,   32,   32,   32,   32,    0,
    0,    0,    0,   32,    0,   34,    0,   32,    0,   32,
  186,   34,   34,   28,    0,    0,    0,    0,    0,   32,
    0,    0,   32,    0,   32,    0,   28,    0,   32,    0,
    0,   28,    0,   48,    0,    0,   28,    0,   28,   28,
   28,   28,    0,    0,   48,    0,   28,    0,   32,   48,
   28,    0,    0,   48,   32,   32,   48,    0,    0,    0,
    0,    0,   28,    0,    0,   28,    0,   28,   48,   48,
    0,    0,    0,   48,   48,    0,   48,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,   48,    0,   48,
    0,   28,   48,   48,    0,   48,   48,   28,   28,   48,
    0,    0,    0,    0,    0,   48,    0,    0,   48,    0,
   48,   48,   48,    0,   48,    0,   48,   48,   48,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,   48,    0,   48,    0,   48,    0,
   36,   48,    0,    0,    0,    0,    0,    0,   48,    0,
    0,   48,    0,   48,   48,    0,   48,   48,    0,   48,
    0,    0,    0,    0,   48,    0,   48,   48,   48,   48,
    0,    0,    0,    0,   48,    0,    0,   48,   48,   48,
    0,    0,    0,   37,    0,    0,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,    0,    0,   48,   48,    0,   48,
    0,   48,   48,    0,    0,  198,    0,    0,   48,    0,
   48,   48,   48,   48,    0,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,    0,
   48,    0,    0,    0,   48,   48,    0,   48,    0,   48,
   48,    0,   48,  200,   48,    0,   48,    0,   48,   48,
    0,   48,    0,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,   48,    0,   48,    0,    0,   48,    0,
    0,    0,   48,    0,    0,   48,    0,    0,   48,    0,
    0,  303,  463,   48,   48,    0,    0,   48,   48,   48,
   48,   48,   48,   48,    0,    0,   48,    0,   48,    0,
    0,    0,   48,    0,    0,  464,    0,    0,    0,    0,
    0,    0,  463,   48,   48,   48,   48,   48,  465,   48,
    0,    0,  466,  467,    0,    0,    0,    0,  468,    0,
  469,  470,  471,  472,    0,  464,    0,    0,  473,    0,
    0,    0,  474,   48,    0,    0,    0,    0,  465,    0,
    0,    0,    0,  467,  475,    0,    0,  476,  468,  477,
  469,  470,  471,  472,    0,    0,    0,    0,  473,    0,
    0,    0,  474,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  478,  475,    0,    0,  476,    0,  477,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  478,
  };
  protected static readonly short [] yyCheck = {            17,
   17,    4,   18,   17,   51,  526,  299,   51,  342,  189,
  300,   17,  234,  528,  289,  232,  188,  480,   20,  323,
   59,    6,  247,  157,  334,  298,  365,   17,  502,  381,
   68,   84,  570,   59,  753,  814,  755,  587,  972, 1148,
  780,   77,  296,    0,   58,   87,   88, 1184, 1185,   87,
   88,  325,   47,  365,   92,   73,  294,  330,  596,   77,
  113,  113,  115,  115,  256,   79,  108,   81,  306,   59,
  268,  256,  325,   63,  335,  256,  268,   95,    0,  256,
  977,  256,  801,  256, 1277,  804,  256,  256,  191,  256,
  256,  256,  256,  372,  277, 1229,  372, 1234,  281,  256,
   17, 1294,  256, 1489, 1490,  268,  256,  677,  678,  282,
  256,  368, 1261,  256,  391,  414,  256,  414,  256,  256,
  357,  256,  925,  256,  368,  394,  395,  256,  372,  428,
   17,  428,  376,  936,  172,  256,  256,  414,    0,  157,
  157,  314,  189,  157,  418,  189,  372,  697,  421,  386,
  429,  157,   17,  429,  294,  380, 1305,  199,  200,  342,
 1546,  418,   17,   17,  339,  418,  343,  157,  429,  344,
  368,  346,   17,  256,  349,  350,   17,  352,  353,   17,
  418,   17,  339,   17,   17,  232,  371,  344,  232,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  381,  371,  367,  429,  543,  372,  371, 1104,  372,  247,
  374,  368,  522,  370,  391,  372, 1350,  374,  375,  376,
  262,  259,  325,  445,  422,  371,  565,  444,  223,  247,
  422,  381,  525,  390,  367,  253,  570,  414,  371, 1143,
  157,  756,  363,  228,  401,  418,  288,  286,  587,  418,
  420,  428,  418,  565,  429,  420,  413,  296,  256,  422,
  286,  381,  596,  366,  418,  429,  308, 1460,  371,  322,
  157,  289,  429,  326,  420,  418,  294,  295,  331,  331,
  418,  418, 1061,  418,  367,  256,  369,  420,  371,  418,
  328,  309,  157,  319, 1487,  333,  286,  418,  256,  317,
  257,  319,  157,  157,  318,  323, 1499,  256, 1501,  256,
  256,  256,  157,  256,  256, 1034,  157,  335,  336,  157,
  362,  157,  256,  157,  157,  342,  277,  256,  371,  319,
  256,  358,  363,  369,  256,   20,  342,  420, 1078,  263,
  423,  268,  380,  381,  256, 1454,  367,  450, 1127,  276,
  371,  369,  342,  256,  904,  367,  398,  399,  697,  256,
  358,  256,  380,  381,  376,  256,  384,  385,  386,  387,
  388,  389,  390,  391,  392,  393,  394,  420,  256,  718,
  256,  256,  485, 1520,  426,  427,  698,  418,  426,  427,
  368,  315,  430,  257,  340,  257,  367,  444,  416,  420,
  444, 1335,   87,   88,  256,  376,  256,  454,  257,  979,
  272,  981,  363, 1550,  984,  277,  256,  339,  376,  281,
  367,  370,  937,  108, 1233,  374,  424,  425,  426,  427,
  375,  256,  375,  375,  296,  256,  363,  741,  256, 1158,
  418,  375,  916,  372,  446,  367, 1255, 1166,  374,  371,
  494,  373,  374,  375,  376,  256,  451,  452,  460,  381,
  372,  323,  457,  501,  256,  503,  363,  418,  419,  372,
  256, 1190,  694,  370,  369,  372,  502,  374,  947,  370,
  342,  495,  585,  374,  256,  256,  372, 1391,  526,  828,
  368,  418,  368,  845,  369,  598,  374,  600,  374,  602,
 1070,  726, 1072, 1073,  758,  543,  524,  363,  526,  547,
  528,  733,  502, 1028,  199,  200,  828, 1421, 1422,  369,
 1424,  418,  374,  376,  256,  539,  540, 1246,  256,  398,
  399, 1435,  372,  401, 1438,  553,  262, 1346,  335,  266,
  558,  543, 1351,  429,  369,  413,  266,  339,  586, 1453,
 1181,  372,  344,  570,  346,  341,  374,  349,  350,  363,
  352,  353,  418,  577,  570,  904,  368,  263, 1377,  368,
  368,  372,  298, 1477,  376,  256,  429,  262,  376,  596,
  570,  357,  374,  369, 1053,  688, 1055,  314,  606,  607,
  596,  903,  374,  369,  314,  367,  372,  373,  369,  371,
 1170,  373,  374,  288,  376,  708,  596, 1238,  901,  381,
  386,  339, 1261,  370,  418,  300,  344,  374,  346,  315,
  930,  349,  350,  308,  352,  353,  851,  429,  256,  368,
  429, 1201,  256,  767,  416,  367,  674,  429,  676,  371,
  418,  373,  374,  415,  376,  421,  374,  685,  375,  381,
  256,  363,  378,  379,  672,  375, 1305, 1195,  339,  677,
  678,  934,  680,  344,  343,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  256,  362, 1248,  368,
  365,  305,  972,  343,  256,  368,  368,  368,  726,  370,
  429,  372,  264,  374,  375,  376, 1266,  368,  341,  305,
  339,  429,  381,  294,  305,  743,  418,  343,  726,  390,
  305,  339,  391,  398,  399,  306,  344, 1191,  346,  758,
  401,  349,  350,  741,  352,  353,  369, 1031,  367,  256,
  363,  391,  413,  371,  719,  414,  369,  372,  756,  792,
  429,  426,  427,  761,  786,  381,  429,  429,  429,  428,
 1043,  256,  369,  325,  414,  391,  373,  795,  429,  339,
 1261,  446,   21,  753,  344,  755,  346,  809,  428,  349,
  350,  996,  352,  353,  788,  460,  256,  256,  414,  272,
 1261,  363,  824,  418,  369,  418, 1354,  369,  806,  827,
  808,  272,  428,   52, 1261,  371,  381,  373,  812, 1367,
  814,  429, 1261,  296, 1305,  823,  423,  845,  374, 1260,
 1261,  801,  339,  851,  804,  296,  988,  344,  371,  346,
  373, 1389,  349,  350, 1305,  352,  353,  845, 1162, 1280,
  323,  878,  256,  851,  339,  853,  418,  855, 1305,  344,
 1115,  346,  323,  946,  349,  350, 1305,  352,  353,  429,
  416,  339,  381, 1261, 1305, 1148, 1307, 1261,  543,  306,
  339, 1195,  391,  905,  908,  344,  313,  346,  367,  269,
  349,  350,  369,  352,  353,  391, 1151,  376,  325,  367,
  565,  899, 1029,  901,  886,  414,  286,  367,  368,  369,
  373,  371,  372,  376,  374, 1229,  376, 1305,  414,  428,
  918, 1305,  587,  941, 1367,  943,  891,  925,  376,  272,
 1057,  949,  428, 1188,  277,  339, 1141,  935,  281,  937,
  344,  272,  346,  367,  429,  349,  350, 1442,  352,  353,
  376,  381,  376,  296,  339,  367,  357,  975,  418,  357,
  420,  391,  363,  423,  376,  296,  386,  418,  369, 1052,
  429,  372,  373,  374,  256,  373,  294,  428,  996, 1001,
  323,  979,  367,  981,  414,  386,  984,  269,  386,  370,
  371,  376,  323,  374, 1012,  368, 1315,  368,  996,  342,
  371,  374,  373,  374,  286, 1324, 1208, 1204,  381, 1504,
  418,  993,  367, 1268,  367,  357,  368,  418,  357, 1179,
  428,  392,  393,  376,  376,  429,  404,  405,  406,  407,
 1028,  373,  697, 1031,  373,  371, 1350,  373, 1003,  357,
 1005,  412, 1007,  306,  386,  363, 1541,  386,  371,  420,
  313,  369,  423,  718,  372,  373,  392,  393,  368,  369,
  367,  368, 1563, 1564, 1034, 1335,  385, 1061,  386,  376,
  367,  368, 1070,  418, 1072, 1073,  412, 1075,  384,  376,
  368,  382,  383,  400,  420,   61,  374,  423,  376,   65,
   66,   67,  390,   69,   70,  396,  397,  370,   74,   75,
  418,  374, 1085,  421,  389,   81,  306,   83,  308,   85,
  354,  355,  370,  313,   90,   91,  374, 1115,  370, 1143,
  367,  786,  374, 1141,  371,  325,  373,  374,  374,  376,
  376, 1129, 1130, 1127,  381,  381,    6,  372,  114,  374,
  372,  376,  374, 1141,  809,  372, 1142,   17,  373,  376,
 1148,  376, 1179, 1151, 1181, 1179,  370, 1181,  372,  824,
  374,  368,  418,  828,  371, 1162,  373,  374,  415,  370,
  372,  372, 1170,  374,  376,  372, 1162, 1204, 1176,  376,
 1204, 1454,  367,  370,  369,  392,  393,  374, 1158,   59,
 1188,  368, 1162,   63,  369,  372, 1166,  374, 1195,  376,
  354,  355,  368, 1201, 1202,  412,  372,  371,  374, 1195,
  376, 1238,  415,  420, 1238,  372,  423,   87,   88,  376,
 1190,  886,  418,  370,  371, 1195,  373,  374,  375,  372,
  256,  374, 1229, 1260, 1261,  418, 1260, 1259,  108,  904,
  905,  373,  369, 1229,  376,  372,  370,  285,  372,  374,
 1248,  376,  370, 1280,  372,  277, 1280, 1340,  367, 1229,
  386,  387,  388,  370,  370,  372,  372,  372, 1266,  374,
 1268,  372,  370,  374,  372,  370, 1246,  372, 1305,  255,
 1307, 1364,  258, 1307,  374,  376,  376,  157,  256,  327,
 1308,  374, 1314,  376,  374,  374,  376,  376, 1381,  368,
  369,  414,  415,  364,  365,  372,  373,  972,  364,  365,
 1332, 1333,  400,  401,  408,  409, 1399,  376, 1401,    0,
 1146, 1147,  298,  373, 1318,  402,  403,  376,  993,  199,
  200,  376,  294,  294, 1356,  343, 1001, 1359,  314,  377,
  378,  379,  380,  372,  382,  383,  384,  385,  386,  387,
  388,  389,  376, 1350,  392,  393,  394,  395,  396,  397,
  398,  399,  414,  418, 1350,  356,  369, 1391,  375,  374,
  418,  418,  372,  372,  376,  368,  372,  294, 1372,  294,
 1350,  256,  374,  372,  372,  256,  372,  374,  294,  371,
  294,  256,  262,  376,  372,  374,  381, 1421, 1422,  373,
 1424,  373,  375,  374,  418, 1432,  381,  372,  374,  429,
  374, 1435,  423,  373, 1438,  374,  286,  374,  288,  372,
  374,  367, 1449,  374,  421,  372,  374,  372,  294, 1453,
  300,  343,  294,  374,  418, 1462, 1463,  370,  308,  371,
  367,  418,  256,  256, 1442,  375, 1440,  256,  374,  319,
  256,  280,  381, 1477,  256,  368, 1454,  367,  372,  343,
   93,  351, 1489, 1490,   97,   98,   99,  100,  101,  102,
  103,  104,  342, 1471,  339,  370,  376,  371,  374,  344,
  372,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  362,  374,  376,  365,  370,  347,  423,  372,
  372,  381,  381,  368,  367,  370, 1504,  372,  256,  374,
  375,  376,  381,  256,  372,  372,  376, 1182,  256, 1546,
  385,  497,  368,  347,  389,  390,  374,  370,  398,  399,
  375,  370,  367,    0,  370,  400,  401,  348,  372,  339,
  368,  418,  374, 1541,  348, 1563, 1564,  372,  413,  376,
  418,  256,  368, 1547, 1548,  367,  426,  427,  368,  367,
 1554, 1555,  367,  539,  429, 1563, 1564,  356,  337,  368,
  371,  305,  368,  376,  381, 1240,  257,  374,  372,  371,
  261,  368,  368,  381,  369,  418,  367,  418,  418,  371,
  381,  272,  376,  371, 1259,  418,  277,  371,  373,  371,
  281,  367,  381,  284,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  371,  296,  297,  369,  371,  374,
  301,  302,  372,  372,    0,  256,  307,  373,  309,  310,
  311,  312,  502,  373,  376,  374,  317,  374,  374,  372,
  321,  418,  323,  372,  370,  418,  376,  418,  376, 1314,
 1315,  372,  333,  418,  335,  336,  376,  338,  372, 1324,
  372,  342,  381,  381,  368,  372,  368, 1332, 1333,  302,
 1335,  370,  367,  543,  315,  263, 1341,  371,  371,  368,
  372,  362,  372,    0,  261,    0,  368,  368,  369, 1354,
  367, 1356,  376,  376, 1359,  565,  372,    0,  368,  372,
  570,  334, 1367,  372,  370,  418,  368,  284,  372,  368,
  370,  372,  367,  376,  368,  418,  372,  587,  418,  376,
  297,  368,  372,  376, 1389,  302,  596,  376,  305,  368,
  307,  367,  309,  310,  311,  312,  368,  367,  372,  376,
  317,  368,  367,  372,  321,  373,  315,  263,  325,   50,
  376,   12,  376,  376,  376,  376,  333,  376,  376,  336,
  376,  338,  395,  396,  397,    5,  886,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  414,  415,  993, 1141,  362, 1307, 1141, 1280,  256,
  257, 1494, 1510, 1457,  261,  718, 1445, 1474,  265,    0,
  267, 1440, 1341,  270,  908,  272,  273,  903,  275,  908,
  277,  908,  279,  732,  281,  282,  283,  284, 1354, 1555,
  287,  288, 1305, 1373, 1549, 1467,  293,  697,  295,  296,
  297, 1463, 1462,  300,  301,  302, 1238,  304, 1548, 1341,
  307,  418,  309,  310,  311,  312, 1401,  878,  718,  316,
  317,  318,  543, 1240,  321,  322,  323,  930,  761,  380,
  607,  851,  726,  330,  331, 1043,  333,  334,   71,  336,
  337,  338,  758,  337,  410,  342,  411,  414,  412,  828,
  256,  413,  415,  753, 1218,  755,  262,  565, 1162,  522,
  157, 1314, 1030, 1106, 1130,  362, 1057, 1014, 1118, 1120,
 1191,  368,  369,  541,  435,  951,  435,  683, 1202,   -1,
  377, 1310,   -1,   -1,  884,   -1,  786,   -1,   -1,   -1,
  883,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  801,   -1,   -1,  804,   -1,   -1,   -1,   -1,  809,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  418,   -1,   -1,  824,   -1,   -1,   -1,  828,  592,
   -1,   -1,   -1,  339,   -1,   -1,    0,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,
   -1,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  386,   -1,   -1,  389,  390,   -1,  261,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  904,  905,   -1,  413,   -1,  284,
  416,   -1,  418,   -1,  420,   -1,    0,  423,   -1,   -1,
   -1,   -1,  297,  429,   -1,  256,   -1,  302,   -1,   -1,
  261,  262,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  315,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,   -1,   -1,  297,  298,   -1,   -1,
   -1,  302,  972,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,  362,   -1,   -1,
  321,   -1,   -1,  368,  325,   -1,   -1,   -1,   -1,   -1,
   -1, 1001,  333,   -1,   -1,  336,   -1,  338,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,  362,  363,   -1, 1034,   -1,  367,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,   -1,  416,   -1,  418,   -1,  420,
   -1,   -1,  423,  257,   -1,   -1,    0,  261,  429,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,
   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321, 1158,  323,
   -1,   -1, 1162,   -1,  256,   -1, 1166,  930,   -1,  333,
  262,   -1,  336,  257,  338,   -1,   -1,  261,  342,   -1,
   -1,   -1, 1182,   -1,   -1,   -1,   -1,   -1,  272,   -1,
 1190,   -1,   -1,  277,   -1, 1195,   -1,  281,  362,   -1,
  284,   -1,   -1,  367,  368,  369,  298,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312, 1229,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,  323,
 1240,   -1,   -1,   -1,   -1,   -1, 1246,   -1,   -1,  333,
   -1,  335,  336,   -1,  338,   -1,   -1,   -1,  342, 1259,
   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  362,  371,
   -1,  373,  374,   -1,   -1,  369,  378,  379,   -1,   -1,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1, 1314, 1315,   -1,   -1,   -1,   -1,
  412,  413,   -1,   -1, 1324,   -1,   -1,   -1,  420,   -1,
   -1,  423, 1332, 1333,   -1, 1335,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 1350,   -1,  256,  257,   -1,   -1, 1356,   -1,   -1, 1359,
  264,  265,  266,  267,  268,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,  280,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,    0,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,  368,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  417,  418,  419,  420,   -1,  422,  256,
  257,   -1,   -1,   -1,   -1,  429,   -1,  264,  265,  266,
  267,  268,   -1,  270,  271,    0,  273,  274,  275,  276,
  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,  368,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,  380,   -1,  256,   -1,  384,   -1,  386,
  261,  262,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
  417,  418,  419,  420,   -1,  422,  297,  298,   -1,   -1,
   -1,  302,  429,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,  362,  363,   -1,   -1,   -1,  367,  368,  369,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
   -1,  382,  383,  384,  385,  386,   -1,   -1,  389,  390,
   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,  256,   -1,   -1,   -1,    0,  261,  262,   -1,   -1,
   -1,   -1,  413,   -1,   -1,  416,   -1,  418,   -1,  420,
   -1,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,  362,  363,    0,
   -1,   -1,  367,  368,  369,  370,  371,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,  256,   -1,   -1,  389,  390,  261,  262,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,  284,
   -1,  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,
   -1,   -1,  297,  298,  429,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,  362,  363,    0,
   -1,   -1,  367,  368,  369,  370,  371,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,  256,   -1,   -1,  389,  390,  261,  262,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  413,  284,
   -1,  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,
   -1,   -1,  297,  298,  429,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,    0,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,  256,   -1,  362,  363,   -1,
   -1,  262,  367,  368,   -1,  370,  371,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,    0,   -1,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,  298,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,
   -1,  416,   -1,  418,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,    0,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,  363,   -1,   -1,   -1,  367,  368,   -1,  370,
  371,  372,    0,  374,  375,  376,   -1,  378,  379,   -1,
   -1,  382,  383,  384,  385,   -1,  257,   -1,  389,  390,
  261,   -1,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,  272,   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,
  281,   -1,  413,  284,   -1,  416,   -1,  418,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  429,  257,
  301,  302,   -1,  261,   -1,    0,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,
  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,  342,  257,  301,  302,   -1,  261,   -1,    0,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,
   -1,  362,  277,  321,   -1,  323,  281,  368,  369,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  296,  297,   -1,  342,   -1,  301,  302,   -1,   -1,
   -1,    0,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,   -1,
  368,  369,   -1,  257,   -1,   -1,   -1,  261,  333,   -1,
   -1,  336,   -1,  338,   -1,   -1,   -1,  342,  272,   -1,
   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,  296,  297,  369,   -1,  257,  301,  302,   -1,
  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  272,   -1,  317,   -1,   -1,  277,  321,   -1,  323,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,  257,
  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,
  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,  342,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,  362,  257,  321,   -1,  323,  261,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,  272,  336,   -1,
  338,   -1,  277,   -1,  342,   -1,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  296,  297,   -1,  362,  257,  301,  302,   -1,  261,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  272,   -1,  317,   -1,   -1,  277,  321,   -1,  323,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  296,  297,   -1,  342,  257,  301,
  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
  362,   -1,  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,  256,  336,   -1,  338,
   -1,   -1,   -1,  342,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,  362,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,  256,  344,  345,   -1,   -1,   -1,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
  380,   -1,   -1,   -1,  384,  298,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,  419,
  420,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  429,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,
  363,   -1,   -1,   -1,   -1,  368,  369,  370,  371,  372,
  373,  374,  375,  376,  256,  378,  379,   -1,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,   -1,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,   -1,  256,   -1,   -1,  418,   -1,  420,  262,   -1,
  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  298,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  367,  368,  369,  370,  371,  372,  373,
  374,  375,  376,  256,  378,  379,   -1,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  429,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,  256,   -1,   -1,   -1,   -1,  420,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  298,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,  368,   -1,  370,  262,  372,
   -1,  374,  375,  376,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  367,  368,  298,  370,  371,  372,  373,  374,
  375,  376,   -1,  378,  379,   -1,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  429,  392,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,   -1,
  256,   -1,   -1,   -1,   -1,  420,  262,   -1,  423,   -1,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,  363,
   -1,   -1,   -1,   -1,  368,  369,   -1,  371,  372,  373,
  374,   -1,  376,   -1,  378,  379,   -1,  381,  382,  383,
  384,  385,  298,  387,  388,  389,  390,   -1,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,   -1,   -1,   -1,  418,   -1,  420,   -1,   -1,  423,
   -1,   -1,   -1,  339,   -1,  429,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,  256,
  256,   -1,   -1,   -1,  420,  262,   -1,  423,   -1,  265,
   -1,  267,   -1,  429,  270,   -1,   -1,   -1,   -1,  275,
   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,  298,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,
   -1,  368,   -1,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,  256,  256,
   -1,   -1,  418,  420,  262,   -1,  423,   -1,  265,   -1,
  267,   -1,  429,  270,   -1,   -1,   -1,   -1,  275,   -1,
   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
  298,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,  371,  372,  373,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,   -1,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
   -1,  418,  420,  262,  256,  423,   -1,  266,   -1,   -1,
   -1,  429,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,  298,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,  314,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  357,   -1,
   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,  368,
  369,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  298,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,   -1,   -1,   -1,  418,
   -1,  420,   -1,   -1,  423,   -1,  418,   -1,   -1,   -1,
  429,   -1,   -1,  339,   -1,   -1,   -1,  256,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,   -1,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  256,  413,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,  429,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  390,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,  298,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,  256,  429,
   -1,   -1,   -1,   -1,  262,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
   -1,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  413,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  429,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  262,  390,   -1,   -1,  266,
   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  298,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,  314,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,
  357,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,
   -1,  368,  369,  429,  371,   -1,  373,   -1,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,   -1,  256,
   -1,  418,   -1,  420,   -1,   -1,  423,  264,  265,  266,
  267,   -1,  429,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,  256,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,  306,   -1,   -1,   -1,   -1,   -1,
  295,  313,   -1,   -1,  316,  300,  318,  319,   -1,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  374,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  256,   -1,
  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,  368,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,  256,   -1,  275,  276,  277,
  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,  306,   -1,
   -1,   -1,   -1,   -1,  295,  313,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,  320,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,  372,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  418,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,  368,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,  417,  418,  419,  420,   -1,   -1,  264,  265,
   -1,  267,   -1,  428,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,  265,   -1,  267,  285,
   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,  319,  320,  304,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  316,  334,  318,
   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  370,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,  417,  418,  419,
  420,   -1,   -1,  264,  265,   -1,  267,   -1,  428,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,
   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  316,  334,  318,
   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,
  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,
   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,
  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,
  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,
  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,  262,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  298,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,  371,  372,
  373,  374,  375,   -1,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,  386,  387,  388,  389,  390,   -1,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,   -1,   -1,  417,  418,   -1,   -1,  420,   -1,  261,
  423,  263,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,  294,  295,  296,  297,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,  306,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  315,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,
  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  362,   -1,  364,  365,  261,   -1,   -1,   -1,  265,   -1,
  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,
  307,   -1,  309,  310,  311,  312,  418,   -1,   -1,  316,
  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,
   -1,  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,
  377,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,   -1,
  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,  377,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,  338,
   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,  261,   -1,
   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,
  273,   -1,  275,  362,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,  377,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,  418,
  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,  362,
   -1,  270,   -1,  272,  273,  368,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,  261,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
   -1,   -1,  321,  322,  323,  418,   -1,  284,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,  261,  336,  337,  338,
  297,   -1,   -1,  342,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  284,
  317,   -1,   -1,  362,  321,   -1,   -1,   -1,  325,  368,
   -1,   -1,  297,   -1,  261,   -1,  333,  302,   -1,  336,
   -1,  338,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,   -1,
  357,   -1,   -1,   -1,  261,  362,   -1,   -1,  333,   -1,
  297,  336,  369,  338,  371,  302,  373,   -1,  305,  418,
  307,   -1,  309,  310,  311,  312,   -1,  284,   -1,  386,
  317,   -1,   -1,   -1,  321,   -1,   -1,  362,  325,   -1,
  297,   -1,   -1,   -1,   -1,  302,  333,   -1,   -1,  336,
  307,  338,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,  418,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,  264,  265,   -1,  267,  362,  333,  270,  271,  336,
   -1,  338,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,  362,   -1,  300,   -1,  302,
  303,  304,   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,
  313,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  418,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  418,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,  372,
   -1,  374,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,  306,
   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,  374,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,  284,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  315,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  371,  336,   -1,  338,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,   -1,  368,  369,   -1,   -1,   -1,   -1,   -1,
   -1,  263,   -1,  265,   -1,  267,  417,  418,  270,  420,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
  264,  265,  334,  267,   -1,  337,  270,  271,   -1,   -1,
  342,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,  364,  365,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,
  265,   -1,  267,   -1,   -1,  270,  418,  272,   -1,   -1,
  275,   -1,   -1,   -1,  279,  359,  360,  361,  362,   -1,
   -1,   -1,   -1,  288,  265,   -1,  267,  371,   -1,  270,
  295,  272,  273,   -1,  275,  300,  277,  302,  279,  304,
  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,
   -1,  316,  293,  318,  295,  296,   -1,  322,  323,  300,
   -1,   -1,   -1,  304,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,  417,  418,  316,   -1,  318,   -1,   -1,
   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,  272,
  273,  342,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,  322,
  323,   -1,   -1,  418,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,  265,   -1,  267,  342,
   -1,  270,   -1,   -1,  273,   -1,  275,  418,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,  265,   -1,
  267,  300,   -1,  270,   -1,  304,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,  316,   -1,  318,
  287,  288,   -1,  322,   -1,   -1,  293,   -1,  295,   -1,
   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,   -1,
   -1,   -1,  265,  342,  267,  418,   -1,  270,   -1,  316,
   -1,  318,  275,   -1,   -1,  322,  279,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,   -1,
  337,   -1,  295,   -1,  265,  342,  267,  300,  377,  270,
   -1,  304,   -1,  306,  275,  308,   -1,   -1,  279,   -1,
  313,   -1,   -1,  316,   -1,  318,   -1,  288,   -1,  322,
   -1,   -1,  325,   -1,  295,   -1,   -1,  330,  331,  300,
   -1,  334,   -1,  304,  337,  306,   -1,  308,  265,  418,
  267,   -1,  313,  270,   -1,  316,   -1,  318,  275,   -1,
   -1,  322,  279,   -1,  325,   -1,   -1,   -1,   -1,  330,
  331,  288,   -1,  334,   -1,   -1,  337,   -1,  295,  372,
  265,  418,  267,  300,   -1,  270,   -1,  304,   -1,  306,
  275,  308,   -1,   -1,  279,   -1,  313,   -1,   -1,  316,
   -1,  318,   -1,  288,   -1,  322,   -1,   -1,  325,  370,
  295,   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,
  337,  306,   -1,  308,  265,  418,  267,   -1,  313,  270,
   -1,  316,   -1,  318,  275,   -1,   -1,  322,  279,   -1,
  325,   -1,   -1,   -1,   -1,  330,  331,  288,   -1,  334,
   -1,   -1,  337,   -1,  295,   -1,   -1,  418,   -1,  300,
   -1,   -1,   -1,  304,   -1,  306,   -1,   -1,   -1,  265,
   -1,  267,  313,   -1,  270,  316,   -1,  318,   -1,  275,
   -1,  322,   -1,  279,  325,   -1,   -1,  283,   -1,  330,
  331,   -1,  288,  334,   -1,   -1,  337,  293,   -1,  295,
   -1,  418,   -1,   -1,  300,   -1,   -1,   -1,  304,  305,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  316,   -1,  318,  275,   -1,   -1,  322,  279,   -1,   -1,
   -1,   -1,   -1,  418,  330,  331,  288,  265,  334,  267,
   -1,   -1,  270,  295,   -1,   -1,   -1,  275,  300,   -1,
   -1,  279,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  288,   -1,   -1,   -1,  316,   -1,  318,  295,   -1,   -1,
  322,   -1,  300,   -1,   -1,   -1,  304,  418,  330,  331,
   -1,   -1,  334,   -1,  261,  337,   -1,   -1,  316,   -1,
  318,   -1,   -1,   -1,  322,  272,   -1,   -1,   -1,   -1,
  277,   -1,  330,  331,  281,   -1,  334,  284,   -1,  337,
   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,
  297,   -1,  418,   -1,  301,  302,   -1,  261,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,   -1,  277,  321,   -1,  323,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,  335,  336,
   -1,  338,  296,  297,   -1,  342,  418,  301,  302,   -1,
  261,   -1,  263,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,
  418,  368,  369,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,   -1,  297,   -1,  342,   -1,
   -1,  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,
  321,   -1,   -1,  281,  368,  369,  284,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,   -1,   -1,  301,  302,   -1,  261,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,
   -1,  362,  277,  321,   -1,  323,  281,  368,  369,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  296,  297,   -1,  342,   -1,  301,  302,  261,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,   -1,
  368,  284,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  297,   -1,  261,  342,   -1,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,  362,  321,  284,
   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  297,  336,  261,  338,  263,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,
   -1,  364,  365,   -1,   -1,  368,   -1,   -1,  333,   -1,
  297,  336,  261,  338,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  284,   -1,  362,   -1,  364,
  365,   -1,  261,  368,  263,   -1,  333,   -1,  297,  336,
   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,  362,   -1,   -1,  297,   -1,
   -1,  368,  261,  302,  333,   -1,   -1,  336,  307,  338,
  309,  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  261,  362,  333,  364,  365,  336,  297,  338,
   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,
   -1,   -1,  321,  362,   -1,   -1,   -1,   -1,  297,   -1,
   -1,   -1,   -1,  302,  333,   -1,   -1,  336,  307,  338,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,  333,   -1,   -1,  336,   -1,  338,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,
  };

#line 6976 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			if (report.Errors == 0)
				report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;
	
	// Avoid duplicit error message after unterminated string literals
	if (token == Token.LITERAL && lexer.Location.Column == 0)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
