﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.SCMImporter.Models.Deps
{
    [Table("D_TFS_Deps_Members")]
    class Member
    {
        public enum Types
        {
            Class = 0,
            Struct = 1,
            Enum = 2,
            Interface = 3,
            Constructor = 4,
            Method = 5,
            Property = 6,
        }

        [PrimaryKey, AutoIncrement]
        public int ID { get; set; }

        [ForeignKey(typeof(File), OnDelete = "cascade")]
        public int? File { get; set; }

        [Text]
        public string Namespace { get; set; }

        [Text]
        public string Class { get; set; }

        [Text]
        public string Name { get; set; }

        // Marker that specified the solution this memberis specified in.
        // Not strictly necessary since this may be queried from the file
        // relation, however storing it inline is much simpler.
        [ForeignKey(typeof(Solution), OnDelete = "cascade")]
        public int Solution { get; set; }

        public string FullName
        {
            get { return string.Format("{0}.{1}.{2}", Namespace, Class, Name ?? "").Trim('.'); }
        }

        public Types Type { get; set; }
    }
}
