import wx
import SocketServer
import socket
import sys
import traceback
import threading
from ctypes import *
from ctypes.wintypes import *
import struct, array
from MExceptions import *

		
class TWmCopyDataServer:
	WM_COPYDATA = 0x4A
	GWL_WNDPROC = (-4)
	def __init__(self, name, target=None):
		self.windowname = name
		self.target = None
		self.frame = wx.Frame( None, -1, self.windowname)
		self.listeninghwnd = None
		self.hwnd = self.frame.GetHandle() 
		WNDPROC = WINFUNCTYPE(c_long, HWND, UINT, WPARAM, LPARAM)
		self.func = WNDPROC(TWmCopyDataServer.WndProc)
		TWmCopyDataServer.oldWndProc = windll.user32.SetWindowLongA(
				 self.hwnd,
				 TWmCopyDataServer.GWL_WNDPROC,
				 self.func
		)
		
	def close(self):
		self.Close()
	
	def Close(self):
		self.frame.Destroy()

	@classmethod
	def OnMessage(cls, msg):
		print "unbound WM_COPYDATA: ", msg
		
	@staticmethod
	def WndProc(hwnd, msg, wParam, lParam):
		if msg == TWmCopyDataServer.WM_COPYDATA: 
			#get the struct-string from the memory address
			structure = string_at( lParam, 12 )

			#unpack the data
			data = struct.unpack("IIP", structure)
			unused, str_len, str_adr = data

			#and finally get the real string from the memory
			my_string = string_at( str_adr, str_len )
			
			TWmCopyDataServer.OnMessage(my_string)
		return windll.user32.CallWindowProcA( TWmCopyDataServer.oldWndProc, hwnd, msg, wParam, lParam )
	
	def setListeningHwnd(self, hwnd):
		self.listeninghwnd = hwnd
		
	def sendMessageToListener(self, message):
		self.sendMessage(self.target, message)
		
	def sendMessage(self, listener, message):
		#if listener == None:
		# Get the hwnd of the listening window
		#	listener = "SolidSX_WM_COPYDATA_" + ("client" if self.type == "server" else "server")
		#listener = "SolidSourceLicenseClient_
		if self.listeninghwnd != None:
			listeninghwnd = self.listeninghwnd
		else:
			listeninghwnd = windll.user32.FindWindowA(None, listener)
			if listeninghwnd == 0:
				raise Exception("Listening process '%s' not found while sending message '%s'" % (listener,message) )
		
		#create a char array from the string
		my_data = array.array( 'c', message )

		#get the memory address to the array
		data_ad, data_len = my_data.buffer_info()

		#create a struct with length and address to the data
		my_struct = array.array( 'c',  struct.pack( "IIP", data_len, data_len, data_ad ) )

		#and make a pointer to it
		struct_ad = my_struct.buffer_info()[0]

		#now send it to the hWnd
		self.response = None
		#print "SendMessage", message, "to", self.listeninghwnd
		### PostMessageA is vista only
		result = windll.user32.SendMessageA(
				 self.listeninghwnd,
				 TWmCopyDataServer.WM_COPYDATA ,
				 0 ,
				 struct_ad )
		if result != 0:
			raise Exception("Error while sending message '%s' to %i: %i" % (message,self.listeninghwnd,result,) )
		
			
		
	def stop(self):
		self.frame.Destroy()

