;NSIS Modern User Interface version 1.70

;Include Modern UI
  !include "MUI.nsh"
  !include "winver.nsh"

;=================================================================
;General
;=================================================================

  ;Name and file
  Name "SolidSTA v1.5"
  OutFile "SolidSTA_install.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\SolidSource\SolidSTA"

  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\SolidSource\SolidSTA" ""

 !define SRCDIR "..\"

  ;SetCompressor lzma

;=================================================================
;Pages
;=================================================================

  !define MUI_WELCOMEFINISHPAGE_BITMAP logo.bmp


  !insertmacro MUI_PAGE_WELCOME
  !define MUI_LICENSEPAGE_CHECKBOX
  !insertmacro MUI_PAGE_LICENSE "EULA.rtf"
  !insertmacro MUI_PAGE_COMPONENTS
  !define MUI_PAGE_CUSTOMFUNCTION_PRE DirectoryPre
  !insertmacro MUI_PAGE_DIRECTORY

  Function DirectoryPre
        ${GetWindowsVersion} $R0
        StrCmp $R0 "Vista" ChangeDir
        StrCmp $R0 "7" ChangeDir
        Goto DontChangeDir
        ChangeDir:
        StrCpy $INSTDIR "C:\SolidSTA"
        MessageBox MB_OK|MB_ICONINFORMATION "Please do not install SolidSTA in a folder under 'Program Files'. On Windows Vista and Windows 7, this will make SolidSTA function incorrectly."
        DontChangeDir:
  FunctionEnd
  
  !insertmacro MUI_PAGE_INSTFILES
  !define MUI_FINISHPAGE_RUN SolidSTA
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH


;=================================================================
;Languages
;=================================================================

  !insertmacro MUI_LANGUAGE "English"

;=================================================================
;Installer Sections
;=================================================================
  InstType "Minimal"
  InstType "Full"

;----------------------------------------------------- Program files ---
Section "Program files" ProgramFiles

  SectionIn 1 2 RO

  SetOutPath "$INSTDIR"
  File "${SRCDIR}\dist\*.*"

  SetOutPath "$INSTDIR\PyOpenGL-3.0.1a3"
  File /r "${SRCDIR}\dist\PyOpenGL-3.0.1a3\*.*"

  SetOutPath "$INSTDIR\doc"
  File /r "${SRCDIR}\dist\doc\*.*"

  SetOutPath "$INSTDIR\cfg"
  File /r "${SRCDIR}\dist\cfg\*.*"

  ;SetOutPath "$INSTDIR\pacparser"
  ;File /r "${SRCDIR}\dist\pacparser\*.*"

  SetOutPath "$INSTDIR\support"
  File /r "${SRCDIR}\dist\support\*.*"
  
  SetOutPath "$INSTDIR\sta_plugins"
  File /r "${SRCDIR}\dist\sta_plugins\*.*"
  
  SetOutPath "$INSTDIR\data"
  File /r "${SRCDIR}\dist\data\*.*"

  SetOutPath "$INSTDIR\support"
  File "${SRCDIR}\platforms\win32\support\vcredist_x86.exe"

  SetOutPath "$INSTDIR"

  ;GLUT library
  IfFileExists "$SYSDIR\glu32.dll" +2 0
    File "${SRCDIR}\platforms\win32\dependencies\glut\glu32.dll"

  IfFileExists "$SYSDIR\glut.dll" +2 0
    File "${SRCDIR}\platforms\win32\dependencies\glut\glut.dll"

  IfFileExists "$SYSDIR\glut32.dll" +2 0
    File "${SRCDIR}\platforms\win32\dependencies\glut\glut32.dll"

  WriteRegStr HKCU "Software\SolidSource\SolidSTA" "" $INSTDIR  ;Store installation folder
  WriteUninstaller "$INSTDIR\Uninstall.exe"        ;Create uninstaller

  CreateDirectory "$SMPROGRAMS\SolidSource\SolidSTA"
  CreateShortCut "$SMPROGRAMS\SolidSource\SolidSTA\SolidSTA.lnk" "$INSTDIR\SolidSTA.exe" \
  "" "" "" SW_SHOWNORMAL "ALT|CTRL|F11" "Software evolution analysis tool"

  CreateShortCut "$SMPROGRAMS\SolidSource\SolidSTA\SolidSTA Manual.lnk" "$INSTDIR\doc\manual_EN.pdf" \
  "" "" "" SW_SHOWNORMAL "" "User manual for SolidSTA"
  
  CreateShortCut "$SMPROGRAMS\SolidSource\SolidSTA\Uninstall SolidSTA.lnk" "$INSTDIR\Uninstall.exe" \
  "" "" "" SW_SHOWNORMAL "" "Remove SolidSTA from this computer"
  
  ;--- MS libraries
  ExecWait '"$INSTDIR\support\vcredist_x86.exe" /q' $0
  Delete $INSTDIR\support\vcredist_x86.exe

SectionEnd

;-------------------------------------------------- Sample Files
;SectionGroup /e "Samples" SampleFiles

;Section "FreeDesktop" Sample1

;  SectionIn 2
;  SetOutPath "$INSTDIR\data\anoncvs_freedesktop_org_cvs_xlibsXrender"
;   File /r "${SRCDIR}\data\anoncvs_freedesktop_org_cvs_xlibsXrender\*.*"
;  SetOutPath "$INSTDIR"

;SectionEnd

;SectionGroupEnd

;=================================================================
;Descriptions
;=================================================================

  ;Language strings
  LangString DESC_ProgramFiles ${LANG_ENGLISH} "The SolidSTA core functionality."
  LangString DESC_SampleFiles ${LANG_ENGLISH} "Sample data files"
    LangString DESC_Sample1 ${LANG_ENGLISH} "A small project (28 files x 5 years)"


  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${ProgramFiles} $(DESC_ProgramFiles)
;    !insertmacro MUI_DESCRIPTION_TEXT ${SampleFiles} $(DESC_SampleFiles)
;        !insertmacro MUI_DESCRIPTION_TEXT ${Sample1} $(DESC_Sample1)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

;=================================================================
;Uninstaller Section
;=================================================================

Section "Uninstall"

  Delete /REBOOTOK "$INSTDIR\*.*"
  RMDir /r /REBOOTOK "$INSTDIR\doc"
  RMDir /r /REBOOTOK "$INSTDIR\cfg"
  RMDir /r /REBOOTOK "$INSTDIR\support"
  RMDir /r /REBOOTOK "$INSTDIR\sta_plugins"
  RMDir /r /REBOOTOK "$INSTDIR\PyOpenGL-3.0.0a5-py2.5.egg"

  RMDir /r "$SMPROGRAMS\SolidSource\SolidSTA"

  DeleteRegKey /ifempty HKCU "Software\SolidSource\SolidSTA"

SectionEnd

;=================================================================
