import sys
import os

from cx_Freeze import setup, hooks, Executable

def _load_OpenGL(finder, module):
   
   #OpenGL >= 3.0.0 is ctypes and setuptools based. Therefore, a plethora of
   #modules are missed by the finder. So force inclusion of them all.
   
   import OpenGL

   version = -1
   try:
      version = int(OpenGL.version.__version__.split(".")[0])
   except:
      pass

   if version >= 3:
      basedir, sep, basemod = module.path[0].rpartition(os.sep)
      for root, dirs, files in os.walk(module.path[0]):
         package = root.replace(basedir, "", 1).strip(sep).replace(sep, ".")
         if package != "OpenGL.tests": # ignore the OpenGL.tests package
            finder.IncludePackage(package)

hooks.load_OpenGL = _load_OpenGL
sys.path.append('./sta_extern')

setup(
        name = "SolidTA",
        version = "1.0",
        description = "Solid Trend Analyzer",
        executables = [Executable("SolidTA.py",includes=['cushions.py','throbber.py'])])
