#*****************************************************************************************
# Name			: Debugging Activity
# File			: pextDebugs.py
# Description	: A plugin for visualizing acquired debugging activity information.
#				  Such information could be aquired for example using the mextBugzilla.py plugin.
# Version		: 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

#------------------------------------------------------------ Global imports ---
import wx
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *

import pysqlite2.dbapi2 as sqlite

import types

#------------------------------------------------------------- Local imports ---
import sta_globals
import sta_plugin
import sta_utils
import sta_gl_list
import sta_gl_mixerunit

#===============================================================================
#					                        Overwriting
#===============================================================================
#------------------------------------------------- Sort on significance ---
def MenuSortOnSignificance(self, event):

        l_lsSeverities = []
        for i in self.lItems:
         l_lsSeverities.append(i.sName)
        l_lsReference = ['enhancement','trivial','minor','normal','major','critical','blocker']
        l_bSw = True
        for i in l_lsReference:
         if i not in l_lsSeverities:
            l_bSw = False
            break
        if l_bSw:
         l_lsSeverities = l_lsReference

        self.lItems.sort(cmp=lambda x,y: cmp(l_lsSeverities.index(x.sName),l_lsSeverities.index(y.sName)))
                                                               # Sort elements on name
        l_sSelected = self.GetSelections()
        self.dItems = {}					# Refresh index list
        j = 0
        for i in self.lItems:
           self.dItems[i.sName] = j
           j = j+1
        self.DeselectAll()					# Preserve the selection
        for i in l_sSelected:
            self.SelectName(i)

        self.Update()						# Refresh display
        self.Refresh()
#===============================================================================
#                                                         Debug activity plugin
#===============================================================================
class Plugin(sta_plugin.Plugin):

   def __init__(self,*args, **kwds):
      sta_plugin.Plugin.__init__(self,*args, **kwds)
      self.sClass                  = 'pextDebugs' # Name of the plugin file
      self.sName                   = 'Debuging activity'     # Name to display in a list
      self.sVersion                = '1.0'         # Version
      self.sMetricID				= 'BGZL'

      self.sTable1                 = 'D_SS2007010302'  # Name of the table where metric is stored
      self.sTable2                 = 'M_SS2007010301'  # Name of the table where metric is stored
      self.lTables.append(self.sTable1)			# Append to this list all tables that are used
      self.lTables.append(self.sTable2)

      #----------------------------------------------------- Specific processing

      self.dSeverity               = {}  # Severity values
      self.lBugSeverityColors      = []  # Colors for GUI list items

#-------------------------------------------------------------------------------
#                                                                 Filter GUI
#-------------------------------------------------------------------------------

#----------------------------------------------------------------- Build GUI ---
   def buildFilterGUI(self,pMasterGUI):

      self.cGUIMaster = pMasterGUI

      self.cSizer = wx.BoxSizer(wx.VERTICAL)
      l_cConfigSizer = wx.BoxSizer(wx.HORIZONTAL)

      l_cLabelSizer = wx.BoxSizer(wx.HORIZONTAL)
      l_sLabel = wx.StaticText(pMasterGUI.project_filters, -1, '  '+self.sName)
      self.g_txtMetric = wx.StaticText(pMasterGUI.project_filters, -1, style = wx.ALIGN_RIGHT )
      l_cLabelSizer.Add(l_sLabel, 0, wx.ADJUST_MINSIZE, 0)
      l_cLabelSizer.Add(self.g_txtMetric, 0, wx.ALIGN_RIGHT, 0)

      self.cGUIList = sta_gl_list.wxColorCheckListBox(self.sName,self.sClass,pMasterGUI.project_filters, style=wx.BORDER_SUNKEN|wx.LB_MULTIPLE|wx.LB_SORT)
      self.cGUIList.lObservers.append(self)

      self.cGUIList.MenuSortAlphabetically = types.MethodType(MenuSortOnSignificance,self.cGUIList,sta_gl_list.wxColorCheckListBox)
      self.cGUIList.Unbind(wx.EVT_MENU, id=201)
      self.cGUIList.Bind(wx.EVT_MENU, self.cGUIList.MenuSortAlphabetically, id=201)

      self.cGUIList.cMenu.SetLabel(201,'Sort on significance')

      self.cGUIList.AddMetric("# versions",self.MetricNumberOfVersions)

      self.cGUIList.Bind(wx.EVT_LISTBOX,self.cbListSelect)

      self.cSizer.Add(l_cLabelSizer, 0, wx.EXPAND, 0)
      self.cSizer.Add(self.cGUIList, 1, wx.EXPAND|wx.ADJUST_MINSIZE)
      pMasterGUI.cListsSizer_Project.Add(self.cSizer, 0, wx.EXPAND, 0)

      self.cGUIList.SetMinSize((160,-1))

      self.showFilterGUI(False)
      self.doBindings()

#-------------------------------------------------------------------------------
#						         Filter GUI callback
#-------------------------------------------------------------------------------

   def cbListSelect_aux(self, files):

      if len(self.lIdx) == 0:
        for i in files:
           for j in i.lRevs:
               try:
                  l_lDebug= j.lValues[self.sMetricID]
                  if len(l_lDebug) == 0:
                     j.lValues[self.sClass] = -1
                  elif len(l_lDebug) > 1:
                     j.lValues[self.sClass] = -2
                  else:
                     j.lValues[self.sClass] = l_lDebug[0]
               except:
                  j.lValues[self.sClass]=-1
      else:
        for i in files:
           for j in i.lRevs:
               try:
                  j.lValues[self.sClass] = -1
                  l_lDebug= j.lValues[self.sMetricID]
                  for k in l_lDebug:
                     if k in self.lIdx:
                        if j.lValues[self.sClass] != -1:
                           j.lValues[self.sClass] = -2
                        else:
                           j.lValues[self.sClass] = k
               except:
                  j.lValues[self.sClass]=-1

   def getSelectedIndexes(self):
      l_lsSeverity = self.cGUIList.GetSelections()
      self.clearSelection()
      for i in l_lsSeverity:
         self.lIdx.append(self.dSeverity[i])
      self.bSelected = len(self.lIdx)>0

#-------------------------------------------------------------------------------
#						            Filter GUI metrics
#-------------------------------------------------------------------------------
#--------------------------------------------------------- Number of commits ---
   def MetricNumberOfVersions(self,p_sName):

      l_iValue = self.dSeverity[p_sName]
      l_iNr = 0

      for i in sta_globals.lSelectedFiles:
         for j in i.lRevs:
            if l_iValue in j.lValues[self.sMetricID]:
               l_iNr = l_iNr+1
      return l_iNr

#-------------------------------------------------------------------------------
#                                                                Data management
#-------------------------------------------------------------------------------
#--------------------------------------------------------------- Load metric ---
   def loadMetric(self):

      l_sDBPath = sta_globals.cSTAPrj.storagePath()+"/history.db"

      #---------------------------- Check existance of data ---
      if not sta_utils.isValidDB(l_sDBPath):
         print 'DATA: no history information found'
         return

      cDB = sqlite.connect(l_sDBPath)
      cCursorDB = cDB.cursor()

      if not sta_utils.isValidTable(cCursorDB,self.sTable1):
         print 'DATA: no debuging activity information found (1)'
         cCursorDB.close()
         cDB.close()
         return

      if not sta_utils.isValidTable(cCursorDB,self.sTable2):
         print 'DATA: no debuging activity information found (2)'
         cCursorDB.close()
         cDB.close()
         return

      #------------------------------------ Load data table ---
      sCmd = "select distinct Severity from "+self.sTable1
      cCursorDB.execute(sCmd)
      l_lsSeverities = []
      for i in cCursorDB:
         l_lsSeverities.append(i[0])

      #--------- Look for reference lists ---
      l_lsReference = ['enhancement','trivial','minor','normal','major','critical','blocker']
      l_bSw = True
      for i in l_lsReference:
         if i not in l_lsSeverities:
            l_bSw = False
            break
      if l_bSw:
         l_lsSeverities = l_lsReference

      #--------------- Append info to GUI ---
      self.lBugSeverityColors = []
      l_iLen = len(l_lsSeverities)
      for i in range(l_iLen):
         self.lBugSeverityColors.append(sta_utils.getRainbowColor(float(i+1)/l_iLen))
      for i in range(l_iLen,10):
         self.lBugSeverityColors.append((0.75,0.75,0.75))
      self.cGUIList.SetData(self.lBugSeverityColors)

      l_iIdx = 0
      for i in l_lsSeverities:
         self.cGUIList.Append(i,l_iIdx)
         self.lData.append(l_iIdx)
         self.dSeverity[i] = l_iIdx
         l_iIdx = l_iIdx + 1

      l_dBugs = {}
      sCmd = "select ID,Severity from "+self.sTable1
      cCursorDB.execute(sCmd)
      for i in cCursorDB:
         l_dBugs[i[0]] = self.dSeverity[i[1]]

      #--------------------------------- Load version table ---
      l_lMetric = {}
      sCmd = "select ID,Buglist from "+self.sTable2
      cCursorDB.execute(sCmd)
      for i in cCursorDB:
         l_lsBugs = i[1].split(' ')
         l_liBugs = []
         for j in l_lsBugs:
            if j != '':
               l_liBugs.append(l_dBugs[int(j)])
         l_lMetric[i[0]]=l_liBugs

      #-------------------------------------- Assign values ---
      self.clearSelection()

      for i in sta_globals.lFiles:
         for j in i.lRevs:
            try:
               l_lDebug= l_lMetric[j.iDBid]
               j.lValues[self.sMetricID]=l_lDebug
               if len(l_lDebug) == 0:
                  j.lValues[self.sClass] = -1
               elif len(l_lDebug) > 1:
                  j.lValues[self.sClass] = -2
               else:
                  j.lValues[self.sClass] = l_lDebug[0]

            except:
               j.lValues[self.sMetricID]= []
               j.lValues[self.sClass]= -1
      l_lMetric = {}

      cCursorDB.close()
      cDB.close()

#===============================================================================
#						Authors filter mixer unit
#===============================================================================
class MixerUnit(sta_gl_mixerunit.MixerUnit):

	def __init__(self, *args, **kwds):
		sta_gl_mixerunit.MixerUnit.__init__(self, *args, **kwds)

		self.iAttrType		= 0
		self.iDrawType		= 0
