'''OpenGL extension EXT.convolution

Overview (from the spec)
	
	This extension defines 1 and 2 dimensional convolution operations
	at a fixed location in the pixel transfer process.  Thus pixel drawing,
	reading, and copying, as well as texture image definition, are all
	candidates for convolution.  The convolution kernels are themselves
	treated as 1 and 2 dimensional images, which can be loaded from
	application memory or from the framebuffer.
	
	This extension is designed to accommodate 3D convolution, but the
	API is left for a future extension.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/convolution.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_convolution'
GL_CONVOLUTION_1D_EXT = constant.Constant( 'GL_CONVOLUTION_1D_EXT', 0x8010 )
glget.addGLGetConstant( GL_CONVOLUTION_1D_EXT, (1,) )
GL_CONVOLUTION_2D_EXT = constant.Constant( 'GL_CONVOLUTION_2D_EXT', 0x8011 )
glget.addGLGetConstant( GL_CONVOLUTION_2D_EXT, (1,) )
GL_SEPARABLE_2D_EXT = constant.Constant( 'GL_SEPARABLE_2D_EXT', 0x8012 )
glget.addGLGetConstant( GL_SEPARABLE_2D_EXT, (1,) )
GL_CONVOLUTION_BORDER_MODE_EXT = constant.Constant( 'GL_CONVOLUTION_BORDER_MODE_EXT', 0x8013 )
GL_CONVOLUTION_FILTER_SCALE_EXT = constant.Constant( 'GL_CONVOLUTION_FILTER_SCALE_EXT', 0x8014 )
GL_CONVOLUTION_FILTER_BIAS_EXT = constant.Constant( 'GL_CONVOLUTION_FILTER_BIAS_EXT', 0x8015 )
GL_REDUCE_EXT = constant.Constant( 'GL_REDUCE_EXT', 0x8016 )
GL_CONVOLUTION_FORMAT_EXT = constant.Constant( 'GL_CONVOLUTION_FORMAT_EXT', 0x8017 )
GL_CONVOLUTION_WIDTH_EXT = constant.Constant( 'GL_CONVOLUTION_WIDTH_EXT', 0x8018 )
GL_CONVOLUTION_HEIGHT_EXT = constant.Constant( 'GL_CONVOLUTION_HEIGHT_EXT', 0x8019 )
GL_MAX_CONVOLUTION_WIDTH_EXT = constant.Constant( 'GL_MAX_CONVOLUTION_WIDTH_EXT', 0x801A )
GL_MAX_CONVOLUTION_HEIGHT_EXT = constant.Constant( 'GL_MAX_CONVOLUTION_HEIGHT_EXT', 0x801B )
GL_POST_CONVOLUTION_RED_SCALE_EXT = constant.Constant( 'GL_POST_CONVOLUTION_RED_SCALE_EXT', 0x801C )
glget.addGLGetConstant( GL_POST_CONVOLUTION_RED_SCALE_EXT, (1,) )
GL_POST_CONVOLUTION_GREEN_SCALE_EXT = constant.Constant( 'GL_POST_CONVOLUTION_GREEN_SCALE_EXT', 0x801D )
glget.addGLGetConstant( GL_POST_CONVOLUTION_GREEN_SCALE_EXT, (1,) )
GL_POST_CONVOLUTION_BLUE_SCALE_EXT = constant.Constant( 'GL_POST_CONVOLUTION_BLUE_SCALE_EXT', 0x801E )
glget.addGLGetConstant( GL_POST_CONVOLUTION_BLUE_SCALE_EXT, (1,) )
GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = constant.Constant( 'GL_POST_CONVOLUTION_ALPHA_SCALE_EXT', 0x801F )
glget.addGLGetConstant( GL_POST_CONVOLUTION_ALPHA_SCALE_EXT, (1,) )
GL_POST_CONVOLUTION_RED_BIAS_EXT = constant.Constant( 'GL_POST_CONVOLUTION_RED_BIAS_EXT', 0x8020 )
glget.addGLGetConstant( GL_POST_CONVOLUTION_RED_BIAS_EXT, (1,) )
GL_POST_CONVOLUTION_GREEN_BIAS_EXT = constant.Constant( 'GL_POST_CONVOLUTION_GREEN_BIAS_EXT', 0x8021 )
glget.addGLGetConstant( GL_POST_CONVOLUTION_GREEN_BIAS_EXT, (1,) )
GL_POST_CONVOLUTION_BLUE_BIAS_EXT = constant.Constant( 'GL_POST_CONVOLUTION_BLUE_BIAS_EXT', 0x8022 )
glget.addGLGetConstant( GL_POST_CONVOLUTION_BLUE_BIAS_EXT, (1,) )
GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = constant.Constant( 'GL_POST_CONVOLUTION_ALPHA_BIAS_EXT', 0x8023 )
glget.addGLGetConstant( GL_POST_CONVOLUTION_ALPHA_BIAS_EXT, (1,) )
glConvolutionFilter1DEXT = platform.createExtensionFunction( 
	'glConvolutionFilter1DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLsizei, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glConvolutionFilter1DEXT( GLenum(target), GLenum(internalformat), GLsizei(width), GLenum(format), GLenum(type), c_void_p(image) ) -> None',
	argNames = ('target', 'internalformat', 'width', 'format', 'type', 'image',),
)

glConvolutionFilter2DEXT = platform.createExtensionFunction( 
	'glConvolutionFilter2DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glConvolutionFilter2DEXT( GLenum(target), GLenum(internalformat), GLsizei(width), GLsizei(height), GLenum(format), GLenum(type), c_void_p(image) ) -> None',
	argNames = ('target', 'internalformat', 'width', 'height', 'format', 'type', 'image',),
)

glConvolutionParameterfEXT = platform.createExtensionFunction( 
	'glConvolutionParameterfEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLfloat,),
	doc = 'glConvolutionParameterfEXT( GLenum(target), GLenum(pname), GLfloat(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glConvolutionParameterfvEXT = platform.createExtensionFunction( 
	'glConvolutionParameterfvEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glConvolutionParameterfvEXT( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glConvolutionParameteriEXT = platform.createExtensionFunction( 
	'glConvolutionParameteriEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLint,),
	doc = 'glConvolutionParameteriEXT( GLenum(target), GLenum(pname), GLint(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glConvolutionParameterivEXT = platform.createExtensionFunction( 
	'glConvolutionParameterivEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glConvolutionParameterivEXT( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glCopyConvolutionFilter1DEXT = platform.createExtensionFunction( 
	'glCopyConvolutionFilter1DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei,),
	doc = 'glCopyConvolutionFilter1DEXT( GLenum(target), GLenum(internalformat), GLint(x), GLint(y), GLsizei(width) ) -> None',
	argNames = ('target', 'internalformat', 'x', 'y', 'width',),
)

glCopyConvolutionFilter2DEXT = platform.createExtensionFunction( 
	'glCopyConvolutionFilter2DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei,),
	doc = 'glCopyConvolutionFilter2DEXT( GLenum(target), GLenum(internalformat), GLint(x), GLint(y), GLsizei(width), GLsizei(height) ) -> None',
	argNames = ('target', 'internalformat', 'x', 'y', 'width', 'height',),
)

glGetConvolutionFilterEXT = platform.createExtensionFunction( 
	'glGetConvolutionFilterEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLenum, ctypes.c_void_p,),
	doc = 'glGetConvolutionFilterEXT( GLenum(target), GLenum(format), GLenum(type), c_void_p(image) ) -> None',
	argNames = ('target', 'format', 'type', 'image',),
)

glGetConvolutionParameterfvEXT = platform.createExtensionFunction( 
	'glGetConvolutionParameterfvEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetConvolutionParameterfvEXT( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetConvolutionParameterivEXT = platform.createExtensionFunction( 
	'glGetConvolutionParameterivEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glGetConvolutionParameterivEXT( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetSeparableFilterEXT = platform.createExtensionFunction( 
	'glGetSeparableFilterEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLenum, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p,),
	doc = 'glGetSeparableFilterEXT( GLenum(target), GLenum(format), GLenum(type), c_void_p(row), c_void_p(column), c_void_p(span) ) -> None',
	argNames = ('target', 'format', 'type', 'row', 'column', 'span',),
)

glSeparableFilter2DEXT = platform.createExtensionFunction( 
	'glSeparableFilter2DEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLenum, constants.GLenum, ctypes.c_void_p, ctypes.c_void_p,),
	doc = 'glSeparableFilter2DEXT( GLenum(target), GLenum(internalformat), GLsizei(width), GLsizei(height), GLenum(format), GLenum(type), c_void_p(row), c_void_p(column) ) -> None',
	argNames = ('target', 'internalformat', 'width', 'height', 'format', 'type', 'row', 'column',),
)


def glInitConvolutionEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
