
import wx
from wx					import glcanvas
from OpenGL.GL			import *
from OpenGL.GLUT		import *

import sta_globals
from sta_gl_attr		import AttrEvolutionView

#/////////////////////////////////////////////////////////////////////////
#												Custom List element
#/////////////////////////////////////////////////////////////////////////
class CustomElement:
	def __init__(self,sName,*args, **kwds):
		self.sName		 	= sName		# Unique element name : display string
		self.iType			= 0			# Element type (0 - normal, 1 - cluster)
		self.fMetric		= 0			# Associated metric (val - normal, (min,max) - cluster)
		self.lElements		= []		# List or references to enclosed elements for clusters

#/////////////////////////////////////////////////////////////////////////
#												Custom CheckListBox
#/////////////////////////////////////////////////////////////////////////

class wxColorCheckListBox(wx.VListBox):
	def __init__(self,l_sLabel,l_sClass,*args, **kwds):
		wx.VListBox.__init__(self,*args, **kwds)

		self.sLabel			= l_sLabel					# Name of the list
		self.sClass	 		= l_sClass					# name of the filter
		self.cAttrEvolution = 0							# Attribute evolution view
		self.lObservers 	= []						# list of observers
		self.lItems		 	= []						# list of items in the list:
														# (type,name,[list of enclosed values if cluster])
		self.dItems			= {}						# map (item name, current index)
														# type = 0 for normal item, = 1 for cluster item
		self.lColors		= []						# local managed list of color values
		self.dColors		= {}						# map (item name, color index)
		self.lpCompute		= []						# list of metric functions
		self.sMetric		= ''						# Name of the displayed metric

		self.dTranslation	= {}						# When data differs from names

		self.iMetrics		= 0							# number of registered
		self.bShowMetric 	= False						# True if metric is to be displayed
		self.iDisplayedMetric = -1						# The currently displayed metric
		self.fMetricRatio 	= 0							# The ratio with witch the metric was scaled (used for saving)
		self.fMetricReference	= 0						# The reference ratio (enabled when not 0)

		self.iHScrollSize	= 0							# Scroll size on horizontal
		self.iHScrollPos	= 0							# Scroll position on horizontal

		self.SetItemCount(0)
		self.SetSelectionBackground(wx.LIGHT_GREY)

		self.Bind(wx.EVT_RIGHT_DOWN, self.OnRightMouseDown)# intercept right mouse button
		self.Bind(wx.EVT_SCROLLWIN, self.OnScrollWin)	# intercept scroll events


		self.cMenu = wx.Menu("List actions")
		self.cMenu.Append(203,"Choose color")
		self.cMenu.AppendSeparator()
		self.cMenu.AppendCheckItem(214,"Show evolution")
		self.cMenu.Append(219,"Clear selection")
		self.cMenu.Append(218,"Only matched files")
		self.cMenu.AppendSeparator()
		self.cMenu.AppendCheckItem(212,"Marker center")
		self.cMenu.AppendCheckItem(213,"Marker density")
		self.cMenu.AppendSeparator()
		self.cMenu.Append(215,"Save metric")
		if sta_globals.bDebug:
			self.cMenu.Append(216,"Print metric")
		self.cMenu.Append(217,"Save all metrics")
		self.cMenu.AppendSeparator()
		self.cMenu.Append(201,"Sort alphabetically")
		self.cMenu.Append(202,"Sort on ...")

		self.Bind(wx.EVT_MENU, self.MenuSortAlphabetically, id=201)
		self.Bind(wx.EVT_MENU, self.MenuSortOnMetric, id=202)
		self.Bind(wx.EVT_MENU, self.MenuChooseColor, id=203)
		self.Bind(wx.EVT_MENU, self.MenuChooseMarkerCenter, id=212)
		self.Bind(wx.EVT_MENU, self.MenuChooseMarkerDensity, id=213)
		self.Bind(wx.EVT_MENU, self.MenuChooseEvolution, id=214)
		self.Bind(wx.EVT_MENU, self.MenuSaveValues, id=215)
		self.Bind(wx.EVT_MENU, self.MenuPrintValues, id=216)
		self.Bind(wx.EVT_MENU, self.MenuSaveAllMetrics, id=217)
		self.Bind(wx.EVT_MENU, self.MenuClearSelection, id=219)

#=========================================================================
#																Setup
#=========================================================================
	def SetData(self,lColors):
		self.cMenu.SetTitle(self.sLabel+" list")
		self.lColors		= []
		self.lColors.extend(lColors)
		self.dColors		= {}

	def AddMetric(self,sName,pCompute,fReference=0):
		if self.iMetrics == 0:
			self.cMenu.AppendSeparator()
			self.cMenu.Append(1500,"Hide metric")
			self.Bind(wx.EVT_MENU, self.HideMetric, id=1500)

		self.lpCompute.append([pCompute,sName,fReference])
		self.iMetrics = self.iMetrics + 1

		self.cMenu.Append(1500+self.iMetrics,"Show "+sName)
		self.Bind(wx.EVT_MENU, self.ComputeMetric, id=1500+self.iMetrics)

	def SetMetricReference(self,sName,fReference):
		for i in self.lpCompute:
			if (i[1] == sName):
				i[2] = fReference
				break

	def SetUpList(self,p_iNr):
		self.SetItemCount(p_iNr)	# Update item count
		self.lItems = range(p_iNr)
#=========================================================================
#														Construct
#=========================================================================
	#--  Find a nonused color index /cycle through available ones
	def findColor(self,p_iNr):
		iLen = len(self.lColors)
		iColor = p_iNr % iLen
		return iColor

#-------------------------------------------------- Append new element ---
	def Append(self,sItem,sData=''):
		if sItem not in self.dItems.keys():				# Add only unique named elements

			if (sData == ''):							# If data is the same as the text entry
				sData = sItem							# use text entry for choosing the color

			self.dTranslation[sItem] = sData

			l_cElement		= CustomElement(sItem)
			self.lItems.append(l_cElement)				# Add item

			l_iLen = len(self.lItems)
			self.SetItemCount(l_iLen)					# Update item count
			self.dItems[sItem]=l_iLen-1					# Register item index for easy access

			self.dColors[sData] = self.findColor(l_iLen-1)		# Set item color

#---------------------------------------------- Set an index to an item ---
	def SetItem(self,p_iNr,sItem,sData=''):

		if (sData == ''):								# If data is the same as the text entry
			sData = sItem								# use text entry for choosing the color

		self.dTranslation[sItem] = sData

		l_cElement			= CustomElement(sItem)
		self.lItems[p_iNr]  = l_cElement				# Set item item

		l_iColorIndex = p_iNr%(len(self.lColors)-1)
		self.dColors[sData] = l_iColorIndex
														# Set item color
		self.dItems[sItem]=p_iNr						# Register item index for easy access

#------------------------------------------------ Delete named element ---
	def Delete(self,sItem):
		if sItem in self.dItems.keys():
			 l_iIdx = self.dItems[sItem]
			 l_iLen = len(self.lItems)
			 for i in range(l_iIdx,l_iLen):		# Remap indexes to names
				l_sIdx = self.lItems[i].sName
				self.dItems[l_sIdx] = self.dItems[l_sIdx] - 1
			 del self.lItems[l_iIdx]			# Remove element
			 del self.dColors[self.dTranslation[sItem]]	# Remove associated color
			 del self.dItems[sItem]				# Remove associated index
			 self.SetItemCount(l_iLen-1)		# Update item count

		self.Update()
		self.Refresh()

#---------------------------------------------------------- Clear list ---
	def Clear(self):
		self.DeselectAll()
		self.lItems = []						# Delete list
		self.dItems.clear()						# Delete indexes
		self.dColors.clear()					# Delete colors
		self.SetItemCount(0)					# Update item count

#------------------------------------------------------ Create cluster ---
	def Cluster(self):
		#TODO: Get selections and put them in a new cluster
		#TODO: Remap indexes (they have a visual and interaction meaning)
		pass

#=========================================================================
#															Access
#=========================================================================
#----------------------------------------------- Get cluster elemments ---
	def GetClusterElements(self,cItem):
		lResult = []
		if cItem.iType == 0:						# Simple element
			lResult.append(cItem.sName)
		else:										# Cluster element
			for i in cItem.lElements:
				lResult.extend(self.GetClusterEments(i))
		return lResult

#------------------------------------------------ Get selected strings ---
	def GetSelections(self):
		lResult  = []
		lsResult = []

		if self.HasMultipleSelection():
			iIdx, cookie = self.GetFirstSelected()
			while (iIdx != wx.NOT_FOUND):
				lResult.append(iIdx)
				iIdx, cookie = self.GetNextSelected(cookie)
		else:
			iIdx = self.GetSelection()
			if (iIdx > -1):
				lResult.append(iIdx)

		for i in lResult:
			lsResult.extend(self.GetClusterElements(self.lItems[i]))

		return lsResult

#----------------------------------------------- Selection management ---
	def IsSelectedName(self,sName):
		try:
			return self.IsSelected(self.dItems[sName])
		except:
			return False

	def SelectName(self,sName):
		try:
			self.Select(self.dItems[sName])
		except:
			pass

	def DeselectName(self,sName):
		try:
			self.Select(self.dItems[sName],False)
		except:
			pass

#=========================================================================
#															Draw
#=========================================================================
	def OnDrawItem(self, dc, rect, n):

		h = self.OnMeasureItem(n)-4

		#---------------- Metrics ---
		if self.bShowMetric:
			cBrush = wx.Brush(wx.Colour(150,200,220))
			dc.SetBrush(cBrush)
			dc.SetPen(wx.WHITE_PEN)
			fMetric = self.lItems[n].fMetric
			if (fMetric < 0.05) and (fMetric != 0):
				fMetric = 0.05
			if (fMetric > 1):
				fMetric = 1
			l_iStartX = int((1-fMetric)*rect.width/2)
			l_iWidthX = int(fMetric*rect.width/2)
			dc.DrawRectangle(rect.x+rect.width/2-3+l_iStartX,rect.y+2,l_iWidthX,rect.height-4)
		dc.SetBrush(wx.NullBrush)
		dc.SetPen(wx.NullPen)

		#----------------- Labels ---
		l_iTextSize		 = dc.GetTextExtent(self.lItems[n].sName)
		l_iExtraSpace		= (l_iTextSize[0] + h) - rect.width
		if (l_iExtraSpace > self.iHScrollSize):
			self.iHScrollSize = l_iExtraSpace
			self.SetScrollbar(wx.HORIZONTAL,self.iHScrollPos,1,self.iHScrollSize)

		cText = self.GetForegroundColour()
		cRectLabel = wx.Rect(rect.x+12+h - self.iHScrollPos ,rect.y,rect.width,rect.height)
		dc.SetFont(self.GetFont())
		dc.SetTextForeground(cText)
		dc.DrawLabel(self.lItems[n].sName, cRectLabel, wx.ALIGN_LEFT | wx.ALIGN_CENTER_VERTICAL)

		#-------------- Color ID ---
		cBrush = wx.Brush(wx.Colour(255,255,255))
		dc.SetBrush(cBrush)
		dc.SetPen(wx.WHITE_PEN)
		dc.DrawRectangle(0,rect.y+1,h+8,rect.height-2)
		dc.SetBrush(wx.NullBrush)
		dc.SetPen(wx.NullPen)

		icIdx = self.dColors[self.dTranslation[self.lItems[n].sName]]
		cRect = self.lColors[icIdx]
		cR = int(cRect[0]*255)
		cG = int(cRect[1]*255)
		cB = int(cRect[2]*255)

		cBrush = wx.Brush(wx.Colour(cR,cG,cB))
		dc.SetBrush(cBrush)
		dc.SetPen(wx.BLACK_PEN)
		dc.DrawRectangle(5,rect.y+2,h,h)
		dc.SetBrush(wx.NullBrush)
		dc.SetPen(wx.NullPen)
		#----------------------------

	def OnMeasureItem(self, n):
		h = 0
		if n<len(self.lItems):
			w, h = self.GetTextExtent(self.lItems[n].sName)
			h = h + 3
		return h

	def RefreshEX(self,p_bRefreshObservers = True):
		self.Update()							# Refresh display
		self.Refresh()
		if (p_bRefreshObservers):
			for i in self.lObservers:
				i.Refresh()

#=========================================================================
#														Horizontal scroll
#=========================================================================
	def OnScrollWin(self, evt):
		if evt.GetOrientation() == wx.VERTICAL:
			evt.Skip()
		else:
			self.iHScrollPos = evt.GetPosition()
			self.SetScrollbar(wx.HORIZONTAL,self.iHScrollPos,1,self.iHScrollSize)
			self.Refresh()
#=========================================================================
#															Menu
#=========================================================================
	def OnRightMouseDown(self, evt):
		self.PopupMenu(self.cMenu)

#-------------------------------------------------------- Choose color ---
	def MenuChooseColor(self, event):
		l_cDialog = wx.ColourDialog(self)
		l_cDialog.GetColourData().SetChooseFull(True)
		if l_cDialog.ShowModal() == wx.ID_OK:
			l_cData = l_cDialog.GetColourData()
			l_cColour_aux = l_cData.GetColour().Get()
			l_cColour = (float(l_cColour_aux[0]/255),float(l_cColour_aux[1])/255,float(l_cColour_aux[2])/255)

			l_sSelected = self.GetSelections()
			for i in l_sSelected:
				self.lColors[self.dColors[self.dTranslation[i]]] = l_cColour

			#-- Extended refresh
			self.RefreshEX()
			if sta_globals.GUI != 0:
				sta_globals.GUI.RefreshEx()

		l_cDialog.Destroy()
#----------------------------------------------------- Sort operations ---
	def MenuSortAlphabetically(self, event):

		l_sSelected = self.GetSelections()

		self.lItems.sort(cmp=lambda x,y: cmp(x.sName.lower(),y.sName.lower()))

		self.dItems.clear()						# Refresh index list
		j = 0
		for i in self.lItems:
			self.dItems[i.sName] = j
			j = j+1

		self.DeselectAll()						# Preserve the selection
		for i in l_sSelected:
			self.SelectName(i)

		self.RefreshEX(p_bRefreshObservers = False)					# Refresh the display

	def MenuSortOnMetric(self, event):

		l_sSelected = self.GetSelections()

		self.lItems.sort(cmp=lambda x,y: cmp(x.fMetric,y.fMetric))	# Sort elements on metric

		self.dItems.clear()				# Refresh index list
		j = 0
		for i in self.lItems:
			self.dItems[i.sName] = j
			j = j+1

		self.DeselectAll()				# Preserve the selection
		for i in l_sSelected:
			self.SelectName(i)

		self.RefreshEX(p_bRefreshObservers = False)

#------------------------------------------------------ Metric display ---
	def HideMetric(self,event):
		self.bShowMetric = False
		self.sMetric = ''
		self.RefreshEX(p_bRefreshObservers = False)

	def RefreshMetric(self):
		if self.bShowMetric:
			self.DisplayMetric()

	def ComputeMetric(self, event):
		self.iDisplayedMetric  = event.GetId()-1501
		self.DisplayMetric()

	def DisplayMetric(self):

		l_iId  =  self.iDisplayedMetric
		if l_iId < 0:
			return

		self.bShowMetric = True
		self.cMenu.SetLabel(202,"Sort on "+self.lpCompute[l_iId][1])

		#-- Compute appropriate metric
		self.sMetric = self.lpCompute[l_iId][1]
		l_pCompute = self.lpCompute[l_iId][0]
		l_fMax = -1
		for i in self.lItems:
			i.fMetric = l_pCompute(i.sName)
			if i.fMetric > l_fMax:
				l_fMax = i.fMetric

		#--- Normalize metric
		self.fMetricReference = self.lpCompute[l_iId][2]
		if (self.fMetricReference != 0):
			self.fMetricRatio = 1.0 / self.fMetricReference
		else:
			if l_fMax > 0:
				self.fMetricRatio = 1.0 / l_fMax
			else:
				self.fMetricRatio = 0
		for i in self.lItems:
			i.fMetric = i.fMetric*self.fMetricRatio
		#--
		self.RefreshEX(p_bRefreshObservers = False)

#------------------------------------------ Save current metric values ---
	def MenuSaveAllMetrics(self,evt):

		sFile = ''
		l_cFileDialog = wx.FileDialog(self,wildcard='*.csv',style=wx.FD_SAVE)
		if l_cFileDialog.ShowModal() == wx.ID_OK:
			sFile = l_cFileDialog.GetPath()
		l_cFileDialog.Destroy()

		if (sFile != ''):
			try:
				fileHandle = open(sFile,'w')

				for i in self.lItems:
					fileHandle.write(i.sName)
					for j in self.lpCompute:
						fMetric = j[0](i.sName)
						fileHandle.write((",%.2f")%(fMetric,))
					fileHandle.write('\n')

				fileHandle.flush()
				fileHandle.close()
			except:
				dlg = wx.MessageDialog(self,'Values could not be saved!','Error',style=wx.OK|wx.ICON_ERROR)
				dlg.ShowModal()
				dlg.Destroy()

	def MenuSaveValues(self,evt):

		sFile = ''
		l_cFileDialog = wx.FileDialog(self,wildcard='*.csv',style=wx.FD_SAVE)
		if l_cFileDialog.ShowModal() == wx.ID_OK:
			sFile = l_cFileDialog.GetPath()
		l_cFileDialog.Destroy()

		if (sFile != ''):
			try:
				fileHandle = open(sFile,'w')
				for i in self.lItems:
					fileHandle.write(("%s,%.2f\n")%(i.sName, i.fMetric/self.fMetricRatio))
				fileHandle.flush()
				fileHandle.close()
			except:
				dlg = wx.MessageDialog(self,'Values could not be saved!','Error',style=wx.OK|wx.ICON_ERROR)
				dlg.ShowModal()
				dlg.Destroy()

	def MenuPrintValues(self,evt):
		print '-------------------'
		print self.lpCompute[self.iDisplayedMetric][1]
		print '-------------------'
		for i in self.lItems:
			if (i.fMetric != 0):
				print i.sName, i.fMetric/self.fMetricRatio

	def MenuClearSelection(self, event):
		self.SetSelection(wx.NOT_FOUND)

		event = wx.PyCommandEvent(wx.EVT_LISTBOX.typeId, self.GetId())
		wx.PostEvent(self.GetEventHandler(), event)

#-------------------------------------------------- Marker <Management ---
	def MenuChooseMarkerCenter(self, event):
		self.MenuChooseMarker(3)

	def MenuChooseMarkerDensity(self, event):
		self.MenuChooseMarker(4)

	def MenuChooseMarker(self, nr):
		mi = self.cMenu.FindItemById(209+nr)
		if (not mi.IsChecked()):
			mi.Check(False)
			exec("sta_globals.sMarker"+str(nr)+" = ''")
		else:
			sta_globals.GUI.SetPluginMarkers(nr)
			exec("sta_globals.sMarker"+str(nr)+" = self.sClass")
			mi.Check()

		sta_globals.GUI.glCanvas.RefreshEx()
		sta_globals.GUI.glMixerCanvas_Project.RefreshEx()

#-------------------------------------------------------------------------
	def MenuChooseEvolution(self,event):
		mi = self.cMenu.FindItemById(214)
		if (not mi.IsChecked()):
			#mi.Check(False)
			self.lObservers.remove(self.cAttrEvolution)
			del sta_globals.dAttrEvolution[self.sClass]
			self.cAttrEvolution.CleanUp()
			self.cAttrEvolution = 0
		else:
			self.cAttrEvolution = AttrEvolutionView(sta_globals.GUI,self.sClass)
			sta_globals.dAttrEvolution[self.sClass] = self.cAttrEvolution
			self.lObservers.append(self.cAttrEvolution)
			#mi.Check()
			l_bState = sta_globals.GUI.mainFrame.g_toolViews.GetToolState(402)
			if not l_bState:
				sta_globals.GUI.mainFrame.g_toolViews.ToggleTool(402,True)
				sta_globals.GUI.Menu402(0)

