#*****************************************************************************************
# Name          : File Type
# File          : pextExtension.py
# Description   : A plugin for visualizing file type information (based on file extension).
# Version       : 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

#------------------------------------------------------------ Global imports ---
import wx
import os.path
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *
import base64

import pysqlite2.dbapi2 as sqlite

#------------------------------------------------------------- Local imports ---
import sta_globals
import sta_plugin
import sta_utils
import sta_gl_list
import sta_gl_mixerunit

#===============================================================================
#                                                              Extension plugin
#===============================================================================
class Plugin(sta_plugin.Plugin):

   def __init__(self,*args, **kwds):
      sta_plugin.Plugin.__init__(self,*args, **kwds)
      self.sClass                  = 'pextExtension'# Name of the plugin file
      self.sName                   = 'File type'    # Name to display in a list
      self.iMetricType             = 1              # File plugin
      self.sVersion                = '1.0'         # Version
      self.sMetricID                ='EXT'

      self.sTable                  = 'Files'        # Name of the table where metric is stored
      self.lTables.append(self.sTable)

      #----------------------------------------------------- Specific processing

      self.lFileColors = [(1.00, 0.50, 0.50),\
    (0.50, 1.00, 0.50),\
    (0.50, 0.50, 1.00),\
    (1.00, 1.00, 0.50),\
    (1.00, 0.00, 0.00),\
    (1.00, 0.50, 0.00),\
    (0.00, 1.00, 0.00),\
    (0.80, 1.00, 0.00),\
    (1.00, 1.00, 0.00),\
    (0.00, 0.00, 0.00),\
    (1.00, 0.60, 1.00),\
    (0.40, 1.00, 0.80),\
    (0.60, 0.00, 0.20),\
    (0.10, 0.40, 0.10),\
    (0.60, 0.60, 0.80),\
    (0.00, 1.00, 0.50),\
    (0.50, 1.00, 1.00),\
    (0.00, 0.50, 1.00),\
    (1.00, 0.50, 0.75),\
    (0.80, 0.20, 0.20),\
    (1.00, 1.00, 0.00),\
    (0.50, 1.00, 0.00),\
    (0.00, 1.00, 0.25),\
    (0.00, 0.50, 0.75),\
    (0.50, 0.50, 0.75),\
    (1.00, 0.00, 1.00),\
    (0.50, 0.25, 0.25),\
    (1.00, 0.50, 0.25),\
    (0.00, 1.00, 0.00),\
    (0.00, 0.50, 0.50),\
    (1.00, 0.50, 1.00),\
    (0.00, 0.25, 0.50),\
    (0.50, 0.50, 1.00),\
    (0.50, 0.00, 0.25),\
    (1.00, 0.00, 0.50),\
    (0.00, 1.00, 1.00),\
    (0.50, 0.00, 0.00),\
    (1.00, 0.50, 0.00),\
    (0.00, 0.50, 0.00),\
    (0.00, 0.50, 0.25),\
    (0.00, 0.00, 1.00),\
    (0.90, 1.00, 0.80),\
    (0.00, 0.00, 0.62),\
    (0.50, 0.00, 0.50),\
    (0.50, 0.00, 1.00),\
    (0.25, 0.00, 0.00),\
    (0.50, 0.25, 0.00),\
    (0.00, 0.25, 0.00),\
    (0.00, 0.25, 0.25),\
    (0.00, 0.00, 0.50),\
    (0.00, 0.00, 0.25),\
    (0.25, 0.00, 0.25),\
    (0.25, 0.00, 0.50),\
    (1.00, 1.00, 0.50),\
    (0.50, 0.50, 0.00),\
    (0.50, 0.50, 0.25),\
    (0.25, 0.50, 0.50),\
    (0.00, 1.00, 0.50),\
    (0.50, 1.00, 1.00),\
    (0.00, 0.50, 1.00),\
    (1.00, 0.50, 0.75),\
    (0.80, 0.20, 0.20),\
    (1.00, 1.00, 0.00),\
    (0.50, 1.00, 0.00),\
    (0.00, 1.00, 0.25),\
    (0.00, 0.50, 0.75),\
    (0.50, 0.50, 0.75),\
    (1.00, 0.00, 1.00),\
    (0.50, 0.25, 0.25),\
    (1.00, 0.50, 0.25),\
    (0.00, 1.00, 0.00),\
    (0.00, 0.50, 0.50),\
    (1.00, 0.50, 1.00),\
    (0.00, 0.25, 0.50),\
    (0.50, 0.50, 1.00),\
    (0.50, 0.00, 0.25),\
    (1.00, 0.00, 0.50),\
    (0.00, 1.00, 1.00),\
    (0.50, 0.00, 0.00),\
    (1.00, 0.50, 0.00),\
    (0.00, 0.50, 0.00),\
    (0.00, 0.50, 0.25),\
    (0.00, 0.00, 1.00),\
    (0.50, 1.00, 0.50),\
    (0.00, 0.00, 0.62),\
    (0.50, 0.00, 0.50),\
    (0.50, 0.00, 1.00),\
    (0.25, 0.00, 0.00),\
    (0.50, 0.25, 0.00),\
    (0.00, 0.25, 0.00),\
    (0.00, 0.25, 0.25),\
    (0.00, 0.00, 0.50),\
    (0.00, 0.00, 0.25),\
    (0.25, 0.00, 0.25),\
    (0.25, 0.00, 0.50),\
    (1.00, 1.00, 0.50),\
    (0.50, 0.50, 0.00),\
    (0.50, 0.50, 0.25),\
    (0.25, 0.50, 0.50),\
    (0.00, 1.00, 0.50),\
    (0.50, 1.00, 1.00),\
    (0.00, 0.50, 1.00),\
    (1.00, 0.50, 0.75),\
    (0.80, 0.20, 0.20),\
    (1.00, 1.00, 0.00),\
    (0.50, 1.00, 0.00),\
    (0.00, 1.00, 0.25),\
    (0.00, 0.50, 0.75),\
    (0.50, 0.50, 0.75),\
    (1.00, 0.00, 1.00),\
    (0.50, 0.25, 0.25),\
    (1.00, 0.50, 0.25),\
    (0.00, 1.00, 0.00),\
    (0.00, 0.50, 0.50),\
    (1.00, 0.50, 1.00),\
    (0.00, 0.25, 0.50),\
    (0.50, 0.50, 1.00),\
    (0.50, 0.00, 0.25),\
    (1.00, 0.00, 0.50),\
    (0.00, 1.00, 1.00),\
    (0.50, 0.00, 0.00),\
    (1.00, 0.50, 0.00),\
    (0.00, 0.50, 0.00),\
    (0.00, 0.50, 0.25),\
    (0.00, 0.00, 1.00),\
    (0.50, 1.00, 0.50),\
    (0.00, 0.00, 0.62),\
    (0.50, 0.00, 0.50),\
    (0.50, 0.00, 1.00),\
    (0.25, 0.00, 0.00),\
    (0.50, 0.25, 0.00),\
    (0.00, 0.25, 0.00),\
    (0.00, 0.25, 0.25),\
    (0.00, 0.00, 0.50),\
    (0.00, 0.00, 0.25),\
    (0.25, 0.00, 0.25),\
    (0.25, 0.00, 0.50),\
    (1.00, 1.00, 0.50),\
    (0.50, 0.50, 0.00),\
    (0.50, 0.50, 0.25),\
    (0.25, 0.50, 0.50),\
    (0.00, 0.00, 0.00)]

      self.lFileColorsMap = {'cpp':3,\
            'c':3,\
            'cxx':3,\
            'cc':3,\
            'c++':3,\
            'cs':3,\
            'h':2,\
            'hh':2,\
            'hpp':2,\
            'hxx':2,\
            'idl':12,\
            'o':5,\
            'out':5,\
            'dll':5,\
            'exe':5,\
            'so':5,\
            'suo':13,\
            'sln':13,\
            'prj':13,\
            'java':1,\
            'jav':1,\
            'jar':1,\
            'jsp':1,\
            'properties':1,\
            'class':5,\
            'js':12,\
            'pcml':13,\
            'jpx':13,\
            'jst':13,\
            'tcl':12,\
            'py':12,\
            'pl':12,\
            'php':12,\
            'xul':16,\
            'pas':1,\
            'zip':6,\
            'tgz':6,\
            'tar':6,\
            'gz':6,\
            'xml':7,\
            'dtd':7,\
            'sgml':7,\
            'po':7,\
            'gif':8,\
            'jpg':8,\
            'png':8,\
            'bmp':8,\
            'wmf':8,\
            'txt':9,\
            'html':9,\
            'xhtml':9,\
            'htm':9,\
            'css':9,\
            'xsl':9,\
            'pdf':9,\
            'doc':9,\
            'ppt':9,\
            'rtf':9,\
            'sql':11,
            'data':14,\
            'map':14,\
            'csv':14,\
            'in':12,\
            'm4':13,\
            'awk':13,\
            'other':42,\
            'old':141,\
            'sh':13}
#-------------------------------------------------------------------------------
#                                                                 Filter GUI
#-------------------------------------------------------------------------------

#----------------------------------------------------------------- Build GUI ---
   def buildFilterGUI(self,pMasterGUI):

      self.cGUIMaster = pMasterGUI

      self.cSizer = wx.BoxSizer(wx.VERTICAL)

      l_cLabelSizer = wx.BoxSizer(wx.HORIZONTAL)
      l_sLabel = wx.StaticText(pMasterGUI.project_filters, -1, '  '+self.sName)
      self.g_txtMetric = wx.StaticText(pMasterGUI.project_filters, -1, style = wx.ALIGN_RIGHT )
      l_cLabelSizer.Add(l_sLabel, 0, wx.ADJUST_MINSIZE, 0)
      l_cLabelSizer.Add(self.g_txtMetric, 0, wx.ALIGN_RIGHT, 0)

      self.cGUIList = sta_gl_list.wxColorCheckListBox(self.sName,self.sClass,pMasterGUI.project_filters, style=wx.BORDER_SUNKEN|wx.LB_MULTIPLE|wx.LB_SORT)
      self.cGUIList.lObservers.append(self)

      self.cGUIList.cMenu.Enable(212,False)  # Marker center
      self.cGUIList.cMenu.Enable(213,False)  # Marker density

      self.cGUIList.AddMetric("# files",self.MetricFileTypeNumber)

      self.cGUIList.Bind(wx.EVT_LISTBOX,self.cbListSelect)

      self.cSizer.Add(l_cLabelSizer, 0, wx.EXPAND, 0)
      self.cSizer.Add(self.cGUIList, 1, wx.EXPAND|wx.ADJUST_MINSIZE)
      pMasterGUI.cListsSizer_Project.Add(self.cSizer, 0, wx.EXPAND, 0)

      self.cGUIList.SetMinSize((120,-1))

      self.showFilterGUI(False)
      self.doBindings()

#-------------------------------------------------------------------------------
#                                Filter GUI callback
#-------------------------------------------------------------------------------

   def cbListSelect_aux(self, files):
     if len(self.lIdx) == 0:
        for i in files:
            if i.iType == 0:
                l_iIdx = self.lData.index(i.lValues[self.sMetricID])
                i.lValues[self.sClass] = l_iIdx
            else:
                i.lValues[self.sClass] = -1
     else:
        for i in files:
            if i.iType == 0:
                l_iIdx = self.lData.index(i.lValues[self.sMetricID])
                i.lValues[self.sClass] = -1
                if l_iIdx in self.lIdx:
                   i.lValues[self.sClass] = l_iIdx
            else:
                i.lValues[self.sClass] = -1

   def getSelectedIndexes(self):
      l_lsFileT =  self.cGUIList.GetSelections()
      self.clearSelection()
      self.lIdx = sta_utils.getSelectionIndex(l_lsFileT,self.lData)
      self.bSelected = len(self.lIdx)>0


#-------------------------------------------------------------------------------
#                                   Filter GUI metrics
#-------------------------------------------------------------------------------
#---------------------------------------------- Number of files in file type ---
   def MetricFileTypeNumber(self,sName):
        iResult = 0
        for i in sta_globals.lSelectedFiles:
              sExtension = i.lValues[self.sMetricID]
              if (sExtension not in self.lData):
                 sExtension = 'other'
              if sExtension == sName:
                 iResult = iResult + 1
        return (iResult)

#-------------------------------------------------------------------------------
#                                                                Data management
#-------------------------------------------------------------------------------
#--------------------------------------------------------------- Load metric ---
   def loadMetric(self):
      #-------------------------------- Metric values ---
      l_dExtensions = {}
      l_lKnownExtensions = self.lFileColorsMap.keys()
      l_iIdx = 0
      for i in sta_globals.lFiles:
        if i.iType == 0:
            l_sFile = i.sPath
            l_sName,l_sExt = os.path.splitext(l_sFile)
            l_sExt = l_sExt.lower()[1:]
            try:
              if (l_sExt[-1] == '~'):
                 l_sExt = 'old'
            except:
              pass
            if (l_sExt in l_lKnownExtensions):
              l_sType = l_sExt
            else:
              l_sType = 'other'

            self.lData.append(l_sType)
            l_dExtensions[l_sType] = 1
            i.lValues[self.sMetricID]= l_sType
            i.lValues[self.sClass]=self.lData.index(l_sType)

            l_iIdx = l_iIdx + 1
        else:
            i.lValues[self.sMetricID] = -1
            i.lValues[self.sClass] = -1

      #---------------------------------- Data tables ---
      if 'other' not in self.lData:
        self.lData.append('other')

      self.clearSelection()

      #------------------------------------ GUI list ---
      l_lColorList = []
      for i in self.lData:
         l_lColorList.append(self.lFileColors[self.lFileColorsMap[i]-1])
      self.cGUIList.SetData(l_lColorList)

      for i in self.lData:
          self.cGUIList.Append(i)

#===============================================================================
#                       Extension filter mixer unit
#===============================================================================
class MixerUnit(sta_gl_mixerunit.MixerUnit):

    def __init__(self, *args, **kwds):
        sta_gl_mixerunit.MixerUnit.__init__(self, *args, **kwds)

        self.iAttrType      = 1
        self.iDrawType      = 2
