#*****************************************************************************************
# Name 			: Find Text
# File			: pextFind.py
# Description	: A plugin for visualizing occurences of text strings in commit logs.
# Version		: 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

#------------------------------------------------------------ Global imports ---
import wx
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *

import pysqlite2.dbapi2 as sqlite

#------------------------------------------------------------- Local imports ---
import sta_globals
import sta_plugin
import sta_utils
import sta_gl_list
import sta_gl_mixerunit

#===============================================================================
#                                                              Find text plugin
#===============================================================================
class Plugin(sta_plugin.Plugin):

   def __init__(self,*args, **kwds):
      sta_plugin.Plugin.__init__(self,*args, **kwds)
      self.sClass                  = 'pextFind'    # Name of the plugin file
      self.sName                   = 'Find text'   # Name to display in a list
      self.sVersion                = '1.0'         # Version
      self.sMetricID				= 'CMMT'

      self.sTable                  = 'M_SS2007010102' # Name of the table where metric is stored
      self.lTables.append(self.sTable)				# Append to this list all tables that are used

#-------------------------------------------------------------------------------
#                                                                 Filter GUI
#-------------------------------------------------------------------------------

#----------------------------------------------------------------- Build GUI ---
   def buildFilterGUI(self,pMasterGUI):

      self.cGUIMaster = pMasterGUI

      self.cSizer   = wx.BoxSizer(wx.VERTICAL)
      l_cSizer      = wx.BoxSizer(wx.HORIZONTAL)

      l_cLabelSizer = wx.BoxSizer(wx.HORIZONTAL)
      l_sLabel = wx.StaticText(pMasterGUI.project_filters, -1, '  '+self.sName)
      self.g_txtMetric = wx.StaticText(pMasterGUI.project_filters, -1, style = wx.ALIGN_RIGHT )
      l_cLabelSizer.Add(l_sLabel, 0, wx.ADJUST_MINSIZE, 0)
      l_cLabelSizer.Add(self.g_txtMetric, 0, wx.ALIGN_RIGHT, 0)

      self.cGUIList = sta_gl_list.wxColorCheckListBox(self.sName,self.sClass,pMasterGUI.project_filters, style=wx.BORDER_SUNKEN|wx.LB_MULTIPLE|wx.LB_SORT)
      self.cGUIList.lObservers.append(self)

      self.cGUIList.SetData(sta_globals.lIDColors)

      self.g_txtFind        = wx.TextCtrl(pMasterGUI.project_filters, -1, "", style=wx.TE_PROCESS_ENTER)
      self.g_butFindAdd     = wx.Button(pMasterGUI.project_filters, -1, "Add")
      self.g_butFindRemove  = wx.Button(pMasterGUI.project_filters, -1, "Remove")

      self.cSizer.Add(l_cLabelSizer, 0, wx.EXPAND, 0)                       # Title
      self.cSizer.Add(self.cGUIList, 1, wx.EXPAND|wx.ADJUST_MINSIZE)        # List
      self.cSizer.Add(self.g_txtFind, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)    # Search field
      l_cSizer.Add(self.g_butFindAdd, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 2)
                                                                            # Add word button
      l_cSizer.Add(self.g_butFindRemove, 0, wx.LEFT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 2)
                                                                            # Remove word button

      self.cSizer.Add(l_cSizer, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL, 0)
      pMasterGUI.cListsSizer_Project.Add(self.cSizer, 0, wx.EXPAND, 0)

      self.cGUIList.SetMinSize((160,-1))
      self.g_butFindAdd.SetMinSize((-1, 20))
      self.g_butFindRemove.SetMinSize((-1, 20))

      self.cGUIList.Bind(wx.EVT_LISTBOX,self.cbListSelect)
      self.g_butFindAdd.Bind(wx.EVT_BUTTON,self.cbFindAdd)
      self.g_butFindRemove.Bind(wx.EVT_BUTTON,self.cbFindRemove)
      self.g_txtFind.Bind(wx.EVT_TEXT_ENTER,self.cbFindAddDirect)

      self.showFilterGUI(False)
      self.doBindings()

#-------------------------------------------------------------------------------
#						         Filter GUI callback
#-------------------------------------------------------------------------------
   #--------------------------------- Add search word ---
   def cbFindAdd(self,evt):
        l_sFind = self.g_txtFind.GetValue()
        if l_sFind != "":
           self.lData.append(l_sFind)
           self.cGUIList.Append(l_sFind)
           self.g_txtFind.SetValue("")
           self.cGUIList.Refresh()

   def cbFindAddDirect(self,evt):
       self.cbFindAdd(0)

   #------------------------------ Remove search word ---
   def cbFindRemove(self,evt):
        l_lsFind = self.cGUIList.GetSelections()
        for i in l_lsFind:
           self.cGUIList.Delete(i)
           self.lData.remove(i)
        self.cGUIList.DeselectAll()
        self.clearSelection()
        self.cbListSelect_aux(sta_globals.lSelectedFiles)

   #------------------------------------- List select ---
   def cbListSelect_aux(self, files):

     for i in files:
           for j in i.lRevs:
              j.lValues[self.sClass] = -1
              for k in self.lIdx:
                try:
                  if j.lValues[self.sMetricID].find(self.lData[k].lower())>=0:
                      if j.lValues[self.sClass] == -1:
                         j.lValues[self.sClass] = k
                      else:
                         j.lValues[self.sClass] = -2 # red if more strings are in the comment
                except:
                  pass

   def getSelectedIndexes(self):
        l_lsFind = self.cGUIList.GetSelections()
        self.clearSelection()
        self.lIdx = sta_utils.getSelectionIndex(l_lsFind,self.lData)
        self.bSelected = len(self.lIdx)>0

#-------------------------------------------------------------------------------
#                                                                Data management
#-------------------------------------------------------------------------------
#--------------------------------------------------------------- Load metric ---
   def loadMetric(self):
      l_sDBPath = sta_globals.cSTAPrj.storagePath()+"/history.db"

      if not sta_utils.isValidDB(l_sDBPath):
         print 'DATA: no history information found'
         return

      cDB = sqlite.connect(l_sDBPath)
      cCursorDB = cDB.cursor()

      if not sta_utils.isValidTable(cCursorDB,self.sTable):
         print 'DATA: no Comment information found'
         cCursorDB.close()
         cDB.close()
         return

      # Load list of comments
      l_lMetric = {}
      sCmd = "select ID,Name from "+self.sTable
      cCursorDB.execute(sCmd)

      for i in cCursorDB:
          l_lMetric[i[0]]=i[1]

      for i in sta_globals.lFiles:
         for j in i.lRevs:
            #TODO: what if this does not exist
            try:
                l_sComment = l_lMetric[j.iDBid]
                j.lValues[self.sMetricID]=l_sComment.lower()
            except:
                j.lValues[self.sMetricID]='VEA_other'
            j.lValues[self.sClass]=-1

      l_lMetric = {}

      cCursorDB.close()
      cDB.close()

#=========================================================================
#							Text unit
#=========================================================================
class MixerUnit(sta_gl_mixerunit.MixerUnit):

    def __init__(self, *args, **kwds):
	sta_gl_mixerunit.MixerUnit.__init__(self, *args, **kwds)

	self.iAttrType		= 0
	self.iDrawType		= 3
