﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using ICSharpCode.NRefactory.CSharp;
using ICSharpCode.NRefactory.CSharp.Resolver;
using ICSharpCode.NRefactory.Semantics;
using CSharpDeps.Visitors;
using Microsoft.Build.Evaluation;

namespace CSharpDeps
{
    public class Analyzer
    {
        public Scopes.Solution Analyze(string path)
        {
            ProjectCollection.GlobalProjectCollection.UnloadAllProjects();

            try
            {
                return AnalyzeSolution(path);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);

                return null;
            }
        }

        public Scopes.Solution AnalyzeSolution(string path)
        {
            var solution = new Solution(path);
            var results = new Scopes.Solution
            {
                Path = path,
            };

            foreach (var project in solution.Projects)
            {
                var p = new Scopes.Project
                {
                    Path = project.FileName,
                };

                foreach (var file in project.Files)
                {
                    p.AddFile(AnalyzeFile(file));
                }

                results.AddProject(p);
            }

            return results;
        }

        private Scopes.File AnalyzeFile(CSharpFile file)
        {
            var result = new Scopes.File(file.FileName);
            var resolver = new CSharpAstResolver(file.Project.Compilation, file.SyntaxTree, file.UnresolvedTypeSystemForFile);

            file.SyntaxTree.AcceptVisitor(new FileVisitor(resolver, result));

            return result;
        }
    }
}
