﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharpDeps.Scopes
{
    public class Namespace
    {
        public string FullName { get; private set; }

        protected Dictionary<string, Class> classes = new Dictionary<string, Class>();

        public Dictionary<string, Class> Classes
        {
            get { return classes; }
        }

        public Namespace(string fullName)
        {
            FullName = fullName;
        }

        public void AddClass(Class klass)
        {
            if (Classes.ContainsKey(klass.Name))
            {
                Classes[klass.Name].MergeClass(klass);
            }
            else
            {
                Classes[klass.Name] = klass;
            }
        }

        public void MergeNamespace(Namespace ns)
        {
            foreach (Class klass in ns.Classes.Values)
            {
                AddClass(klass);
            }
        }

        public virtual bool IsGlobal()
        {
            return false;
        }
    }

    class GlobalNamespace : Namespace
    {
        public GlobalNamespace()
            : base(string.Empty)
        {

        }

        public override bool IsGlobal()
        {
            return true;
        }
    }
}
