﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpDeps.Scopes;
using ICSharpCode.NRefactory.CSharp.Resolver;
using ICSharpCode.NRefactory.Semantics;
using ICSharpCode.NRefactory.TypeSystem.Implementation;

namespace CSharpDeps.Visitors
{
    class ClassVisitor : ClassContainerVisitor
    {
        protected Class Class { get; set; }

        public ClassVisitor(CSharpAstResolver resolver, Class klass)
            : base(resolver)
        {
            Class = klass;
        }

        public override void VisitTypeDeclaration(TypeDeclaration typeDeclaration)
        {
            var type = TranslateType(typeDeclaration.ClassType);
            var klass = new Class(type, Class.Namespace, Class, typeDeclaration.Name);

            DecorateClass(klass, typeDeclaration);

            VisitChildren(typeDeclaration, new ClassVisitor(Resolver, klass));

            Class.AddChild(klass);
        }

        public override void VisitConstructorDeclaration(ConstructorDeclaration constructorDeclaration)
        {
            var resolved = Resolver.Resolve(constructorDeclaration) as MemberResolveResult;

            if (resolved != null && resolved.Member is DefaultResolvedMethod)
            {
                var member = resolved.Member as DefaultResolvedMethod;

                var method = new Method(Class, string.Format("{0}{1}", member.Name, Method.ParameterInfo(member)));

                constructorDeclaration.AcceptVisitor(new MethodVisitor(Resolver, method));

                Class.AddMethod(method);
            }

            base.VisitConstructorDeclaration(constructorDeclaration);
        }

        public override void VisitMethodDeclaration(MethodDeclaration methodDeclaration)
        {
            var resolved = Resolver.Resolve(methodDeclaration) as MemberResolveResult;

            if (resolved != null && resolved.Member is DefaultResolvedMethod)
            {
                var member = resolved.Member as DefaultResolvedMethod;

                var method = new Method(Class, string.Format("{0}{1}", member.Name, Method.ParameterInfo(member)));

                methodDeclaration.AcceptVisitor(new MethodVisitor(Resolver, method));

                Class.AddMethod(method);
            }

            base.VisitMethodDeclaration(methodDeclaration);
        }

        public override void VisitFieldDeclaration(FieldDeclaration fieldDeclaration)
        {
            foreach (var variable in fieldDeclaration.Variables)
            {
                var r = Resolver.Resolve(variable) as MemberResolveResult;

                if (r != null)
                {
                    Class.AddProperty(r);
                }
            }

            base.VisitFieldDeclaration(fieldDeclaration);
        }

        public override void VisitPropertyDeclaration(PropertyDeclaration propertyDeclaration)
        {
            var r = Resolver.Resolve(propertyDeclaration) as MemberResolveResult;

            if (r != null)
            {
                Class.AddProperty(r);
            }

            base.VisitPropertyDeclaration(propertyDeclaration);
        }
    }
}
