﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpDeps.Scopes;
using ICSharpCode.NRefactory.CSharp.Resolver;

namespace CSharpDeps.Visitors
{
    class FileVisitor : Visitor
    {
        public File File { get; private set; }

        public FileVisitor(CSharpAstResolver resolver, File file)
            : base(resolver)
        {
            File = file;
        }

        public override void VisitSyntaxTree(SyntaxTree syntaxTree)
        {
            var global = new GlobalNamespace();

            syntaxTree.AcceptVisitor(new NamespaceVisitor(Resolver, File, global));

            base.VisitSyntaxTree(syntaxTree);

            if (global.Classes.Count > 0)
            {
                File.AddNamespace(global);
            }
        }
    }
}
