﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using ICSharpCode.NRefactory.CSharp;
using CSharpMetrics.Visitors;
using CFile = CSharpMetrics.Scopes.File;

namespace CSharpMetrics
{
    public class Analyzer
    {
        private CSharpParser Parser
        {
            get { return new CSharpParser(); }
        }

        public CFile Analyze(string path)
        {
            using (var stream = new FileStream(path, FileMode.Open))
            {
                return Analyze(path, stream);
            }
        }

        public CFile Analyze(string name, Stream source)
        {
            var syntaxTree = Parser.Parse(source);

            return Analyze(name, syntaxTree);
        }

        public CFile Analyze(string path, SyntaxTree syntaxTree)
        {
            var file = new CFile(path);
            var visitor = new FileVisitor(file);
            syntaxTree.AcceptVisitor(visitor);

            return file;
        }
    }
}
