﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpMetrics.Scopes;

namespace CSharpMetrics.Visitors
{
    class NamespaceVisitor : Visitor
    {
        public File File { get; private set; }

        public Namespace Namespace { get; private set; }

        protected Stack<Class> Classes = new Stack<Class>();

        public NamespaceVisitor(File file, Namespace ns)
        {
            File = file;
            Namespace = ns;
        }

        public override void VisitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration)
        {
            var ns = new Namespace(namespaceDeclaration.FullName);

            VisitChildren(namespaceDeclaration, new NamespaceVisitor(File, ns));

            File.AddNamespace(ns);
        }

        public override void VisitTypeDeclaration(TypeDeclaration typeDeclaration)
        {
            switch (typeDeclaration.ClassType)
            {
                case ClassType.Class:
                case ClassType.Struct:
                    var klass = new Class(Namespace, null, typeDeclaration.Name);

                    VisitChildren(typeDeclaration, new ClassVisitor(klass));

                    Namespace.AddClass(klass);
                    break;
                case ClassType.Enum:
                case ClassType.Interface:
                    // TODO: Evaluate
                    base.VisitTypeDeclaration(typeDeclaration);
                    break;
            }
        }
    }
}
