﻿using ICSharpCode.NRefactory.CSharp;

namespace CSharpMetrics.Visitors
{
    abstract class Visitor : DepthFirstAstVisitor
    {
        protected int LOC { get; set; }

        protected int CLOC { get; set; }

        protected void VisitChildren(AstNode node, Visitor visitor)
        {
            foreach (var child in node.Children)
            {
                child.AcceptVisitor(visitor);
            }

            visitor.VisitedChildren(node);
        }

        protected override void VisitChildren(AstNode node)
        {
            base.VisitChildren(node);

            this.VisitedChildren(node);
        }

        protected virtual void VisitedChildren(AstNode node)
        {

        }

        public override void VisitComment(Comment comment)
        {
            switch (comment.CommentType)
            {
                case CommentType.Documentation:           // for "///"
                case CommentType.SingleLine:              // for "//"
                    if (comment.StartsLine)
                    {
                        CLOC++;
                    }
                    break;
                case CommentType.MultiLine:               // for "/*"
                case CommentType.MultiLineDocumentation:  // for "/**"
                    if (comment.StartsLine && (comment.NextSibling == null || comment.NextSibling.Role == Roles.NewLine))
                    {
                        var lines = comment.Content.Split('\n').Length;

                        LOC += lines - 1;
                        CLOC += lines;
                    }
                    break;
                case CommentType.InactiveCode:            // for "#if"
                    // TODO: Evaluate
                    break;
            }
            base.VisitComment(comment);
        }

        public override void VisitNewLine(NewLineNode newLineNode)
        {
            if (newLineNode.NextSibling != null && newLineNode.NextSibling.Role != Roles.NewLine)
            {
                LOC++;
                
            }
            // FIXME: this code is never executed...
            System.Console.WriteLine("Lines:" + LOC);

            base.VisitNewLine(newLineNode);
        }
    }
}
