﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.SCMImporter.Models.Size
{
    [Table("D_SS2007010201_2")]
    class Method
    {
        /// <summary>
        /// Version ID of the enclosing file
        /// </summary>
        [ForeignKey(typeof(Version), OnDelete = "cascade")]
        public int ID { get; set; }

        /// <summary>
        /// Method's class
        /// </summary>
        [Text]
        public string Module { get; set; }

        /// <summary>
        /// Method prototype
        /// </summary>
        [Text]
        [Column("Method")]
        public string Prototype { get; set; }

        /// <summary>
        /// Number of parameters
        /// </summary>
        public int SSIZE { get; set; }

        /// <summary>
        /// Lines of code
        /// </summary>
        public int LOC { get; set; }

        /// <summary>
        /// McCabe Complexity
        /// </summary>
        public int MCB { get; set; }

        /// <summary>
        /// Lines of comments
        /// </summary>
        public int COM { get; set; }

        /// <summary>
        /// Number of method invocations
        /// </summary>
        public int INV { get; set; }

        /// <summary>
        /// Structural Complexity (max nesting depth)
        /// </summary>
        public int STC { get; set; }
    }
}
