﻿using System;
using System.Collections.Generic;

namespace SolidTA.SCMImporter
{
    /**
     * Abstract class.
     * Shell for the implemenations of the repository types
     **/
    public abstract class SCMServer
    {
        public enum DeletedState
        {
            NonDeleted,
            Deleted,
            Any
        };
        /** Whether the data should be collected recursivly **/
        public enum RecursionType
        {
            None,
            Full,
        };
        public class VersionSpec
        {
            public static VersionSpec Latest = new VersionSpec(int.MaxValue);

            public int version { get; private set; }

            public VersionSpec(int version)
            {
                this.version = Math.Max(0, version);
            }
            public override string ToString()
            {
                return base.ToString() + ": " + version.ToString();
            }
        };
        public enum RepoOperationMode {
            HORIZONTAL,//the repo is optimized to query singular point in history (commit) with all files
            VERTICAL//the repo is optimized in query the history a singular file
        };


        public abstract void Connect(string url, string directory, string user, string password);
        public abstract string PreparePath(string path);
        public abstract VersionSpec GetFirstVersionAfter(DateTime dt);

        public abstract IEnumerable<ChangeSet> QueryFileHistory(string path, RecursionType recursion, VersionSpec versionFrom, int maxCount, bool includeChanges, bool includeDownloadInfo);
        public abstract Item[] GetItems(string path, VersionSpec version, RecursionType recursion, DeletedState deletedState, Item.ItemType itemType, bool includeDownloadInfo);
        public abstract int GetLatestChangesetId();

        public abstract RepoOperationMode GetRepoMode();
    }
}
