'''OpenGL extension NV.half_float

Overview (from the spec)
	
	This extension introduces a new storage format and data type for
	half-precision (16-bit) floating-point quantities.  The floating-point
	format is very similar to the IEEE single-precision floating-point
	standard, except that it has only 5 exponent bits and 10 mantissa bits.
	Half-precision floats are smaller than full precision floats and provide a
	larger dynamic range than similarly-sized normalized scalar data types.
	
	This extension allows applications to use half-precision floating point
	data when specifying vertices or pixel data.  It adds new commands to
	specify vertex attributes using the new data type, and extends the
	existing vertex array and image specification commands to accept the new
	data type.
	
	This storage format is also used to represent 16-bit components in the
	floating-point frame buffers, as defined in the NV_float_buffer extension.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/half_float.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_half_float'
GL_HALF_FLOAT_NV = constant.Constant( 'GL_HALF_FLOAT_NV', 0x140B )
glVertex2hNV = platform.createExtensionFunction( 
	'glVertex2hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertex2hNV( GLhalfNV(x), GLhalfNV(y) ) -> None',
	argNames = ('x', 'y',),
)

glVertex2hvNV = platform.createExtensionFunction( 
	'glVertex2hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glVertex2hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glVertex3hNV = platform.createExtensionFunction( 
	'glVertex3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertex3hNV( GLhalfNV(x), GLhalfNV(y), GLhalfNV(z) ) -> None',
	argNames = ('x', 'y', 'z',),
)

glVertex3hvNV = platform.createExtensionFunction( 
	'glVertex3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glVertex3hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glVertex4hNV = platform.createExtensionFunction( 
	'glVertex4hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertex4hNV( GLhalfNV(x), GLhalfNV(y), GLhalfNV(z), GLhalfNV(w) ) -> None',
	argNames = ('x', 'y', 'z', 'w',),
)

glVertex4hvNV = platform.createExtensionFunction( 
	'glVertex4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glVertex4hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glNormal3hNV = platform.createExtensionFunction( 
	'glNormal3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glNormal3hNV( GLhalfNV(nx), GLhalfNV(ny), GLhalfNV(nz) ) -> None',
	argNames = ('nx', 'ny', 'nz',),
)

glNormal3hvNV = platform.createExtensionFunction( 
	'glNormal3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glNormal3hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glColor3hNV = platform.createExtensionFunction( 
	'glColor3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glColor3hNV( GLhalfNV(red), GLhalfNV(green), GLhalfNV(blue) ) -> None',
	argNames = ('red', 'green', 'blue',),
)

glColor3hvNV = platform.createExtensionFunction( 
	'glColor3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glColor3hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glColor4hNV = platform.createExtensionFunction( 
	'glColor4hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glColor4hNV( GLhalfNV(red), GLhalfNV(green), GLhalfNV(blue), GLhalfNV(alpha) ) -> None',
	argNames = ('red', 'green', 'blue', 'alpha',),
)

glColor4hvNV = platform.createExtensionFunction( 
	'glColor4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glColor4hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glTexCoord1hNV = platform.createExtensionFunction( 
	'glTexCoord1hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV,),
	doc = 'glTexCoord1hNV( GLhalfNV(s) ) -> None',
	argNames = ('s',),
)

glTexCoord1hvNV = platform.createExtensionFunction( 
	'glTexCoord1hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glTexCoord1hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glTexCoord2hNV = platform.createExtensionFunction( 
	'glTexCoord2hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glTexCoord2hNV( GLhalfNV(s), GLhalfNV(t) ) -> None',
	argNames = ('s', 't',),
)

glTexCoord2hvNV = platform.createExtensionFunction( 
	'glTexCoord2hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glTexCoord2hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glTexCoord3hNV = platform.createExtensionFunction( 
	'glTexCoord3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glTexCoord3hNV( GLhalfNV(s), GLhalfNV(t), GLhalfNV(r) ) -> None',
	argNames = ('s', 't', 'r',),
)

glTexCoord3hvNV = platform.createExtensionFunction( 
	'glTexCoord3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glTexCoord3hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glTexCoord4hNV = platform.createExtensionFunction( 
	'glTexCoord4hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glTexCoord4hNV( GLhalfNV(s), GLhalfNV(t), GLhalfNV(r), GLhalfNV(q) ) -> None',
	argNames = ('s', 't', 'r', 'q',),
)

glTexCoord4hvNV = platform.createExtensionFunction( 
	'glTexCoord4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glTexCoord4hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glMultiTexCoord1hNV = platform.createExtensionFunction( 
	'glMultiTexCoord1hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLhalfNV,),
	doc = 'glMultiTexCoord1hNV( GLenum(target), GLhalfNV(s) ) -> None',
	argNames = ('target', 's',),
)

glMultiTexCoord1hvNV = platform.createExtensionFunction( 
	'glMultiTexCoord1hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLushortArray,),
	doc = 'glMultiTexCoord1hvNV( GLenum(target), GLushortArray(v) ) -> None',
	argNames = ('target', 'v',),
)

glMultiTexCoord2hNV = platform.createExtensionFunction( 
	'glMultiTexCoord2hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glMultiTexCoord2hNV( GLenum(target), GLhalfNV(s), GLhalfNV(t) ) -> None',
	argNames = ('target', 's', 't',),
)

glMultiTexCoord2hvNV = platform.createExtensionFunction( 
	'glMultiTexCoord2hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLushortArray,),
	doc = 'glMultiTexCoord2hvNV( GLenum(target), GLushortArray(v) ) -> None',
	argNames = ('target', 'v',),
)

glMultiTexCoord3hNV = platform.createExtensionFunction( 
	'glMultiTexCoord3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glMultiTexCoord3hNV( GLenum(target), GLhalfNV(s), GLhalfNV(t), GLhalfNV(r) ) -> None',
	argNames = ('target', 's', 't', 'r',),
)

glMultiTexCoord3hvNV = platform.createExtensionFunction( 
	'glMultiTexCoord3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLushortArray,),
	doc = 'glMultiTexCoord3hvNV( GLenum(target), GLushortArray(v) ) -> None',
	argNames = ('target', 'v',),
)

glMultiTexCoord4hNV = platform.createExtensionFunction( 
	'glMultiTexCoord4hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glMultiTexCoord4hNV( GLenum(target), GLhalfNV(s), GLhalfNV(t), GLhalfNV(r), GLhalfNV(q) ) -> None',
	argNames = ('target', 's', 't', 'r', 'q',),
)

glMultiTexCoord4hvNV = platform.createExtensionFunction( 
	'glMultiTexCoord4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLushortArray,),
	doc = 'glMultiTexCoord4hvNV( GLenum(target), GLushortArray(v) ) -> None',
	argNames = ('target', 'v',),
)

glFogCoordhNV = platform.createExtensionFunction( 
	'glFogCoordhNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV,),
	doc = 'glFogCoordhNV( GLhalfNV(fog) ) -> None',
	argNames = ('fog',),
)

glFogCoordhvNV = platform.createExtensionFunction( 
	'glFogCoordhvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glFogCoordhvNV( GLushortArray(fog) ) -> None',
	argNames = ('fog',),
)

glSecondaryColor3hNV = platform.createExtensionFunction( 
	'glSecondaryColor3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glSecondaryColor3hNV( GLhalfNV(red), GLhalfNV(green), GLhalfNV(blue) ) -> None',
	argNames = ('red', 'green', 'blue',),
)

glSecondaryColor3hvNV = platform.createExtensionFunction( 
	'glSecondaryColor3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glSecondaryColor3hvNV( GLushortArray(v) ) -> None',
	argNames = ('v',),
)

glVertexWeighthNV = platform.createExtensionFunction( 
	'glVertexWeighthNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLhalfNV,),
	doc = 'glVertexWeighthNV( GLhalfNV(weight) ) -> None',
	argNames = ('weight',),
)

glVertexWeighthvNV = platform.createExtensionFunction( 
	'glVertexWeighthvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glVertexWeighthvNV( GLushortArray(weight) ) -> None',
	argNames = ('weight',),
)

glVertexAttrib1hNV = platform.createExtensionFunction( 
	'glVertexAttrib1hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLhalfNV,),
	doc = 'glVertexAttrib1hNV( GLuint(index), GLhalfNV(x) ) -> None',
	argNames = ('index', 'x',),
)

glVertexAttrib1hvNV = platform.createExtensionFunction( 
	'glVertexAttrib1hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, arrays.GLushortArray,),
	doc = 'glVertexAttrib1hvNV( GLuint(index), GLushortArray(v) ) -> None',
	argNames = ('index', 'v',),
)

glVertexAttrib2hNV = platform.createExtensionFunction( 
	'glVertexAttrib2hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertexAttrib2hNV( GLuint(index), GLhalfNV(x), GLhalfNV(y) ) -> None',
	argNames = ('index', 'x', 'y',),
)

glVertexAttrib2hvNV = platform.createExtensionFunction( 
	'glVertexAttrib2hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, arrays.GLushortArray,),
	doc = 'glVertexAttrib2hvNV( GLuint(index), GLushortArray(v) ) -> None',
	argNames = ('index', 'v',),
)

glVertexAttrib3hNV = platform.createExtensionFunction( 
	'glVertexAttrib3hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertexAttrib3hNV( GLuint(index), GLhalfNV(x), GLhalfNV(y), GLhalfNV(z) ) -> None',
	argNames = ('index', 'x', 'y', 'z',),
)

glVertexAttrib3hvNV = platform.createExtensionFunction( 
	'glVertexAttrib3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, arrays.GLushortArray,),
	doc = 'glVertexAttrib3hvNV( GLuint(index), GLushortArray(v) ) -> None',
	argNames = ('index', 'v',),
)

glVertexAttrib4hNV = platform.createExtensionFunction( 
	'glVertexAttrib4hNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV, constants.GLhalfNV,),
	doc = 'glVertexAttrib4hNV( GLuint(index), GLhalfNV(x), GLhalfNV(y), GLhalfNV(z), GLhalfNV(w) ) -> None',
	argNames = ('index', 'x', 'y', 'z', 'w',),
)

glVertexAttrib4hvNV = platform.createExtensionFunction( 
	'glVertexAttrib4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, arrays.GLushortArray,),
	doc = 'glVertexAttrib4hvNV( GLuint(index), GLushortArray(v) ) -> None',
	argNames = ('index', 'v',),
)

glVertexAttribs1hvNV = platform.createExtensionFunction( 
	'glVertexAttribs1hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLsizei, arrays.GLushortArray,),
	doc = 'glVertexAttribs1hvNV( GLuint(index), GLsizei(n), GLushortArray(v) ) -> None',
	argNames = ('index', 'n', 'v',),
)

glVertexAttribs2hvNV = platform.createExtensionFunction( 
	'glVertexAttribs2hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLsizei, arrays.GLushortArray,),
	doc = 'glVertexAttribs2hvNV( GLuint(index), GLsizei(n), GLushortArray(v) ) -> None',
	argNames = ('index', 'n', 'v',),
)

glVertexAttribs3hvNV = platform.createExtensionFunction( 
	'glVertexAttribs3hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLsizei, arrays.GLushortArray,),
	doc = 'glVertexAttribs3hvNV( GLuint(index), GLsizei(n), GLushortArray(v) ) -> None',
	argNames = ('index', 'n', 'v',),
)

glVertexAttribs4hvNV = platform.createExtensionFunction( 
	'glVertexAttribs4hvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint, constants.GLsizei, arrays.GLushortArray,),
	doc = 'glVertexAttribs4hvNV( GLuint(index), GLsizei(n), GLushortArray(v) ) -> None',
	argNames = ('index', 'n', 'v',),
)


def glInitHalfFloatNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
