import wx
import wx.html as html
class CHelp(wx.Frame):
	def __init__(self, parent, ID, title, pos=wx.DefaultPosition,size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE):
		
		wx.Frame.__init__(self, parent, ID, title, pos, size, style)
		self.gStatusBar = wx.StatusBar(self)
		self.gStatusBar.SetFieldsCount(1)
		self.SetStatusBar(self.gStatusBar)
		self.SetBackgroundColour(wx.Colour(200,200,200))
		
		# HTML window
		html.HtmlWindow_AddFilter(html.HtmlFilter())
		self.html =  html.HtmlWindow(self,style=wx.BORDER_SUNKEN)
		self.html.SetRelatedFrame(self,"%s")
		self.html.SetRelatedStatusBar(0)
		self.html.LoadPage('doc/html/help.html')
		self.html.SetSize(size)
		
		# Buttons
		l_gButPrev		= wx.Button(self,-1,'< Back')
		l_gButContents 	= wx.Button(self,-1,'Table of contents')
		l_gButNext 		= wx.Button(self,-1,'Forward >')
		l_gButHide 		= wx.Button(self,-1,'Hide')
			
		szButtons		= wx.BoxSizer(wx.HORIZONTAL)
		szButtons.Add(l_gButPrev,0, wx.FIXED_MINSIZE|wx.ALL, 2)
		szButtons.Add(l_gButContents,0, wx.FIXED_MINSIZE|wx.ALL, 2)
		szButtons.Add(l_gButNext,0, wx.FIXED_MINSIZE|wx.ALL, 2)
		szButtons.AddStretchSpacer()
		szButtons.Add(l_gButHide,0, wx.FIXED_MINSIZE|wx.ALIGN_RIGHT|wx.ALL, 2)
		
		szMain			= wx.BoxSizer(wx.VERTICAL)
		szMain.Add(szButtons,0, wx.EXPAND, 0)
		szMain.Add(self.html,1, wx.EXPAND, 0)
		
		self.SetSizer(szMain)
		self.SetAutoLayout(True)
		szMain.Fit(self)
		self.Layout()
		
		self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
		self.Bind(wx.EVT_BUTTON, self.OnPrev, l_gButPrev)
		self.Bind(wx.EVT_BUTTON, self.OnContents, l_gButContents)
		self.Bind(wx.EVT_BUTTON, self.OnNext, l_gButNext)
		self.Bind(wx.EVT_BUTTON, self.OnHide, l_gButHide)
	
	def OnPrev(self, event):
		if self.html.HistoryCanBack():
			self.html.HistoryBack()
		
	def OnNext(self, event):
		if self.html.HistoryCanForward():
			self.html.HistoryForward()
		
	def OnContents(self, event):
		self.html.ScrollToAnchor('contents')
	
	def OnCloseWindow(self, event):
		event.Veto()
		self.Hide()
		
	def OnHide(self, event):
		self.Hide()