#*****************************************************************************************
# File			: mextLOT.py
# Description	: An example plugin for computing the number of lines of text in a file.
#				  Provided guidelines offer support in customizing this plugin for other purposes.
# Version		: 1.0
# Copyright SolidSource B.V.
#*****************************************************************************************

import wx
import sta_metricgenerator
import os
import os.path
import subprocess
import sta_utils
import sta_globals
import time
import pysqlite2.dbapi2 as sqlite

	# EXPLANATION
	# This is an example and code template for building metric calculators

	# EXPLANATION
	# Markers like this are used in the source code of this template to indicate the places
	# that need to be modified when implementing a new metric calculator. The used markers are:
	# EXPLANATION	: no action required. This is only information to help understanding the code
	# TEMPLATE 		: the marked code needs to be updated with calculator specific data.
	# CODE			: the marked code needs to be replaced with calculator specific one.
	# MULTI			: the marked code needs to be augmented only when more tables are generated.

#===============================================================================
#													 Lines of text calculator
#===============================================================================
class MetricGenerator(sta_metricgenerator.MetricGenerator):
	def __init__(self,*args, **kwds):

		sta_metricgenerator.MetricGenerator.__init__(self,*args, **kwds)
		# TEMPLATE
		#----------------------------------------
		self.sName				= 'Lines of text counter'		# Metric name (to display in the calculators list)
		self.sAuthor			= 'SolidSource'					# Developer of this metric calculator
		self.sVersion			= '1.0'							# Version
		self.sID				= 'LOT'							# unique ID to be used during processing (folder name)
		self.sInfo		= '<strong>Description:</strong><br />'	# Short description for the calculator
		self.sInfo		= self.sInfo + 'Basic metric plugin.<br />'
		self.sInfo		= self.sInfo + 'Computes number of lines of text in a file.<br />'
		self.sInfo		= self.sInfo + 'Can be used as template for building metric plugins.<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Requires:</strong><br />'
		self.sInfo		= self.sInfo + 'Source code of files.<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Output metrics:</strong><br />'
		self.sInfo		= self.sInfo + 'Lines of text'

		self.sExtensionsList	= ['c','cc','cpp','cxx','c++','h','hh','hpp','hxx','h++','cs','j','js','jav','java','py','pl','php','htm','html','txt']
																# List of files extensions on which this calculatro can be applied
																# If file type independent, leave this list empty
		# MULTI
		#----------------------------------------
		self.sTableID			= 'M_SS2008021201'				# Unique ID for the generated metrics table
		self.sTableName			= 'Lines of text'				# Name of generated metrics table (to display in the Calculated metrics list)
		self.iType				= 1								# Metric type: 0 - file , 1 - version
		self.sTableDescription	= 'Version metric.<br />Gives number of lines of text in a text based file'
																# Short description for the computed metrics(to be displayed in the info panel)
		#----------------------------------------
		# END MULTI
		# END TEMPLATE

		# EXPLANATION:
		# sTableID, sTableName, iType and sTableDescription are specific to each generated metrics table in the DB.
		# When more tables are generated by the calculator, copies of each of these variables needs to be made
		# for each table, and need to be handled in the code in the places indicated by the #MULTI marker

#===============================================================================
#																	 Generate
#===============================================================================

	def generate_TFS(self, p_cCursorDB):
		#--------------------------- Task folders ---
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/taskbuffer/"+self.sID
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)
		l_sDestPath = l_sPath+"/content.dat"

		for l_cFile in sta_globals.lSelectedFiles:
			sta_globals.GUI.MainThreadExec('self.cbGeneratorProgressUpdate()')

			#--- Check if cancel pressed
			if sta_globals.GUI.bMetricCancel:
				break

			#--- Skip unsupported files
			l_sFile,l_sExtension = os.path.splitext(l_cFile.sPath)
			if (l_sExtension != ''):
				l_sExtension = l_sExtension[1:]
			l_sExtension = l_sExtension.lower()

			if not((len(self.sExtensionsList)==0) or (l_sExtension in self.sExtensionsList)):
				continue

			zipFile = sta_globals.cSTAPrj.storagePath()+"/extra/files/"+str(l_cFile.iDBid)+".zip"
			if not os.path.exists(zipFile):
				continue

			try:
				versions = sta_utils.listArchive(zipFile)
			except:
				continue

			for l_cCommit in l_cFile.lRevs:

				if sta_globals.GUI.bMetricCancel:
					break

				if l_cCommit.sID not in versions:
					continue

				if self.calculated(l_cCommit, p_cCursorDB):
					continue

				try:
					l_sContent = sta_utils.readFile(zipFile, l_cCommit.sID)
				except:
					sta_utils.dprint("%s: Could not read %s <%d>\n"%(self.sID,l_cFile.sPath,l_cCommit.sID))
					continue

				self.calculateLOT(l_cCommit, l_sContent, l_sDestPath, p_cCursorDB)

	def generate_aux(self,p_sSrcArchive,p_iTime,p_cCursorDB):

		#--------------------------- Task folders ---
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/taskbuffer/"+self.sID
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)
		l_sDestPath = l_sPath+"/content.dat"

		l_lFiles = sta_utils.listArchive(p_sSrcArchive)

		#--------------------------- Generate metrics for all files ---
		# EXPLANATION
		# The way in which a metric is computed can depend very much on the specific calculator.
		# In most cases metrics are calculated incrementaly, taking into account only new files.
		# In such a cese there are three steps to be performed:
		#		- test whether the metric is already computed
		#		- compute the metric by interpreting the information contained in the snapshot
		#		- save the metric in the DB for the corresponding revision

		for l_cFile in sta_globals.lSelectedFiles:
			sta_globals.GUI.MainThreadExec('self.cbGeneratorProgressUpdate()')

			#--- Check if cancel pressed
			if sta_globals.GUI.bMetricCancel:
				break

			sta_globals.GUI.MainThreadExec('self.logCommand(" - "+$STA$+"\\n")',lParams=[l_cFile.sName])

			#--- Skip non-existing files
			l_sFileName = str(l_cFile.iDBid)
			if (l_sFileName not in l_lFiles):
				continue

			#--- Skip unsupported files
			l_sFile,l_sExtension = os.path.splitext(l_cFile.sPath)
			if (l_sExtension != ''):
				l_sExtension = l_sExtension[1:]
			l_sExtension = l_sExtension.lower()

			if not((len(self.sExtensionsList)==0) or (l_sExtension in self.sExtensionsList)):
				continue

			#--- Get snapshot revision
			l_cCommit = None
			for l_cRev in l_cFile.lRevs:	# Find first revision before snapshot
				if (l_cRev.iTime <= p_iTime):
					l_cCommit = l_cRev
				else:
					break
			if not (l_cCommit is None):
				if (p_iTime > l_cFile.lRevs[-1].iTime) and (l_cFile.iStatus != 0):
					l_cCommit = None
			if (l_cCommit is None):
				continue

			if self.calculated(l_cCommit, p_cCursorDB):
				continue

			try:
				l_sContent = sta_utils.readFile(p_sSrcArchive1,l_sFileName)
			except:
				sta_utils.dprint("%s: Could not read %s <%s>\n"%(self.sID,l_cFile.sPath,l_sFileName))
				continue

			self.calculateLOT(l_cCommit, l_sContent, l_sDestPath, p_cCursorDB)

	def calculated(self, l_cCommit, p_cCursorDB):
		sCmd = "select ID from "+self.sTableID+" where ID="+str(l_cCommit.iDBid)
		p_cCursorDB.execute(sCmd)
		return p_cCursorDB.fetchone() != None

	def calculateLOT(self,l_cCommit,l_sContent,l_sDestPath,p_cCursorDB):

			fileHandle=open(l_sDestPath,"w")
			fileHandle.write(l_sContent)
			fileHandle.close()

			# CODE
			#----------------------------------------
			# compute the metric based on the contents of the given version
			# This example counts the number of text lines in the version and stroes it in l_iLOT
			# In this example l_iLOT stores the computed metric

			l_iLOT = -1
			if os.path.exists(l_sDestPath):
				l_iLOT = 0
				fileHandle=open(l_sDestPath,"r")
				sLine = fileHandle.readline()
				while sLine!= '':
					sLine = sLine.lstrip()
					sLine = sLine.rstrip()
					if (sLine != ''):
						l_iLOT += 1
					sLine = fileHandle.readline()
				fileHandle.close()
			else:
				print "Problem!", l_cCommit.iDBid
			#----------------------------------------
			# END CODE

			# TEMPLATE
			# MULTI
			#----------------------------------------
			# save metric in DB
			# Action:
			#	- replace tre (l_iLOT>=0) condition with a specific condition to indicate that the metric has been computed
			#	- replace (ID,LOT) with specific table structure
			#	- replace the addition of l_iLOT to sParam with the actual computed metric
			#	- repeat this code snipet for all tables (i.e., sTableIDs if more of them exist)

			if (l_iLOT>=0):
				sCmdRoot = "insert into "+self.sTableID+"(ID,LOT) values (%s,%s)"
				sParam = []
				sParam.append(l_cCommit.iDBid)
				sParam.append(l_iLOT)
				sCmd = sCmdRoot%tuple(sParam)
				p_cCursorDB.execute(sCmd)
			#----------------------------------------
			# END MULTI
			# END TEMPLATE

	#-------------------------------------------------------------------------------
	#																Main entry point
	#-------------------------------------------------------------------------------
	def generate(self,p_sDBPath):

		if not sta_utils.isValidDB(p_sDBPath):
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: no history information found\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')
			return

		cDB = sqlite.connect(p_sDBPath)
		cCursorDB = cDB.cursor()

		# TEMPLATE
		# MULTI
		#----------------------------------------
		# Action:
		#	- Replace '(ID integer primary key, LOT integer)' with specific table structure. ID column needs to be alsways present
		#	- In case remove/clean dependencies exist between more tables, they need to be specified in the Dependenices
		#		column of the Metrics table as a string containing sTableIDs separated by ':'. In this example there are no
		#		dependencies (i.e., when deleting the generated table, no other tables need to be also removed
		#		in order to keep the DB clean). When dependencies exist, however, one need to replace the null in
		#		('%s','%s',%s,'%s',null) with '%s' and add the appropriate dependencies string to the sParam list
		#	- Repeat the code snipet for all generated tables (if more)

		if not (sta_utils.isValidTable(cCursorDB,self.sTableID)):
			sCmd = "create table "+self.sTableID+"(ID integer primary key, LOT integer)"
			cCursorDB.execute(sCmd)

			sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',%s,'%s',null)"
			sParam = [self.sTableID,self.sTableName,str(self.iType),self.sTableDescription]
			sCmd = sCmdRoot%tuple(sParam)
			cCursorDB.execute(sCmd)
		#----------------------------------------
		# END MULTI
		# END EMPLATE

		if sta_globals.cSTAPrj.sType == 'GIT' or sta_globals.cSTAPrj.sType == 'TFS':
			self.generate_TFS(cCursorDB)
		else:
			# Calculate metrics for all snapshots
			l_sSrcArchiveBase	= sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"
			for l_cSnapshot in sta_globals.cSTAPrj.lSnapshots:

				if sta_globals.GUI.bMetricCancel:
					sta_globals.GUI.bMetricCancel = False
					break

				l_sDate = time.strftime("%Y%m%d_%H%S%M",time.gmtime(l_cSnapshot[0]))
				l_sSrcArchive = l_sSrcArchiveBase+"/"+l_sDate+".zip"
				l_sSrcArchive = l_sSrcArchive.replace('\\','/')
				self.generate_aux(l_sSrcArchive,l_cSnapshot[0],cCursorDB)

				sta_globals.GUI.MainThreadExec('self.logCommand("Snapshot: "+$STA$+" generation completed\\n")',lParams=[l_cSnapshot[1]])

		# close database
		cDB.commit()
		cCursorDB.close()
		cDB.close()

		sta_globals.GUI.MainThreadExec('self.UpdateFiltersList()')
		sta_globals.GUI.MainThreadExec('self.logCommand("Finished: "+$STA$+" generation\\n")',lParams=[self.sName])
		sta_globals.GUI.MainThreadExec('self.postGenerator()')
