#*****************************************************************************************
# File			: mextTFSWorkItems.py
# Description	: A plugin for extracting version associated Work Items from TFS
# Version		: 1.0
# Copyright Joost Koehoorn
#*****************************************************************************************

import wx
import sta_metricgenerator
import os
import os.path
import subprocess
import sta_utils
import sta_globals
import time
import pysqlite2.dbapi2 as sqlite

#===============================================================================
#													 Lines of text calculator
#===============================================================================
class MetricGenerator(sta_metricgenerator.MetricGenerator):
	def __init__(self,*args, **kwds):

		sta_metricgenerator.MetricGenerator.__init__(self,*args, **kwds)
		# TEMPLATE
		#----------------------------------------
		self.sName				= 'TFS Work Items'				# Metric name (to display in the calculators list)
		self.sAuthor			= 'Joost Koehoorn'				# Developer of this metric calculator
		self.sVersion			= '1.0'							# Version
		self.sInfo		= '<strong>Description:</strong><br />'	# Short description for the calculator
		self.sInfo		= self.sInfo + 'Extracts version associated Work Items from TFS.<br />'

		self.sInfo		= self.sInfo + '<strong>Requires:</strong><br />'
		self.sInfo		= self.sInfo + 'A TFS repository<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Output metrics:</strong><br />'
		self.sInfo		= self.sInfo + 'Work Items'

		self.sExtensionsList	= []
																# List of files extensions on which this calculatro can be applied
																# If file type independent, leave this list empty
		# MULTI
		#----------------------------------------
		self.sTableID			= 'M_JK2013051501'				# Unique ID for the generated metrics table
		self.sTableName			= 'TFS Work Items'				# Name of generated metrics table (to display in the Calculated metrics list)
		self.iType				= 1								# Metric type: 0 - file , 1 - version
		self.sTableDescription	= 'Version associated Work Items from a TFS repository'
																# Short description for the computed metrics(to be displayed in the info panel)
		#----------------------------------------
		# END MULTI
		# END TEMPLATE

		# EXPLANATION:
		# sTableID, sTableName, iType and sTableDescription are specific to each generated metrics table in the DB.
		# When more tables are generated by the calculator, copies of each of these variables needs to be made
		# for each table, and need to be handled in the code in the places indicated by the #MULTI marker

	#-------------------------------------------------------------------------------
	#																Main entry point
	#-------------------------------------------------------------------------------
	def generate(self,p_sDBPath):

		if not sta_utils.isValidDB(p_sDBPath):
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: no history information found\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')
			return

		sta_globals.GUI.TFSImporter('work-items')

		sta_globals.GUI.MainThreadExec('self.UpdateFiltersList()')
		sta_globals.GUI.MainThreadExec('self.logCommand("Finished: "+$STA$+" generation\\n")',lParams=[self.sName])
		sta_globals.GUI.MainThreadExec('self.postGenerator()')
