﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpDeps.Scopes;
using ICSharpCode.NRefactory.CSharp.Resolver;

namespace CSharpDeps.Visitors
{
    class NamespaceVisitor : ClassContainerVisitor
    {
        public File File { get; private set; }

        public Namespace Namespace { get; private set; }

        protected Stack<Class> Classes = new Stack<Class>();

        public NamespaceVisitor(CSharpAstResolver resolver, File file, Namespace ns)
            : base(resolver)
        {
            File = file;
            Namespace = ns;
        }

        public override void VisitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration)
        {
            var ns = new Namespace(namespaceDeclaration.FullName);

            VisitChildren(namespaceDeclaration, new NamespaceVisitor(Resolver, File, ns));

            File.AddNamespace(ns);
        }

        public override void VisitTypeDeclaration(TypeDeclaration typeDeclaration)
        {
            var type = TranslateType(typeDeclaration.ClassType);
            var klass = new Class(type, Namespace, null, typeDeclaration.Name);

            DecorateClass(klass, typeDeclaration);

            VisitChildren(typeDeclaration, new ClassVisitor(Resolver, klass));

            Namespace.AddClass(klass);
        }
    }
}
