﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CSharpMetrics.Scopes;

namespace CSharpMetrics.Scopes
{
    public class File
    {
        public string Name { get; set; }

        public int LOC { get; set; }

        public int CLOC { get; set; }

        public int NrImports { get; set; }

        protected Dictionary<string, Namespace> namespaces = new Dictionary<string, Namespace>();

        public Dictionary<string, Namespace> Namespaces
        {
            get { return namespaces; }
        }

        public int NrClasses
        {
            get { return Namespaces.Values.Sum(ns => ns.NrClasses); }
        }

        public int NrMethods
        {
            get { return Namespaces.Values.Sum(ns => ns.Classes.Values.Sum(c => c.NrMethods)); }
        }

        public int Complexity
        {
            get { return Namespaces.Values.Sum(ns => ns.Classes.Values.Sum(c => c.Complexity)); }
        }

        public int Invocations
        {
            get { return Namespaces.Values.Sum(ns => ns.Classes.Values.Sum(c => c.Invocations)); }
        }

        public File(string name)
        {
            Name = name;
            LOC = 1;
            CLOC = 0;
            NrImports = 0;
        }

        public void AddNamespace(Namespace ns)
        {
            if (Namespaces.ContainsKey(ns.FullName))
            {
                Namespaces[ns.FullName].MergeNamespace(ns);
            }
            else
            {
                Namespaces[ns.FullName] = ns;
            }
        }
    }
}
