﻿using System;
using System.Collections.Generic;

namespace SolidTA.SCMImporter
{
    public class ChangeSet
    {
        public enum ChangeType
        {
            None = 1,
            Add = 2,
            Edit = 4,
            //Encoding = 8,
            //Rename = 16,
            Delete = 32
        };
        public class Change
        {
            public Item Item { get; private set; }
            public ChangeType ChangeType { get; private set; }

            public Change(Item item, ChangeType changeType)
            {
                Item = item;
                ChangeType = changeType;
            }
        };

        public int ChangesetId { get; private set; }
        public DateTime CreationDate { get; private set; }
        public string Committer { get; private set; }
        public string Comment { get; private set; }
        public List<Change> Changes { get; private set; }

        public ChangeSet(int id, DateTime creation_date, string committer, string comment, List<Change> changes)
        {
            ChangesetId = id;
            CreationDate = creation_date;
            Committer = committer;
            Comment = comment;
            Changes = changes;
        }
    }
}
