﻿using System;

namespace SolidTA.SCMImporter
{
    class SCMServerFactory
    {
        public enum MODE {
            GIT,
            TFS,
        }

        public static SCMServer Create(MODE mode)
        {
            switch (mode) {
                case MODE.GIT:
                    return new GitServer();
                case MODE.TFS:
                    return new TFSServer();
                default:
                    throw new NotImplementedException("This type of SCM is not implemented.");
            }
        }
    }
}
